/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.impl.FlinkCompletableFuture;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.execution.SuppressRestartsException;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.metrics.RestartTimeGauge;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.instance.Slot;
import org.apache.flink.runtime.instance.SlotProvider;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobmanager.scheduler.ScheduledUnit;
import org.apache.flink.runtime.jobmanager.scheduler.Scheduler;
import org.apache.flink.runtime.jobmanager.slots.AllocatedSlot;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.taskmanager.TaskExecutionState;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.testtasks.NoOpInvokable;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class ExecutionGraphMetricsTest
extends TestLogger {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecutionGraphRestartTimeMetric() throws JobException, IOException, InterruptedException {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        try {
            long currentRestartingTime;
            int i;
            long currentRestartingTime2;
            int parallelism = 1;
            JobVertex jobVertex = new JobVertex("TestVertex");
            jobVertex.setParallelism(parallelism);
            jobVertex.setInvokableClass(NoOpInvokable.class);
            JobGraph jobGraph = new JobGraph("Test Job", new JobVertex[]{jobVertex});
            Configuration jobConfig = new Configuration();
            Time timeout = Time.seconds((long)10L);
            Scheduler scheduler = (Scheduler)Mockito.mock(Scheduler.class);
            ResourceID taskManagerId = ResourceID.generate();
            TaskManagerLocation taskManagerLocation = (TaskManagerLocation)Mockito.mock(TaskManagerLocation.class);
            Mockito.when((Object)taskManagerLocation.getResourceID()).thenReturn((Object)taskManagerId);
            Mockito.when((Object)taskManagerLocation.getHostname()).thenReturn((Object)"localhost");
            TaskManagerGateway taskManagerGateway = (TaskManagerGateway)Mockito.mock(TaskManagerGateway.class);
            Instance instance = (Instance)Mockito.mock(Instance.class);
            Mockito.when((Object)instance.getTaskManagerLocation()).thenReturn((Object)taskManagerLocation);
            Mockito.when((Object)instance.getTaskManagerID()).thenReturn((Object)taskManagerId);
            Mockito.when((Object)instance.getTaskManagerGateway()).thenReturn((Object)taskManagerGateway);
            Slot rootSlot = (Slot)Mockito.mock(Slot.class);
            AllocatedSlot mockAllocatedSlot = (AllocatedSlot)Mockito.mock(AllocatedSlot.class);
            Mockito.when((Object)mockAllocatedSlot.getSlotAllocationId()).thenReturn((Object)new AllocationID());
            SimpleSlot simpleSlot = (SimpleSlot)Mockito.mock(SimpleSlot.class);
            Mockito.when((Object)simpleSlot.isAlive()).thenReturn((Object)true);
            Mockito.when((Object)simpleSlot.getTaskManagerLocation()).thenReturn((Object)taskManagerLocation);
            Mockito.when((Object)simpleSlot.getTaskManagerID()).thenReturn((Object)taskManagerId);
            Mockito.when((Object)simpleSlot.getTaskManagerGateway()).thenReturn((Object)taskManagerGateway);
            Mockito.when((Object)simpleSlot.setExecutedVertex((Execution)Matchers.any(Execution.class))).thenReturn((Object)true);
            Mockito.when((Object)simpleSlot.getRoot()).thenReturn((Object)rootSlot);
            Mockito.when((Object)simpleSlot.getAllocatedSlot()).thenReturn((Object)mockAllocatedSlot);
            FlinkCompletableFuture future = new FlinkCompletableFuture();
            future.complete((Object)simpleSlot);
            Mockito.when((Object)scheduler.allocateSlot((ScheduledUnit)Mockito.any(ScheduledUnit.class), Mockito.anyBoolean())).thenReturn((Object)future);
            Mockito.when((Object)rootSlot.getSlotNumber()).thenReturn((Object)0);
            Mockito.when((Object)taskManagerGateway.submitTask((TaskDeploymentDescriptor)Mockito.any(TaskDeploymentDescriptor.class), (Time)Mockito.any(Time.class))).thenReturn((Object)FlinkCompletableFuture.completed((Object)Acknowledge.get()));
            TestingRestartStrategy testingRestartStrategy = new TestingRestartStrategy();
            ExecutionGraph executionGraph = new ExecutionGraph(executor, (Executor)executor, jobGraph.getJobID(), jobGraph.getName(), jobConfig, new SerializedValue(null), timeout, (RestartStrategy)testingRestartStrategy, (SlotProvider)scheduler);
            RestartTimeGauge restartingTime = new RestartTimeGauge(executionGraph);
            Assert.assertEquals((long)0L, (long)restartingTime.getValue());
            executionGraph.attachJobGraph(jobGraph.getVerticesSortedTopologicallyFromSources());
            executionGraph.scheduleForExecution();
            Assert.assertEquals((long)0L, (long)restartingTime.getValue());
            ArrayList<ExecutionAttemptID> executionIDs = new ArrayList<ExecutionAttemptID>();
            for (ExecutionVertex executionVertex : executionGraph.getAllExecutionVertices()) {
                executionIDs.add(executionVertex.getCurrentExecutionAttempt().getAttemptId());
            }
            for (ExecutionAttemptID executionID : executionIDs) {
                executionGraph.updateState(new TaskExecutionState(jobGraph.getJobID(), executionID, ExecutionState.RUNNING));
            }
            Assert.assertEquals((Object)JobStatus.RUNNING, (Object)executionGraph.getState());
            Assert.assertEquals((long)0L, (long)restartingTime.getValue());
            for (ExecutionAttemptID executionID : executionIDs) {
                executionGraph.updateState(new TaskExecutionState(jobGraph.getJobID(), executionID, ExecutionState.FAILED, (Throwable)new Exception()));
            }
            Assert.assertEquals((Object)JobStatus.RESTARTING, (Object)executionGraph.getState());
            long firstRestartingTimestamp = executionGraph.getStatusTimestamp(JobStatus.RESTARTING);
            Thread.sleep(50L);
            long previousRestartingTime = restartingTime.getValue();
            for (int i2 = 0; i2 < 10; ++i2) {
                currentRestartingTime2 = restartingTime.getValue();
                Assert.assertTrue((currentRestartingTime2 >= previousRestartingTime ? 1 : 0) != 0);
                previousRestartingTime = currentRestartingTime2;
            }
            Assert.assertTrue((previousRestartingTime > 0L ? 1 : 0) != 0);
            testingRestartStrategy.restartExecutionGraph();
            executionIDs.clear();
            for (ExecutionVertex executionVertex : executionGraph.getAllExecutionVertices()) {
                executionIDs.add(executionVertex.getCurrentExecutionAttempt().getAttemptId());
            }
            for (ExecutionAttemptID executionID : executionIDs) {
                executionGraph.updateState(new TaskExecutionState(jobGraph.getJobID(), executionID, ExecutionState.RUNNING));
            }
            Assert.assertEquals((Object)JobStatus.RUNNING, (Object)executionGraph.getState());
            Assert.assertTrue((firstRestartingTimestamp != 0L ? 1 : 0) != 0);
            previousRestartingTime = restartingTime.getValue();
            for (int i3 = 0; i3 < 10; ++i3) {
                currentRestartingTime2 = restartingTime.getValue();
                Assert.assertTrue((currentRestartingTime2 == previousRestartingTime ? 1 : 0) != 0);
                previousRestartingTime = currentRestartingTime2;
            }
            for (ExecutionAttemptID executionID : executionIDs) {
                executionGraph.updateState(new TaskExecutionState(jobGraph.getJobID(), executionID, ExecutionState.FAILED, (Throwable)new Exception()));
            }
            Assert.assertEquals((Object)JobStatus.RESTARTING, (Object)executionGraph.getState());
            long secondRestartingTimestamp = executionGraph.getStatusTimestamp(JobStatus.RESTARTING);
            Assert.assertTrue((firstRestartingTimestamp != secondRestartingTimestamp ? 1 : 0) != 0);
            Thread.sleep(50L);
            previousRestartingTime = restartingTime.getValue();
            for (i = 0; i < 10; ++i) {
                currentRestartingTime = restartingTime.getValue();
                Assert.assertTrue((currentRestartingTime >= previousRestartingTime ? 1 : 0) != 0);
                previousRestartingTime = currentRestartingTime;
            }
            Assert.assertTrue((previousRestartingTime > 0L ? 1 : 0) != 0);
            executionGraph.failGlobal((Throwable)new SuppressRestartsException((Throwable)new Exception()));
            Assert.assertEquals((Object)JobStatus.FAILED, (Object)executionGraph.getState());
            previousRestartingTime = restartingTime.getValue();
            for (i = 0; i < 10; ++i) {
                currentRestartingTime = restartingTime.getValue();
                Assert.assertTrue((currentRestartingTime == previousRestartingTime ? 1 : 0) != 0);
                previousRestartingTime = currentRestartingTime;
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    static class TestingRestartStrategy
    implements RestartStrategy {
        private boolean restartable = true;
        private ExecutionGraph executionGraph = null;

        TestingRestartStrategy() {
        }

        public boolean canRestart() {
            return this.restartable;
        }

        public void restart(ExecutionGraph executionGraph) {
            this.executionGraph = executionGraph;
        }

        public void setRestartable(boolean restartable) {
            this.restartable = restartable;
        }

        public void restartExecutionGraph() {
            this.executionGraph.restart();
        }
    }
}

