/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.concurrent.Future;
import org.apache.flink.runtime.concurrent.impl.FlinkCompletableFuture;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionAndSlot;
import org.apache.flink.runtime.executiongraph.ExecutionGraphUtils;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.instance.Slot;
import org.apache.flink.runtime.jobmanager.slots.AllocatedSlot;
import org.apache.flink.runtime.jobmanager.slots.SlotOwner;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ExecutionGraphUtilsTest {
    @Test
    public void testReleaseSlots() {
        JobID jid = new JobID();
        SlotOwner owner = (SlotOwner)Mockito.mock(SlotOwner.class);
        SimpleSlot slot1 = new SimpleSlot(ExecutionGraphUtilsTest.createAllocatedSlot(jid, 0), owner, 0);
        SimpleSlot slot2 = new SimpleSlot(ExecutionGraphUtilsTest.createAllocatedSlot(jid, 1), owner, 1);
        SimpleSlot slot3 = new SimpleSlot(ExecutionGraphUtilsTest.createAllocatedSlot(jid, 2), owner, 2);
        FlinkCompletableFuture incompleteFuture = new FlinkCompletableFuture();
        FlinkCompletableFuture completeFuture = new FlinkCompletableFuture();
        completeFuture.complete((Object)slot2);
        FlinkCompletableFuture disposedSlotFuture = new FlinkCompletableFuture();
        slot3.releaseSlot();
        disposedSlotFuture.complete((Object)slot3);
        ExecutionGraphUtils.releaseSlotFuture((Future)incompleteFuture);
        ExecutionGraphUtils.releaseSlotFuture((Future)completeFuture);
        ExecutionGraphUtils.releaseSlotFuture((Future)disposedSlotFuture);
        incompleteFuture.complete((Object)slot1);
        ((SlotOwner)Mockito.verify((Object)owner, (VerificationMode)Mockito.times((int)1))).returnAllocatedSlot((Slot)Mockito.eq((Object)slot1));
        ((SlotOwner)Mockito.verify((Object)owner, (VerificationMode)Mockito.times((int)1))).returnAllocatedSlot((Slot)Mockito.eq((Object)slot2));
        ((SlotOwner)Mockito.verify((Object)owner, (VerificationMode)Mockito.times((int)1))).returnAllocatedSlot((Slot)Mockito.eq((Object)slot3));
    }

    @Test
    public void testReleaseSlotsWithNulls() {
        JobID jid = new JobID();
        SlotOwner owner = (SlotOwner)Mockito.mock(SlotOwner.class);
        Execution mockExecution = (Execution)Mockito.mock(Execution.class);
        SimpleSlot slot1 = new SimpleSlot(ExecutionGraphUtilsTest.createAllocatedSlot(jid, 0), owner, 0);
        SimpleSlot slot2 = new SimpleSlot(ExecutionGraphUtilsTest.createAllocatedSlot(jid, 1), owner, 1);
        SimpleSlot slot3 = new SimpleSlot(ExecutionGraphUtilsTest.createAllocatedSlot(jid, 2), owner, 2);
        SimpleSlot slot4 = new SimpleSlot(ExecutionGraphUtilsTest.createAllocatedSlot(jid, 3), owner, 3);
        SimpleSlot slot5 = new SimpleSlot(ExecutionGraphUtilsTest.createAllocatedSlot(jid, 4), owner, 4);
        ExecutionAndSlot[] slots1 = new ExecutionAndSlot[]{null, new ExecutionAndSlot(mockExecution, (Future)FlinkCompletableFuture.completed((Object)slot1)), null, new ExecutionAndSlot(mockExecution, (Future)FlinkCompletableFuture.completed((Object)slot2)), null};
        ExecutionAndSlot[] slots2 = new ExecutionAndSlot[]{new ExecutionAndSlot(mockExecution, (Future)FlinkCompletableFuture.completed((Object)slot3)), new ExecutionAndSlot(mockExecution, (Future)FlinkCompletableFuture.completed((Object)slot4)), new ExecutionAndSlot(mockExecution, (Future)FlinkCompletableFuture.completed((Object)slot5))};
        List resources = Arrays.asList(null, slots1, new ExecutionAndSlot[0], null, slots2);
        ExecutionGraphUtils.releaseAllSlotsSilently(resources);
        ((SlotOwner)Mockito.verify((Object)owner, (VerificationMode)Mockito.times((int)1))).returnAllocatedSlot((Slot)Mockito.eq((Object)slot1));
        ((SlotOwner)Mockito.verify((Object)owner, (VerificationMode)Mockito.times((int)1))).returnAllocatedSlot((Slot)Mockito.eq((Object)slot2));
        ((SlotOwner)Mockito.verify((Object)owner, (VerificationMode)Mockito.times((int)1))).returnAllocatedSlot((Slot)Mockito.eq((Object)slot3));
        ((SlotOwner)Mockito.verify((Object)owner, (VerificationMode)Mockito.times((int)1))).returnAllocatedSlot((Slot)Mockito.eq((Object)slot4));
        ((SlotOwner)Mockito.verify((Object)owner, (VerificationMode)Mockito.times((int)1))).returnAllocatedSlot((Slot)Mockito.eq((Object)slot5));
    }

    private static AllocatedSlot createAllocatedSlot(JobID jid, int num) {
        TaskManagerLocation loc = new TaskManagerLocation(ResourceID.generate(), InetAddress.getLoopbackAddress(), 10000 + num);
        return new AllocatedSlot(new AllocationID(), jid, loc, num, ResourceProfile.UNKNOWN, (TaskManagerGateway)Mockito.mock(TaskManagerGateway.class));
    }
}

