/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import org.apache.flink.runtime.execution.SuppressRestartsException;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphException;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.restart.InfiniteDelayRestartStrategy;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.junit.Assert;
import org.junit.Test;

public class ExecutionGraphVariousFailuesTest {
    @Test
    public void testFailureWhileRestarting() throws Exception {
        ExecutionGraph eg = ExecutionGraphTestUtils.createSimpleTestGraph(new InfiniteDelayRestartStrategy(2));
        eg.scheduleForExecution();
        Assert.assertEquals((Object)JobStatus.RUNNING, (Object)eg.getState());
        ExecutionGraphTestUtils.switchAllVerticesToRunning(eg);
        eg.failGlobal((Throwable)new Exception("Test 1"));
        Assert.assertEquals((Object)JobStatus.FAILING, (Object)eg.getState());
        ExecutionGraphTestUtils.completeCancellingForAllVertices(eg);
        Assert.assertEquals((Object)JobStatus.RESTARTING, (Object)eg.getState());
        eg.failGlobal((Throwable)new Exception("Test 2"));
        Assert.assertEquals((Object)JobStatus.RESTARTING, (Object)eg.getState());
        eg.failGlobal((Throwable)new Exception("Test 3"));
        Assert.assertEquals((Object)JobStatus.FAILED, (Object)eg.getState());
    }

    @Test
    public void testSuppressRestartFailureWhileRestarting() throws Exception {
        ExecutionGraph eg = ExecutionGraphTestUtils.createSimpleTestGraph(new InfiniteDelayRestartStrategy(10));
        eg.scheduleForExecution();
        Assert.assertEquals((Object)JobStatus.RUNNING, (Object)eg.getState());
        ExecutionGraphTestUtils.switchAllVerticesToRunning(eg);
        eg.failGlobal((Throwable)new Exception("test"));
        Assert.assertEquals((Object)JobStatus.FAILING, (Object)eg.getState());
        ExecutionGraphTestUtils.completeCancellingForAllVertices(eg);
        Assert.assertEquals((Object)JobStatus.RESTARTING, (Object)eg.getState());
        eg.failGlobal((Throwable)new SuppressRestartsException((Throwable)new Exception("Test")));
        Assert.assertEquals((Object)JobStatus.FAILED, (Object)eg.getState());
    }

    @Test
    public void testFailingScheduleOrUpdateConsumers() throws Exception {
        ExecutionGraph eg = ExecutionGraphTestUtils.createSimpleTestGraph(new InfiniteDelayRestartStrategy(10));
        eg.scheduleForExecution();
        Assert.assertEquals((Object)JobStatus.RUNNING, (Object)eg.getState());
        ExecutionGraphTestUtils.switchAllVerticesToRunning(eg);
        IntermediateResultPartitionID intermediateResultPartitionId = new IntermediateResultPartitionID();
        ExecutionAttemptID producerId = new ExecutionAttemptID();
        ResultPartitionID resultPartitionId = new ResultPartitionID(intermediateResultPartitionId, producerId);
        try {
            eg.scheduleOrUpdateConsumers(resultPartitionId);
            Assert.fail((String)"Expected ExecutionGraphException.");
        }
        catch (ExecutionGraphException executionGraphException) {
            // empty catch block
        }
        Assert.assertEquals((Object)JobStatus.RUNNING, (Object)eg.getState());
    }
}

