/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.Collections;
import java.util.Random;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.failover.FailoverStrategy;
import org.apache.flink.runtime.executiongraph.restart.InfiniteDelayRestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.executiongraph.utils.SimpleSlotProvider;
import org.apache.flink.runtime.instance.SlotProvider;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.testtasks.NoOpInvokable;
import org.apache.flink.util.SerializedValue;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class GlobalModVersionTest {
    @Test
    public void testNoLocalFailoverWhileCancelling() throws Exception {
        Execution exec;
        FailoverStrategy mockStrategy = (FailoverStrategy)Mockito.mock(FailoverStrategy.class);
        ExecutionGraph graph = this.createSampleGraph(mockStrategy);
        ExecutionVertex testVertex = GlobalModVersionTest.getRandomVertex(graph);
        graph.scheduleForExecution();
        Assert.assertEquals((Object)JobStatus.RUNNING, (Object)graph.getState());
        Assert.assertEquals((long)1L, (long)graph.getGlobalModVersion());
        for (ExecutionVertex v : ((ExecutionJobVertex)graph.getVerticesTopologically().iterator().next()).getTaskVertices()) {
            exec = v.getCurrentExecutionAttempt();
            ExecutionGraphTestUtils.waitUntilExecutionState(exec, ExecutionState.DEPLOYING, 1000L);
            exec.switchToRunning();
            Assert.assertEquals((Object)ExecutionState.RUNNING, (Object)exec.getState());
        }
        graph.cancel();
        Assert.assertEquals((long)2L, (long)graph.getGlobalModVersion());
        for (ExecutionVertex v : ((ExecutionJobVertex)graph.getVerticesTopologically().iterator().next()).getTaskVertices()) {
            exec = v.getCurrentExecutionAttempt();
            Assert.assertEquals((Object)ExecutionState.CANCELING, (Object)exec.getState());
        }
        testVertex.getCurrentExecutionAttempt().fail((Throwable)new Exception("test exception"));
        for (ExecutionVertex v : ((ExecutionJobVertex)graph.getVerticesTopologically().iterator().next()).getTaskVertices()) {
            exec = v.getCurrentExecutionAttempt();
            exec.cancelingComplete();
        }
        Assert.assertEquals((Object)JobStatus.CANCELED, (Object)graph.getState());
        ((FailoverStrategy)Mockito.verify((Object)mockStrategy, (VerificationMode)Mockito.times((int)0))).onTaskFailure((Execution)Mockito.any(Execution.class), (Throwable)Mockito.any(Throwable.class));
    }

    @Test
    public void testNoLocalFailoverWhileFailing() throws Exception {
        Execution exec;
        FailoverStrategy mockStrategy = (FailoverStrategy)Mockito.mock(FailoverStrategy.class);
        ExecutionGraph graph = this.createSampleGraph(mockStrategy);
        ExecutionVertex testVertex = GlobalModVersionTest.getRandomVertex(graph);
        graph.scheduleForExecution();
        Assert.assertEquals((Object)JobStatus.RUNNING, (Object)graph.getState());
        for (ExecutionVertex v : ((ExecutionJobVertex)graph.getVerticesTopologically().iterator().next()).getTaskVertices()) {
            exec = v.getCurrentExecutionAttempt();
            ExecutionGraphTestUtils.waitUntilExecutionState(exec, ExecutionState.DEPLOYING, 1000L);
            exec.switchToRunning();
            Assert.assertEquals((Object)ExecutionState.RUNNING, (Object)exec.getState());
        }
        graph.failGlobal((Throwable)new Exception("global failover"));
        Assert.assertEquals((Object)JobStatus.FAILING, (Object)graph.getState());
        Assert.assertEquals((long)2L, (long)graph.getGlobalModVersion());
        graph.failGlobal((Throwable)new Exception("should be ignored"));
        Assert.assertEquals((Object)JobStatus.FAILING, (Object)graph.getState());
        Assert.assertEquals((long)2L, (long)graph.getGlobalModVersion());
        for (ExecutionVertex v : ((ExecutionJobVertex)graph.getVerticesTopologically().iterator().next()).getTaskVertices()) {
            exec = v.getCurrentExecutionAttempt();
            Assert.assertEquals((Object)ExecutionState.CANCELING, (Object)exec.getState());
        }
        testVertex.getCurrentExecutionAttempt().fail((Throwable)new Exception("test exception"));
        for (ExecutionVertex v : ((ExecutionJobVertex)graph.getVerticesTopologically().iterator().next()).getTaskVertices()) {
            exec = v.getCurrentExecutionAttempt();
            exec.cancelingComplete();
        }
        Assert.assertEquals((Object)JobStatus.RESTARTING, (Object)graph.getState());
        ((FailoverStrategy)Mockito.verify((Object)mockStrategy, (VerificationMode)Mockito.times((int)0))).onTaskFailure((Execution)Mockito.any(Execution.class), (Throwable)Mockito.any(Throwable.class));
    }

    private ExecutionGraph createSampleGraph(FailoverStrategy failoverStrategy) throws Exception {
        JobID jid = new JobID();
        int parallelism = new Random().nextInt(10) + 1;
        SimpleSlotProvider slotProvider = new SimpleSlotProvider(jid, parallelism);
        ExecutionGraph graph = new ExecutionGraph(TestingUtils.defaultExecutor(), (Executor)TestingUtils.defaultExecutor(), jid, "test job", new Configuration(), new SerializedValue((Object)new ExecutionConfig()), Time.seconds((long)10L), (RestartStrategy)new InfiniteDelayRestartStrategy(), (FailoverStrategy.Factory)new CustomStrategy(failoverStrategy), Collections.emptyList(), Collections.emptyList(), (SlotProvider)slotProvider, this.getClass().getClassLoader());
        JobVertex jv = new JobVertex("test vertex");
        jv.setInvokableClass(NoOpInvokable.class);
        jv.setParallelism(parallelism);
        JobGraph jg = new JobGraph(jid, "testjob", new JobVertex[]{jv});
        graph.attachJobGraph(jg.getVerticesSortedTopologicallyFromSources());
        return graph;
    }

    private static ExecutionVertex getRandomVertex(ExecutionGraph eg) {
        ExecutionVertex[] vertices = ((ExecutionJobVertex)eg.getVerticesTopologically().iterator().next()).getTaskVertices();
        return vertices[new Random().nextInt(vertices.length)];
    }

    private static class CustomStrategy
    implements FailoverStrategy.Factory {
        private final FailoverStrategy failoverStrategy;

        CustomStrategy(FailoverStrategy failoverStrategy) {
            this.failoverStrategy = failoverStrategy;
        }

        public FailoverStrategy create(ExecutionGraph executionGraph) {
            return this.failoverStrategy;
        }
    }
}

