/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.runtime.concurrent.Future;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.instance.SlotProvider;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.ScheduledUnit;
import org.apache.flink.util.Preconditions;

class ProgrammedSlotProvider
implements SlotProvider {
    private final Map<JobVertexID, Future<SimpleSlot>[]> slotFutures = new HashMap<JobVertexID, Future<SimpleSlot>[]>();
    private final int parallelism;

    public ProgrammedSlotProvider(int parallelism) {
        Preconditions.checkArgument((parallelism > 0 ? 1 : 0) != 0);
        this.parallelism = parallelism;
    }

    public void addSlot(JobVertexID vertex, int subtaskIndex, Future<SimpleSlot> future) {
        Preconditions.checkNotNull((Object)vertex);
        Preconditions.checkNotNull(future);
        Preconditions.checkArgument((subtaskIndex >= 0 && subtaskIndex < this.parallelism ? 1 : 0) != 0);
        Future<SimpleSlot>[] futures = this.slotFutures.get(vertex);
        if (futures == null) {
            Future[] newArray = new Future[this.parallelism];
            futures = newArray;
            this.slotFutures.put(vertex, futures);
        }
        futures[subtaskIndex] = future;
    }

    public void addSlots(JobVertexID vertex, Future<SimpleSlot>[] futures) {
        Preconditions.checkNotNull((Object)vertex);
        Preconditions.checkNotNull(futures);
        Preconditions.checkArgument((futures.length == this.parallelism ? 1 : 0) != 0);
        this.slotFutures.put(vertex, futures);
    }

    public Future<SimpleSlot> allocateSlot(ScheduledUnit task, boolean allowQueued) {
        Future<SimpleSlot> future;
        JobVertexID vertexId = task.getTaskToExecute().getVertex().getJobvertexId();
        int subtask = task.getTaskToExecute().getParallelSubtaskIndex();
        Future<SimpleSlot>[] forTask = this.slotFutures.get(vertexId);
        if (forTask != null && (future = forTask[subtask]) != null) {
            return future;
        }
        throw new IllegalArgumentException("No registered slot future for task " + vertexId + " (" + subtask + ')');
    }
}

