/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.restart;

import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfiniteDelayRestartStrategy
implements RestartStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(InfiniteDelayRestartStrategy.class);
    private final int maxRestartAttempts;
    private int restartAttemptCounter;

    public InfiniteDelayRestartStrategy() {
        this(-1);
    }

    public InfiniteDelayRestartStrategy(int maxRestartAttempts) {
        this.maxRestartAttempts = maxRestartAttempts;
        this.restartAttemptCounter = 0;
    }

    public boolean canRestart() {
        if (this.maxRestartAttempts >= 0) {
            return this.restartAttemptCounter < this.maxRestartAttempts;
        }
        return true;
    }

    public void restart(ExecutionGraph executionGraph) {
        LOG.info("Delaying retry of job execution forever");
        if (this.maxRestartAttempts >= 0) {
            ++this.restartAttemptCounter;
        }
    }
}

