/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.utils;

import java.net.InetAddress;
import java.util.ArrayDeque;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.concurrent.Future;
import org.apache.flink.runtime.concurrent.impl.FlinkCompletableFuture;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.instance.Slot;
import org.apache.flink.runtime.instance.SlotProvider;
import org.apache.flink.runtime.jobmanager.scheduler.NoResourceAvailableException;
import org.apache.flink.runtime.jobmanager.scheduler.ScheduledUnit;
import org.apache.flink.runtime.jobmanager.slots.AllocatedSlot;
import org.apache.flink.runtime.jobmanager.slots.SlotOwner;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;

public class SimpleSlotProvider
implements SlotProvider,
SlotOwner {
    private final ArrayDeque<AllocatedSlot> slots;

    public SimpleSlotProvider(JobID jobId, int numSlots) {
        this(jobId, numSlots, new SimpleAckingTaskManagerGateway());
    }

    public SimpleSlotProvider(JobID jobId, int numSlots, TaskManagerGateway taskManagerGateway) {
        Preconditions.checkNotNull((Object)jobId, (String)"jobId");
        Preconditions.checkArgument((numSlots >= 0 ? 1 : 0) != 0, (Object)"numSlots must be >= 0");
        this.slots = new ArrayDeque(numSlots);
        for (int i = 0; i < numSlots; ++i) {
            AllocatedSlot as = new AllocatedSlot(new AllocationID(), jobId, new TaskManagerLocation(ResourceID.generate(), InetAddress.getLoopbackAddress(), 10000 + i), 0, ResourceProfile.UNKNOWN, taskManagerGateway);
            this.slots.add(as);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<SimpleSlot> allocateSlot(ScheduledUnit task, boolean allowQueued) {
        AllocatedSlot slot;
        ArrayDeque<AllocatedSlot> arrayDeque = this.slots;
        synchronized (arrayDeque) {
            slot = this.slots.isEmpty() ? null : this.slots.removeFirst();
        }
        if (slot != null) {
            SimpleSlot result = new SimpleSlot(slot, (SlotOwner)this, 0);
            return FlinkCompletableFuture.completed((Object)result);
        }
        return FlinkCompletableFuture.completedExceptionally((Throwable)new NoResourceAvailableException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean returnAllocatedSlot(Slot slot) {
        ArrayDeque<AllocatedSlot> arrayDeque = this.slots;
        synchronized (arrayDeque) {
            this.slots.add(slot.getAllocatedSlot());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAvailableSlots() {
        ArrayDeque<AllocatedSlot> arrayDeque = this.slots;
        synchronized (arrayDeque) {
            return this.slots.size();
        }
    }
}

