/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.RunningJobsRegistry;
import org.apache.flink.runtime.highavailability.nonha.standalone.StandaloneRunningJobsRegistry;
import org.apache.flink.runtime.jobmanager.SubmittedJobGraphStore;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;

public class TestingHighAvailabilityServices
implements HighAvailabilityServices {
    private volatile LeaderRetrievalService resourceManagerLeaderRetriever;
    private ConcurrentHashMap<JobID, LeaderRetrievalService> jobMasterLeaderRetrievers = new ConcurrentHashMap();
    private ConcurrentHashMap<JobID, LeaderElectionService> jobManagerLeaderElectionServices = new ConcurrentHashMap();
    private volatile LeaderElectionService resourceManagerLeaderElectionService;
    private volatile CheckpointRecoveryFactory checkpointRecoveryFactory;
    private volatile SubmittedJobGraphStore submittedJobGraphStore;

    public void setResourceManagerLeaderRetriever(LeaderRetrievalService resourceManagerLeaderRetriever) {
        this.resourceManagerLeaderRetriever = resourceManagerLeaderRetriever;
    }

    public void setJobMasterLeaderRetriever(JobID jobID, LeaderRetrievalService jobMasterLeaderRetriever) {
        this.jobMasterLeaderRetrievers.put(jobID, jobMasterLeaderRetriever);
    }

    public void setJobMasterLeaderElectionService(JobID jobID, LeaderElectionService leaderElectionService) {
        this.jobManagerLeaderElectionServices.put(jobID, leaderElectionService);
    }

    public void setResourceManagerLeaderElectionService(LeaderElectionService leaderElectionService) {
        this.resourceManagerLeaderElectionService = leaderElectionService;
    }

    public void setCheckpointRecoveryFactory(CheckpointRecoveryFactory checkpointRecoveryFactory) {
        this.checkpointRecoveryFactory = checkpointRecoveryFactory;
    }

    public void setSubmittedJobGraphStore(SubmittedJobGraphStore submittedJobGraphStore) {
        this.submittedJobGraphStore = submittedJobGraphStore;
    }

    public LeaderRetrievalService getResourceManagerLeaderRetriever() {
        LeaderRetrievalService service = this.resourceManagerLeaderRetriever;
        if (service != null) {
            return service;
        }
        throw new IllegalStateException("ResourceManagerLeaderRetriever has not been set");
    }

    public LeaderRetrievalService getJobManagerLeaderRetriever(JobID jobID) {
        LeaderRetrievalService service = this.jobMasterLeaderRetrievers.get(jobID);
        if (service != null) {
            return service;
        }
        throw new IllegalStateException("JobMasterLeaderRetriever has not been set");
    }

    public LeaderElectionService getResourceManagerLeaderElectionService() {
        LeaderElectionService service = this.resourceManagerLeaderElectionService;
        if (service != null) {
            return service;
        }
        throw new IllegalStateException("ResourceManagerLeaderElectionService has not been set");
    }

    public LeaderElectionService getJobManagerLeaderElectionService(JobID jobID) {
        LeaderElectionService service = this.jobManagerLeaderElectionServices.get(jobID);
        if (service != null) {
            return service;
        }
        throw new IllegalStateException("JobMasterLeaderElectionService has not been set");
    }

    public CheckpointRecoveryFactory getCheckpointRecoveryFactory() {
        CheckpointRecoveryFactory factory = this.checkpointRecoveryFactory;
        if (factory != null) {
            return factory;
        }
        throw new IllegalStateException("CheckpointRecoveryFactory has not been set");
    }

    public SubmittedJobGraphStore getSubmittedJobGraphStore() {
        SubmittedJobGraphStore store = this.submittedJobGraphStore;
        if (store != null) {
            return store;
        }
        throw new IllegalStateException("SubmittedJobGraphStore has not been set");
    }

    public RunningJobsRegistry getRunningJobsRegistry() {
        return new StandaloneRunningJobsRegistry();
    }

    public BlobStore createBlobStore() throws IOException {
        return new VoidBlobStore();
    }

    public void close() throws Exception {
    }

    public void closeAndCleanupAllData() throws Exception {
    }
}

