/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.instance.Slot;
import org.apache.flink.runtime.instance.SlotPool;
import org.apache.flink.runtime.jobmanager.slots.AllocatedSlot;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class AllocatedSlotsTest {
    @Test
    public void testOperations() throws Exception {
        SlotPool.AllocatedSlots allocatedSlots = new SlotPool.AllocatedSlots();
        AllocationID allocation1 = new AllocationID();
        ResourceID resource1 = new ResourceID("resource1");
        Slot slot1 = this.createSlot(resource1, allocation1);
        allocatedSlots.add(slot1);
        Assert.assertTrue((boolean)allocatedSlots.contains(slot1.getAllocatedSlot().getSlotAllocationId()));
        Assert.assertTrue((boolean)allocatedSlots.containResource(resource1));
        Assert.assertEquals((Object)slot1, (Object)allocatedSlots.get(allocation1));
        Assert.assertEquals((long)1L, (long)allocatedSlots.getSlotsForTaskManager(resource1).size());
        Assert.assertEquals((long)1L, (long)allocatedSlots.size());
        AllocationID allocation2 = new AllocationID();
        Slot slot2 = this.createSlot(resource1, allocation2);
        allocatedSlots.add(slot2);
        Assert.assertTrue((boolean)allocatedSlots.contains(slot1.getAllocatedSlot().getSlotAllocationId()));
        Assert.assertTrue((boolean)allocatedSlots.contains(slot2.getAllocatedSlot().getSlotAllocationId()));
        Assert.assertTrue((boolean)allocatedSlots.containResource(resource1));
        Assert.assertEquals((Object)slot1, (Object)allocatedSlots.get(allocation1));
        Assert.assertEquals((Object)slot2, (Object)allocatedSlots.get(allocation2));
        Assert.assertEquals((long)2L, (long)allocatedSlots.getSlotsForTaskManager(resource1).size());
        Assert.assertEquals((long)2L, (long)allocatedSlots.size());
        AllocationID allocation3 = new AllocationID();
        ResourceID resource2 = new ResourceID("resource2");
        Slot slot3 = this.createSlot(resource2, allocation3);
        allocatedSlots.add(slot3);
        Assert.assertTrue((boolean)allocatedSlots.contains(slot1.getAllocatedSlot().getSlotAllocationId()));
        Assert.assertTrue((boolean)allocatedSlots.contains(slot2.getAllocatedSlot().getSlotAllocationId()));
        Assert.assertTrue((boolean)allocatedSlots.contains(slot3.getAllocatedSlot().getSlotAllocationId()));
        Assert.assertTrue((boolean)allocatedSlots.containResource(resource1));
        Assert.assertTrue((boolean)allocatedSlots.containResource(resource2));
        Assert.assertEquals((Object)slot1, (Object)allocatedSlots.get(allocation1));
        Assert.assertEquals((Object)slot2, (Object)allocatedSlots.get(allocation2));
        Assert.assertEquals((Object)slot3, (Object)allocatedSlots.get(allocation3));
        Assert.assertEquals((long)2L, (long)allocatedSlots.getSlotsForTaskManager(resource1).size());
        Assert.assertEquals((long)1L, (long)allocatedSlots.getSlotsForTaskManager(resource2).size());
        Assert.assertEquals((long)3L, (long)allocatedSlots.size());
        allocatedSlots.remove(slot2);
        Assert.assertTrue((boolean)allocatedSlots.contains(slot1.getAllocatedSlot().getSlotAllocationId()));
        Assert.assertFalse((boolean)allocatedSlots.contains(slot2.getAllocatedSlot().getSlotAllocationId()));
        Assert.assertTrue((boolean)allocatedSlots.contains(slot3.getAllocatedSlot().getSlotAllocationId()));
        Assert.assertTrue((boolean)allocatedSlots.containResource(resource1));
        Assert.assertTrue((boolean)allocatedSlots.containResource(resource2));
        Assert.assertEquals((Object)slot1, (Object)allocatedSlots.get(allocation1));
        Assert.assertNull((Object)allocatedSlots.get(allocation2));
        Assert.assertEquals((Object)slot3, (Object)allocatedSlots.get(allocation3));
        Assert.assertEquals((long)1L, (long)allocatedSlots.getSlotsForTaskManager(resource1).size());
        Assert.assertEquals((long)1L, (long)allocatedSlots.getSlotsForTaskManager(resource2).size());
        Assert.assertEquals((long)2L, (long)allocatedSlots.size());
        allocatedSlots.remove(slot1);
        Assert.assertFalse((boolean)allocatedSlots.contains(slot1.getAllocatedSlot().getSlotAllocationId()));
        Assert.assertFalse((boolean)allocatedSlots.contains(slot2.getAllocatedSlot().getSlotAllocationId()));
        Assert.assertTrue((boolean)allocatedSlots.contains(slot3.getAllocatedSlot().getSlotAllocationId()));
        Assert.assertFalse((boolean)allocatedSlots.containResource(resource1));
        Assert.assertTrue((boolean)allocatedSlots.containResource(resource2));
        Assert.assertNull((Object)allocatedSlots.get(allocation1));
        Assert.assertNull((Object)allocatedSlots.get(allocation2));
        Assert.assertEquals((Object)slot3, (Object)allocatedSlots.get(allocation3));
        Assert.assertEquals((long)0L, (long)allocatedSlots.getSlotsForTaskManager(resource1).size());
        Assert.assertEquals((long)1L, (long)allocatedSlots.getSlotsForTaskManager(resource2).size());
        Assert.assertEquals((long)1L, (long)allocatedSlots.size());
        allocatedSlots.remove(slot3);
        Assert.assertFalse((boolean)allocatedSlots.contains(slot1.getAllocatedSlot().getSlotAllocationId()));
        Assert.assertFalse((boolean)allocatedSlots.contains(slot2.getAllocatedSlot().getSlotAllocationId()));
        Assert.assertFalse((boolean)allocatedSlots.contains(slot3.getAllocatedSlot().getSlotAllocationId()));
        Assert.assertFalse((boolean)allocatedSlots.containResource(resource1));
        Assert.assertFalse((boolean)allocatedSlots.containResource(resource2));
        Assert.assertNull((Object)allocatedSlots.get(allocation1));
        Assert.assertNull((Object)allocatedSlots.get(allocation2));
        Assert.assertNull((Object)allocatedSlots.get(allocation3));
        Assert.assertEquals((long)0L, (long)allocatedSlots.getSlotsForTaskManager(resource1).size());
        Assert.assertEquals((long)0L, (long)allocatedSlots.getSlotsForTaskManager(resource2).size());
        Assert.assertEquals((long)0L, (long)allocatedSlots.size());
    }

    private Slot createSlot(ResourceID resourceId, AllocationID allocationId) {
        AllocatedSlot mockAllocatedSlot = (AllocatedSlot)Mockito.mock(AllocatedSlot.class);
        Slot slot = (Slot)Mockito.mock(Slot.class);
        Mockito.when((Object)slot.getTaskManagerID()).thenReturn((Object)resourceId);
        Mockito.when((Object)slot.getAllocatedSlot()).thenReturn((Object)mockAllocatedSlot);
        Mockito.when((Object)mockAllocatedSlot.getSlotAllocationId()).thenReturn((Object)allocationId);
        return slot;
    }
}

