/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.util.Collections;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.SharedSlot;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.instance.SlotSharingGroupAssignment;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationConstraint;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroup;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmanager.scheduler.SchedulerTestUtils;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.AbstractID;
import org.junit.Assert;
import org.junit.Test;

public class SharedSlotsTest {
    private static final Iterable<TaskManagerLocation> NO_LOCATION = Collections.emptySet();

    @Test
    public void allocateAndReleaseEmptySlot() {
        try {
            JobID jobId = new JobID();
            JobVertexID vertexId = new JobVertexID();
            SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{vertexId});
            SlotSharingGroupAssignment assignment = sharingGroup.getTaskAssignment();
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfSlots());
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vertexId));
            Instance instance = SchedulerTestUtils.getRandomInstance(2);
            Assert.assertEquals((long)2L, (long)instance.getTotalNumberOfSlots());
            Assert.assertEquals((long)0L, (long)instance.getNumberOfAllocatedSlots());
            Assert.assertEquals((long)2L, (long)instance.getNumberOfAvailableSlots());
            SharedSlot slot = instance.allocateSharedSlot(jobId, assignment);
            Assert.assertEquals((long)2L, (long)instance.getTotalNumberOfSlots());
            Assert.assertEquals((long)1L, (long)instance.getNumberOfAllocatedSlots());
            Assert.assertEquals((long)1L, (long)instance.getNumberOfAvailableSlots());
            Assert.assertTrue((boolean)slot.isAlive());
            Assert.assertFalse((boolean)slot.isCanceled());
            Assert.assertFalse((boolean)slot.isReleased());
            Assert.assertEquals((long)0L, (long)slot.getNumberLeaves());
            Assert.assertFalse((boolean)slot.hasChildren());
            Assert.assertTrue((boolean)slot.isRootAndEmpty());
            Assert.assertNotNull((Object)slot.toString());
            Assert.assertTrue((boolean)slot.getSubSlots().isEmpty());
            Assert.assertEquals((long)0L, (long)slot.getSlotNumber());
            Assert.assertEquals((long)0L, (long)slot.getRootSlotNumber());
            slot.releaseSlot();
            Assert.assertTrue((boolean)slot.isCanceled());
            Assert.assertTrue((boolean)slot.isReleased());
            Assert.assertEquals((long)2L, (long)instance.getTotalNumberOfSlots());
            Assert.assertEquals((long)0L, (long)instance.getNumberOfAllocatedSlots());
            Assert.assertEquals((long)2L, (long)instance.getNumberOfAvailableSlots());
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfSlots());
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vertexId));
            Assert.assertNull((Object)slot.allocateSharedSlot(new AbstractID()));
            Assert.assertNull((Object)slot.allocateSubSlot(new AbstractID()));
            Assert.assertNull((Object)assignment.addSharedSlotAndAllocateSubSlot(slot, Locality.NON_LOCAL, vertexId));
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfSlots());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void allocateSimpleSlotsAndReleaseFromRoot() {
        try {
            JobID jobId = new JobID();
            JobVertexID vid1 = new JobVertexID();
            JobVertexID vid2 = new JobVertexID();
            JobVertexID vid3 = new JobVertexID();
            JobVertexID vid4 = new JobVertexID();
            SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{vid1, vid2, vid3, vid4});
            SlotSharingGroupAssignment assignment = sharingGroup.getTaskAssignment();
            Instance instance = SchedulerTestUtils.getRandomInstance(1);
            SharedSlot sharedSlot = instance.allocateSharedSlot(jobId, assignment);
            SimpleSlot sub1 = assignment.addSharedSlotAndAllocateSubSlot(sharedSlot, Locality.LOCAL, vid1);
            Assert.assertNotNull((Object)sub1);
            Assert.assertNull((Object)sub1.getExecutedVertex());
            Assert.assertEquals((Object)Locality.LOCAL, (Object)sub1.getLocality());
            Assert.assertEquals((long)1L, (long)sub1.getNumberLeaves());
            Assert.assertEquals((Object)vid1, (Object)sub1.getGroupID());
            Assert.assertEquals((Object)instance.getTaskManagerID(), (Object)sub1.getTaskManagerID());
            Assert.assertEquals((Object)jobId, (Object)sub1.getJobID());
            Assert.assertEquals((Object)sharedSlot, (Object)sub1.getParent());
            Assert.assertEquals((Object)sharedSlot, (Object)sub1.getRoot());
            Assert.assertEquals((long)0L, (long)sub1.getRootSlotNumber());
            Assert.assertEquals((long)0L, (long)sub1.getSlotNumber());
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid1));
            Assert.assertEquals((long)1L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid2));
            Assert.assertEquals((long)1L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid3));
            Assert.assertEquals((long)1L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid4));
            SimpleSlot sub2 = assignment.getSlotForTask(vid2, NO_LOCATION);
            Assert.assertNotNull((Object)sub2);
            Assert.assertNull((Object)sub2.getExecutedVertex());
            Assert.assertEquals((Object)Locality.UNCONSTRAINED, (Object)sub2.getLocality());
            Assert.assertEquals((long)1L, (long)sub2.getNumberLeaves());
            Assert.assertEquals((Object)vid2, (Object)sub2.getGroupID());
            Assert.assertEquals((Object)instance.getTaskManagerID(), (Object)sub2.getTaskManagerID());
            Assert.assertEquals((Object)jobId, (Object)sub2.getJobID());
            Assert.assertEquals((Object)sharedSlot, (Object)sub2.getParent());
            Assert.assertEquals((Object)sharedSlot, (Object)sub2.getRoot());
            Assert.assertEquals((long)0L, (long)sub2.getRootSlotNumber());
            Assert.assertEquals((long)1L, (long)sub2.getSlotNumber());
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid1));
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid2));
            Assert.assertEquals((long)1L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid3));
            Assert.assertEquals((long)1L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid4));
            SimpleSlot sub3 = assignment.getSlotForTask(vid3, Collections.singleton(instance.getTaskManagerLocation()));
            Assert.assertNotNull((Object)sub3);
            Assert.assertNull((Object)sub3.getExecutedVertex());
            Assert.assertEquals((Object)Locality.LOCAL, (Object)sub3.getLocality());
            Assert.assertEquals((long)1L, (long)sub3.getNumberLeaves());
            Assert.assertEquals((Object)vid3, (Object)sub3.getGroupID());
            Assert.assertEquals((Object)instance.getTaskManagerID(), (Object)sub3.getTaskManagerID());
            Assert.assertEquals((Object)jobId, (Object)sub3.getJobID());
            Assert.assertEquals((Object)sharedSlot, (Object)sub3.getParent());
            Assert.assertEquals((Object)sharedSlot, (Object)sub3.getRoot());
            Assert.assertEquals((long)0L, (long)sub3.getRootSlotNumber());
            Assert.assertEquals((long)2L, (long)sub3.getSlotNumber());
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid1));
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid2));
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid3));
            Assert.assertEquals((long)1L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid4));
            SimpleSlot sub4 = assignment.getSlotForTask(vid4, Collections.singleton(SchedulerTestUtils.getRandomInstance(1).getTaskManagerLocation()));
            Assert.assertNotNull((Object)sub4);
            Assert.assertNull((Object)sub4.getExecutedVertex());
            Assert.assertEquals((Object)Locality.NON_LOCAL, (Object)sub4.getLocality());
            Assert.assertEquals((long)1L, (long)sub4.getNumberLeaves());
            Assert.assertEquals((Object)vid4, (Object)sub4.getGroupID());
            Assert.assertEquals((Object)instance.getTaskManagerID(), (Object)sub4.getTaskManagerID());
            Assert.assertEquals((Object)jobId, (Object)sub4.getJobID());
            Assert.assertEquals((Object)sharedSlot, (Object)sub4.getParent());
            Assert.assertEquals((Object)sharedSlot, (Object)sub4.getRoot());
            Assert.assertEquals((long)0L, (long)sub4.getRootSlotNumber());
            Assert.assertEquals((long)3L, (long)sub4.getSlotNumber());
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid1));
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid2));
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid3));
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid4));
            sharedSlot.releaseSlot();
            Assert.assertTrue((boolean)sharedSlot.isReleased());
            Assert.assertTrue((boolean)sub1.isReleased());
            Assert.assertTrue((boolean)sub2.isReleased());
            Assert.assertTrue((boolean)sub3.isReleased());
            Assert.assertTrue((boolean)sub4.isReleased());
            Assert.assertEquals((long)0L, (long)sharedSlot.getNumberLeaves());
            Assert.assertFalse((boolean)sharedSlot.hasChildren());
            Assert.assertEquals((long)1L, (long)instance.getNumberOfAvailableSlots());
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfSlots());
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid1));
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid2));
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid3));
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid4));
            Assert.assertNull((Object)sharedSlot.allocateSharedSlot(new AbstractID()));
            Assert.assertNull((Object)sharedSlot.allocateSubSlot(new AbstractID()));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void allocateSimpleSlotsAndReleaseFromLeaves() {
        try {
            JobID jobId = new JobID();
            JobVertexID vid1 = new JobVertexID();
            JobVertexID vid2 = new JobVertexID();
            JobVertexID vid3 = new JobVertexID();
            SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{vid1, vid2, vid3});
            SlotSharingGroupAssignment assignment = sharingGroup.getTaskAssignment();
            Instance instance = SchedulerTestUtils.getRandomInstance(1);
            SharedSlot sharedSlot = instance.allocateSharedSlot(jobId, assignment);
            SimpleSlot sub1 = assignment.addSharedSlotAndAllocateSubSlot(sharedSlot, Locality.UNCONSTRAINED, vid1);
            SimpleSlot sub2 = assignment.getSlotForTask(vid2, NO_LOCATION);
            SimpleSlot sub3 = assignment.getSlotForTask(vid3, NO_LOCATION);
            Assert.assertNotNull((Object)sub1);
            Assert.assertNotNull((Object)sub2);
            Assert.assertNotNull((Object)sub3);
            Assert.assertEquals((long)3L, (long)sharedSlot.getNumberLeaves());
            Assert.assertEquals((long)1L, (long)assignment.getNumberOfSlots());
            sub2.releaseSlot();
            Assert.assertTrue((boolean)sharedSlot.isAlive());
            Assert.assertTrue((boolean)sub1.isAlive());
            Assert.assertTrue((boolean)sub2.isReleased());
            Assert.assertTrue((boolean)sub3.isAlive());
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid1));
            Assert.assertEquals((long)1L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid2));
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid3));
            Assert.assertEquals((long)1L, (long)assignment.getNumberOfSlots());
            Assert.assertEquals((long)2L, (long)sharedSlot.getNumberLeaves());
            sub1.releaseSlot();
            Assert.assertTrue((boolean)sharedSlot.isAlive());
            Assert.assertTrue((boolean)sub1.isReleased());
            Assert.assertTrue((boolean)sub2.isReleased());
            Assert.assertTrue((boolean)sub3.isAlive());
            Assert.assertEquals((long)1L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid1));
            Assert.assertEquals((long)1L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid2));
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid3));
            Assert.assertEquals((long)1L, (long)assignment.getNumberOfSlots());
            Assert.assertEquals((long)1L, (long)sharedSlot.getNumberLeaves());
            sub3.releaseSlot();
            Assert.assertTrue((boolean)sharedSlot.isReleased());
            Assert.assertTrue((boolean)sub1.isReleased());
            Assert.assertTrue((boolean)sub2.isReleased());
            Assert.assertTrue((boolean)sub3.isReleased());
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid1));
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid2));
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid3));
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfSlots());
            Assert.assertEquals((long)1L, (long)instance.getNumberOfAvailableSlots());
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfSlots());
            Assert.assertNull((Object)sharedSlot.allocateSharedSlot(new AbstractID()));
            Assert.assertNull((Object)sharedSlot.allocateSubSlot(new AbstractID()));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void allocateAndReleaseInMixedOrder() {
        try {
            JobID jobId = new JobID();
            JobVertexID vid1 = new JobVertexID();
            JobVertexID vid2 = new JobVertexID();
            JobVertexID vid3 = new JobVertexID();
            SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{vid1, vid2, vid3});
            SlotSharingGroupAssignment assignment = sharingGroup.getTaskAssignment();
            Instance instance = SchedulerTestUtils.getRandomInstance(1);
            SharedSlot sharedSlot = instance.allocateSharedSlot(jobId, assignment);
            SimpleSlot sub1 = assignment.addSharedSlotAndAllocateSubSlot(sharedSlot, Locality.UNCONSTRAINED, vid1);
            SimpleSlot sub2 = assignment.getSlotForTask(vid2, NO_LOCATION);
            Assert.assertNotNull((Object)sub1);
            Assert.assertNotNull((Object)sub2);
            Assert.assertEquals((long)2L, (long)sharedSlot.getNumberLeaves());
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid1));
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid2));
            Assert.assertEquals((long)1L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid3));
            Assert.assertEquals((long)1L, (long)assignment.getNumberOfSlots());
            sub2.releaseSlot();
            Assert.assertEquals((long)1L, (long)sharedSlot.getNumberLeaves());
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid1));
            Assert.assertEquals((long)1L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid2));
            Assert.assertEquals((long)1L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid3));
            Assert.assertEquals((long)1L, (long)assignment.getNumberOfSlots());
            SimpleSlot sub3 = assignment.getSlotForTask(vid3, NO_LOCATION);
            Assert.assertNotNull((Object)sub3);
            Assert.assertEquals((long)2L, (long)sharedSlot.getNumberLeaves());
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid1));
            Assert.assertEquals((long)1L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid2));
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid3));
            Assert.assertEquals((long)1L, (long)assignment.getNumberOfSlots());
            sub3.releaseSlot();
            sub1.releaseSlot();
            Assert.assertTrue((boolean)sharedSlot.isReleased());
            Assert.assertEquals((long)0L, (long)sharedSlot.getNumberLeaves());
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid1));
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid2));
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup((AbstractID)vid3));
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfSlots());
            Assert.assertEquals((long)1L, (long)instance.getNumberOfAvailableSlots());
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfSlots());
            Assert.assertNull((Object)sharedSlot.allocateSharedSlot(new AbstractID()));
            Assert.assertNull((Object)sharedSlot.allocateSubSlot(new AbstractID()));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testAllocateAndReleaseTwoLevels() {
        try {
            JobVertexID sourceId = new JobVertexID();
            JobVertexID headId = new JobVertexID();
            JobVertexID tailId = new JobVertexID();
            JobVertexID sinkId = new JobVertexID();
            JobVertex headVertex = new JobVertex("head", headId);
            JobVertex tailVertex = new JobVertex("tail", tailId);
            SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{sourceId, headId, tailId, sinkId});
            SlotSharingGroupAssignment assignment = sharingGroup.getTaskAssignment();
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfSlots());
            CoLocationGroup coLocationGroup = new CoLocationGroup(new JobVertex[]{headVertex, tailVertex});
            CoLocationConstraint constraint = coLocationGroup.getLocationConstraint(0);
            Assert.assertFalse((boolean)constraint.isAssigned());
            Instance instance = SchedulerTestUtils.getRandomInstance(1);
            SharedSlot sharedSlot = instance.allocateSharedSlot(new JobID(), assignment);
            SimpleSlot sourceSlot = assignment.addSharedSlotAndAllocateSubSlot(sharedSlot, Locality.LOCAL, sourceId);
            Assert.assertEquals((long)1L, (long)sharedSlot.getNumberLeaves());
            SimpleSlot headSlot = assignment.getSlotForTask(constraint, Collections.emptySet());
            Assert.assertEquals((long)2L, (long)sharedSlot.getNumberLeaves());
            Assert.assertNotNull((Object)constraint.getSharedSlot());
            Assert.assertTrue((boolean)constraint.getSharedSlot().isAlive());
            Assert.assertFalse((boolean)constraint.isAssigned());
            headSlot.releaseSlot();
            Assert.assertEquals((long)1L, (long)sharedSlot.getNumberLeaves());
            Assert.assertNotNull((Object)constraint.getSharedSlot());
            Assert.assertTrue((boolean)constraint.getSharedSlot().isReleased());
            Assert.assertFalse((boolean)constraint.isAssigned());
            headSlot = assignment.getSlotForTask(constraint, Collections.emptySet());
            constraint.lockLocation();
            Assert.assertNotNull((Object)constraint.getSharedSlot());
            Assert.assertTrue((boolean)constraint.isAssigned());
            Assert.assertTrue((boolean)constraint.isAssignedAndAlive());
            Assert.assertEquals((Object)instance.getTaskManagerLocation(), (Object)constraint.getLocation());
            SimpleSlot tailSlot = assignment.getSlotForTask(constraint, Collections.emptySet());
            Assert.assertEquals((Object)constraint.getSharedSlot(), (Object)headSlot.getParent());
            Assert.assertEquals((Object)constraint.getSharedSlot(), (Object)tailSlot.getParent());
            SimpleSlot sinkSlot = assignment.getSlotForTask(sinkId, Collections.emptySet());
            Assert.assertEquals((long)4L, (long)sharedSlot.getNumberLeaves());
            headSlot.releaseSlot();
            tailSlot.releaseSlot();
            Assert.assertEquals((long)2L, (long)sharedSlot.getNumberLeaves());
            Assert.assertTrue((boolean)headSlot.isReleased());
            Assert.assertTrue((boolean)tailSlot.isReleased());
            Assert.assertTrue((boolean)constraint.isAssigned());
            Assert.assertFalse((boolean)constraint.isAssignedAndAlive());
            Assert.assertEquals((Object)instance.getTaskManagerLocation(), (Object)constraint.getLocation());
            Assert.assertEquals((long)1L, (long)assignment.getNumberOfAvailableSlotsForGroup(constraint.getGroupId()));
            headSlot = assignment.getSlotForTask(constraint, NO_LOCATION);
            tailSlot = assignment.getSlotForTask(constraint, NO_LOCATION);
            Assert.assertEquals((long)4L, (long)sharedSlot.getNumberLeaves());
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfAvailableSlotsForGroup(constraint.getGroupId()));
            Assert.assertEquals((Object)instance.getTaskManagerID(), (Object)sourceSlot.getTaskManagerID());
            Assert.assertEquals((Object)instance.getTaskManagerID(), (Object)headSlot.getTaskManagerID());
            Assert.assertEquals((Object)instance.getTaskManagerID(), (Object)tailSlot.getTaskManagerID());
            Assert.assertEquals((Object)instance.getTaskManagerID(), (Object)sinkSlot.getTaskManagerID());
            Assert.assertEquals((Object)sourceId, (Object)sourceSlot.getGroupID());
            Assert.assertEquals((Object)sinkId, (Object)sinkSlot.getGroupID());
            Assert.assertNull((Object)headSlot.getGroupID());
            Assert.assertNull((Object)tailSlot.getGroupID());
            Assert.assertEquals((Object)constraint.getGroupId(), (Object)constraint.getSharedSlot().getGroupID());
            sourceSlot.releaseSlot();
            headSlot.releaseSlot();
            tailSlot.releaseSlot();
            sinkSlot.releaseSlot();
            Assert.assertTrue((boolean)sharedSlot.isReleased());
            Assert.assertTrue((boolean)sourceSlot.isReleased());
            Assert.assertTrue((boolean)headSlot.isReleased());
            Assert.assertTrue((boolean)tailSlot.isReleased());
            Assert.assertTrue((boolean)sinkSlot.isReleased());
            Assert.assertTrue((boolean)constraint.getSharedSlot().isReleased());
            Assert.assertTrue((boolean)constraint.isAssigned());
            Assert.assertFalse((boolean)constraint.isAssignedAndAlive());
            Assert.assertEquals((long)1L, (long)instance.getNumberOfAvailableSlots());
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfSlots());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testReleaseTwoLevelsFromRoot() {
        try {
            JobVertexID sourceId = new JobVertexID();
            JobVertexID headId = new JobVertexID();
            JobVertexID tailId = new JobVertexID();
            JobVertexID sinkId = new JobVertexID();
            JobVertex headVertex = new JobVertex("head", headId);
            JobVertex tailVertex = new JobVertex("tail", tailId);
            SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{sourceId, headId, tailId, sinkId});
            SlotSharingGroupAssignment assignment = sharingGroup.getTaskAssignment();
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfSlots());
            CoLocationGroup coLocationGroup = new CoLocationGroup(new JobVertex[]{headVertex, tailVertex});
            CoLocationConstraint constraint = coLocationGroup.getLocationConstraint(0);
            Assert.assertFalse((boolean)constraint.isAssigned());
            Instance instance = SchedulerTestUtils.getRandomInstance(1);
            SharedSlot sharedSlot = instance.allocateSharedSlot(new JobID(), assignment);
            SimpleSlot sourceSlot = assignment.addSharedSlotAndAllocateSubSlot(sharedSlot, Locality.LOCAL, sourceId);
            SimpleSlot headSlot = assignment.getSlotForTask(constraint, NO_LOCATION);
            constraint.lockLocation();
            SimpleSlot tailSlot = assignment.getSlotForTask(constraint, NO_LOCATION);
            SimpleSlot sinkSlot = assignment.getSlotForTask(sinkId, NO_LOCATION);
            Assert.assertEquals((long)4L, (long)sharedSlot.getNumberLeaves());
            sourceSlot.releaseSlot();
            headSlot.releaseSlot();
            tailSlot.releaseSlot();
            sinkSlot.releaseSlot();
            Assert.assertTrue((boolean)sharedSlot.isReleased());
            Assert.assertTrue((boolean)sourceSlot.isReleased());
            Assert.assertTrue((boolean)headSlot.isReleased());
            Assert.assertTrue((boolean)tailSlot.isReleased());
            Assert.assertTrue((boolean)sinkSlot.isReleased());
            Assert.assertTrue((boolean)constraint.getSharedSlot().isReleased());
            Assert.assertTrue((boolean)constraint.isAssigned());
            Assert.assertFalse((boolean)constraint.isAssignedAndAlive());
            Assert.assertEquals((long)1L, (long)instance.getNumberOfAvailableSlots());
            Assert.assertEquals((long)0L, (long)instance.getNumberOfAllocatedSlots());
            Assert.assertEquals((long)0L, (long)assignment.getNumberOfSlots());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testImmediateReleaseOneLevel() {
        try {
            JobID jobId = new JobID();
            JobVertexID vid = new JobVertexID();
            SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{vid});
            SlotSharingGroupAssignment assignment = sharingGroup.getTaskAssignment();
            Instance instance = SchedulerTestUtils.getRandomInstance(1);
            SharedSlot sharedSlot = instance.allocateSharedSlot(jobId, assignment);
            SimpleSlot sub = assignment.addSharedSlotAndAllocateSubSlot(sharedSlot, Locality.UNCONSTRAINED, vid);
            sub.releaseSlot();
            Assert.assertTrue((boolean)sub.isReleased());
            Assert.assertTrue((boolean)sharedSlot.isReleased());
            Assert.assertEquals((long)1L, (long)instance.getNumberOfAvailableSlots());
            Assert.assertEquals((long)0L, (long)instance.getNumberOfAllocatedSlots());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testImmediateReleaseTwoLevel() {
        try {
            JobID jobId = new JobID();
            JobVertexID vid = new JobVertexID();
            JobVertex vertex = new JobVertex("vertex", vid);
            SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{vid});
            SlotSharingGroupAssignment assignment = sharingGroup.getTaskAssignment();
            CoLocationGroup coLocationGroup = new CoLocationGroup(new JobVertex[]{vertex});
            CoLocationConstraint constraint = coLocationGroup.getLocationConstraint(0);
            Instance instance = SchedulerTestUtils.getRandomInstance(1);
            SharedSlot sharedSlot = instance.allocateSharedSlot(jobId, assignment);
            SimpleSlot sub = assignment.addSharedSlotAndAllocateSubSlot(sharedSlot, Locality.UNCONSTRAINED, constraint);
            Assert.assertNull((Object)sub.getGroupID());
            Assert.assertEquals((Object)constraint.getSharedSlot(), (Object)sub.getParent());
            sub.releaseSlot();
            Assert.assertTrue((boolean)sub.isReleased());
            Assert.assertTrue((boolean)sharedSlot.isReleased());
            Assert.assertEquals((long)1L, (long)instance.getNumberOfAvailableSlots());
            Assert.assertEquals((long)0L, (long)instance.getNumberOfAllocatedSlots());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

