/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import akka.actor.ActorSystem;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.concurrent.Future;
import org.apache.flink.runtime.instance.AvailableSlotsTest;
import org.apache.flink.runtime.instance.SlotPool;
import org.apache.flink.runtime.jobmanager.scheduler.NoResourceAvailableException;
import org.apache.flink.runtime.jobmanager.scheduler.ScheduledUnit;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.akka.AkkaRpcService;
import org.apache.flink.runtime.util.clock.Clock;
import org.apache.flink.runtime.util.clock.SystemClock;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class SlotPoolRpcTest {
    private static RpcService rpcService;

    @BeforeClass
    public static void setup() {
        ActorSystem actorSystem = AkkaUtils.createLocalActorSystem((Configuration)new Configuration());
        rpcService = new AkkaRpcService(actorSystem, Time.seconds((long)10L));
    }

    @AfterClass
    public static void shutdown() {
        rpcService.stopService();
    }

    @Test
    public void testSlotAllocationNoResourceManager() throws Exception {
        JobID jid = new JobID();
        SlotPool pool = new SlotPool(rpcService, jid, (Clock)SystemClock.getInstance(), Time.days((long)1L), Time.days((long)1L), Time.milliseconds((long)100L));
        pool.start(UUID.randomUUID(), "foobar");
        Future future = pool.allocateSlot((ScheduledUnit)Mockito.mock(ScheduledUnit.class), AvailableSlotsTest.DEFAULT_TESTING_PROFILE, null);
        try {
            future.get(4L, TimeUnit.SECONDS);
            Assert.fail((String)"We expected a ExecutionException.");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(NoResourceAvailableException.class, e.getCause().getClass());
        }
        catch (TimeoutException e) {
            Assert.fail((String)"future timed out rather than being failed");
        }
        catch (Exception e) {
            Assert.fail((String)("wrong exception: " + e));
        }
    }
}

