/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization.types;

import java.io.IOException;
import java.util.Random;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.io.network.api.serialization.types.SerializationTestType;

public class AsciiStringType
implements SerializationTestType {
    private static final int MAX_LEN = 1500;
    public String value;

    public AsciiStringType() {
        this.value = "";
    }

    private AsciiStringType(String value) {
        this.value = value;
    }

    @Override
    public AsciiStringType getRandom(Random rnd) {
        StringBuilder bld = new StringBuilder();
        int len = rnd.nextInt(1501);
        for (int i = 0; i < len; ++i) {
            bld.append((char)(rnd.nextInt(126) + 1));
        }
        return new AsciiStringType(bld.toString());
    }

    @Override
    public int length() {
        return this.value.getBytes(ConfigConstants.DEFAULT_CHARSET).length + 2;
    }

    public void write(DataOutputView out) throws IOException {
        out.writeUTF(this.value);
    }

    public void read(DataInputView in) throws IOException {
        this.value = in.readUTF();
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AsciiStringType) {
            AsciiStringType other = (AsciiStringType)obj;
            return this.value.equals(other.value);
        }
        return false;
    }
}

