/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization.types;

import java.io.IOException;
import java.util.Random;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.io.network.api.serialization.types.SerializationTestType;

public class ByteType
implements SerializationTestType {
    private byte value;

    public ByteType() {
        this.value = 0;
    }

    private ByteType(byte value) {
        this.value = value;
    }

    @Override
    public ByteType getRandom(Random rnd) {
        return new ByteType((byte)rnd.nextInt(256));
    }

    @Override
    public int length() {
        return 1;
    }

    public void write(DataOutputView out) throws IOException {
        out.writeByte((int)this.value);
    }

    public void read(DataInputView in) throws IOException {
        this.value = in.readByte();
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ByteType) {
            ByteType other = (ByteType)obj;
            return this.value == other.value;
        }
        return false;
    }
}

