/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BufferPoolFactoryTest {
    private static final int numBuffers = 1024;
    private static final int memorySegmentSize = 128;
    private NetworkBufferPool networkBufferPool;

    @Before
    public void setupNetworkBufferPool() {
        this.networkBufferPool = new NetworkBufferPool(1024, 128, MemoryType.HEAP);
    }

    @After
    public void verifyAllBuffersReturned() {
        String msg = "Did not return all buffers to network buffer pool after test.";
        Assert.assertEquals((String)msg, (long)1024L, (long)this.networkBufferPool.getNumberOfAvailableMemorySegments());
        this.networkBufferPool.destroy();
    }

    @Test(expected=IOException.class)
    public void testRequireMoreThanPossible() throws IOException {
        this.networkBufferPool.createBufferPool(this.networkBufferPool.getTotalNumberOfMemorySegments() * 2, Integer.MAX_VALUE);
    }

    @Test
    public void testBoundedPools() throws IOException {
        BufferPool lbp = this.networkBufferPool.createBufferPool(1, 1);
        Assert.assertEquals((long)1L, (long)lbp.getNumBuffers());
        lbp = this.networkBufferPool.createBufferPool(1, 2);
        Assert.assertEquals((long)2L, (long)lbp.getNumBuffers());
    }

    @Test
    public void testSingleManagedPoolGetsAll() throws IOException {
        BufferPool lbp = this.networkBufferPool.createBufferPool(1, Integer.MAX_VALUE);
        Assert.assertEquals((long)this.networkBufferPool.getTotalNumberOfMemorySegments(), (long)lbp.getNumBuffers());
    }

    @Test
    public void testSingleManagedPoolGetsAllExceptFixedOnes() throws IOException {
        BufferPool fixed = this.networkBufferPool.createBufferPool(24, 24);
        BufferPool lbp = this.networkBufferPool.createBufferPool(1, Integer.MAX_VALUE);
        Assert.assertEquals((long)24L, (long)fixed.getNumBuffers());
        Assert.assertEquals((long)(this.networkBufferPool.getTotalNumberOfMemorySegments() - fixed.getNumBuffers()), (long)lbp.getNumBuffers());
    }

    @Test
    public void testUniformDistribution() throws IOException {
        BufferPool first = this.networkBufferPool.createBufferPool(0, Integer.MAX_VALUE);
        Assert.assertEquals((long)this.networkBufferPool.getTotalNumberOfMemorySegments(), (long)first.getNumBuffers());
        BufferPool second = this.networkBufferPool.createBufferPool(0, Integer.MAX_VALUE);
        Assert.assertEquals((long)(this.networkBufferPool.getTotalNumberOfMemorySegments() / 2), (long)first.getNumBuffers());
        Assert.assertEquals((long)(this.networkBufferPool.getTotalNumberOfMemorySegments() / 2), (long)second.getNumBuffers());
    }

    @Test
    public void testUniformDistributionAllBuffers() throws IOException {
        BufferPool first = this.networkBufferPool.createBufferPool(this.networkBufferPool.getTotalNumberOfMemorySegments() / 2, Integer.MAX_VALUE);
        Assert.assertEquals((long)this.networkBufferPool.getTotalNumberOfMemorySegments(), (long)first.getNumBuffers());
        BufferPool second = this.networkBufferPool.createBufferPool(this.networkBufferPool.getTotalNumberOfMemorySegments() / 2, Integer.MAX_VALUE);
        Assert.assertEquals((long)(this.networkBufferPool.getTotalNumberOfMemorySegments() / 2), (long)first.getNumBuffers());
        Assert.assertEquals((long)(this.networkBufferPool.getTotalNumberOfMemorySegments() / 2), (long)second.getNumBuffers());
    }

    @Test
    public void testUniformDistributionBounded1() throws IOException {
        BufferPool first = this.networkBufferPool.createBufferPool(0, this.networkBufferPool.getTotalNumberOfMemorySegments());
        Assert.assertEquals((long)this.networkBufferPool.getTotalNumberOfMemorySegments(), (long)first.getNumBuffers());
        BufferPool second = this.networkBufferPool.createBufferPool(0, this.networkBufferPool.getTotalNumberOfMemorySegments());
        Assert.assertEquals((long)(this.networkBufferPool.getTotalNumberOfMemorySegments() / 2), (long)first.getNumBuffers());
        Assert.assertEquals((long)(this.networkBufferPool.getTotalNumberOfMemorySegments() / 2), (long)second.getNumBuffers());
    }

    @Test
    public void testUniformDistributionBounded2() throws IOException {
        BufferPool first = this.networkBufferPool.createBufferPool(0, 10);
        Assert.assertEquals((long)10L, (long)first.getNumBuffers());
        BufferPool second = this.networkBufferPool.createBufferPool(0, 10);
        Assert.assertEquals((long)10L, (long)first.getNumBuffers());
        Assert.assertEquals((long)10L, (long)second.getNumBuffers());
    }

    @Test
    public void testUniformDistributionBounded3() throws IOException {
        NetworkBufferPool globalPool = new NetworkBufferPool(3, 128, MemoryType.HEAP);
        BufferPool first = globalPool.createBufferPool(0, 10);
        Assert.assertEquals((long)3L, (long)first.getNumBuffers());
        BufferPool second = globalPool.createBufferPool(0, 10);
        Assert.assertEquals((long)3L, (long)(first.getNumBuffers() + second.getNumBuffers()));
        Assert.assertNotEquals((long)3L, (long)first.getNumBuffers());
        Assert.assertNotEquals((long)3L, (long)second.getNumBuffers());
        BufferPool third = globalPool.createBufferPool(0, 10);
        Assert.assertEquals((long)1L, (long)first.getNumBuffers());
        Assert.assertEquals((long)1L, (long)second.getNumBuffers());
        Assert.assertEquals((long)1L, (long)third.getNumBuffers());
        String msg = "Did not return all buffers to network buffer pool after test.";
        Assert.assertEquals((String)msg, (long)3L, (long)globalPool.getNumberOfAvailableMemorySegments());
        globalPool.destroy();
    }

    @Test
    public void testBufferRedistributionMixed1() throws IOException {
        for (int i = 0; i < 1000; ++i) {
            BufferPool first = this.networkBufferPool.createBufferPool(0, 10);
            Assert.assertEquals((long)10L, (long)first.getNumBuffers());
            BufferPool second = this.networkBufferPool.createBufferPool(0, 10);
            Assert.assertEquals((long)10L, (long)first.getNumBuffers());
            Assert.assertEquals((long)10L, (long)second.getNumBuffers());
            BufferPool third = this.networkBufferPool.createBufferPool(0, Integer.MAX_VALUE);
            for (BufferPool bp : new BufferPool[]{first, second, third}) {
                int size = this.networkBufferPool.getTotalNumberOfMemorySegments() * Math.min(this.networkBufferPool.getTotalNumberOfMemorySegments(), bp.getMaxNumberOfMemorySegments()) / (this.networkBufferPool.getTotalNumberOfMemorySegments() + 20);
                if (bp.getNumBuffers() == size || bp.getNumBuffers() == size + 1) continue;
                Assert.fail((String)("wrong buffer pool size after redistribution: " + bp.getNumBuffers()));
            }
            BufferPool fourth = this.networkBufferPool.createBufferPool(0, Integer.MAX_VALUE);
            for (BufferPool bp : new BufferPool[]{first, second, third, fourth}) {
                int size = this.networkBufferPool.getTotalNumberOfMemorySegments() * Math.min(this.networkBufferPool.getTotalNumberOfMemorySegments(), bp.getMaxNumberOfMemorySegments()) / (2 * this.networkBufferPool.getTotalNumberOfMemorySegments() + 20);
                if (bp.getNumBuffers() == size || bp.getNumBuffers() == size + 1) continue;
                Assert.fail((String)("wrong buffer pool size after redistribution: " + bp.getNumBuffers()));
            }
            this.verifyAllBuffersReturned();
            this.setupNetworkBufferPool();
        }
    }

    @Test
    public void testAllDistributed() throws IOException {
        for (int i = 0; i < 1000; ++i) {
            Random random = new Random();
            ArrayList<BufferPool> pools = new ArrayList<BufferPool>();
            int numPools = 32;
            long maxTotalUsed = 0L;
            for (int j = 0; j < numPools; ++j) {
                int numRequiredBuffers = random.nextInt(8);
                int maxUsedBuffers = random.nextBoolean() ? Integer.MAX_VALUE : Math.max(1, random.nextInt(10) + numRequiredBuffers);
                pools.add(this.networkBufferPool.createBufferPool(numRequiredBuffers, maxUsedBuffers));
                maxTotalUsed = Math.min(1024L, maxTotalUsed + (long)maxUsedBuffers);
                int numDistributedBuffers = 0;
                for (BufferPool pool : pools) {
                    numDistributedBuffers += pool.getNumBuffers();
                }
                Assert.assertEquals((long)maxTotalUsed, (long)numDistributedBuffers);
            }
            this.verifyAllBuffersReturned();
            this.setupNetworkBufferPool();
        }
    }

    @Test
    public void testCreateDestroy() throws IOException {
        BufferPool first = this.networkBufferPool.createBufferPool(0, Integer.MAX_VALUE);
        Assert.assertEquals((long)this.networkBufferPool.getTotalNumberOfMemorySegments(), (long)first.getNumBuffers());
        BufferPool second = this.networkBufferPool.createBufferPool(0, Integer.MAX_VALUE);
        Assert.assertEquals((long)(this.networkBufferPool.getTotalNumberOfMemorySegments() / 2), (long)first.getNumBuffers());
        Assert.assertEquals((long)(this.networkBufferPool.getTotalNumberOfMemorySegments() / 2), (long)second.getNumBuffers());
        first.lazyDestroy();
        Assert.assertEquals((long)this.networkBufferPool.getTotalNumberOfMemorySegments(), (long)second.getNumBuffers());
    }
}

