/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.util.ArrayList;
import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.junit.Assert;
import org.junit.Test;

public class NetworkBufferPoolTest {
    @Test
    public void testCreatePoolAfterDestroy() {
        try {
            int bufferSize = 128;
            int numBuffers = 10;
            NetworkBufferPool globalPool = new NetworkBufferPool(10, 128, MemoryType.HEAP);
            Assert.assertEquals((long)128L, (long)globalPool.getMemorySegmentSize());
            Assert.assertEquals((long)10L, (long)globalPool.getTotalNumberOfMemorySegments());
            Assert.assertEquals((long)10L, (long)globalPool.getNumberOfAvailableMemorySegments());
            Assert.assertEquals((long)0L, (long)globalPool.getNumberOfRegisteredBufferPools());
            globalPool.destroy();
            Assert.assertTrue((boolean)globalPool.isDestroyed());
            try {
                globalPool.createBufferPool(2, 2);
                Assert.fail((String)"Should throw an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                globalPool.createBufferPool(2, 10);
                Assert.fail((String)"Should throw an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                globalPool.createBufferPool(2, Integer.MAX_VALUE);
                Assert.fail((String)"Should throw an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDestroyAll() {
        try {
            NetworkBufferPool globalPool = new NetworkBufferPool(10, 128, MemoryType.HEAP);
            BufferPool fixedPool = globalPool.createBufferPool(2, 2);
            BufferPool boundedPool = globalPool.createBufferPool(0, 1);
            BufferPool nonFixedPool = globalPool.createBufferPool(5, Integer.MAX_VALUE);
            Assert.assertEquals((long)2L, (long)fixedPool.getNumberOfRequiredMemorySegments());
            Assert.assertEquals((long)0L, (long)boundedPool.getNumberOfRequiredMemorySegments());
            Assert.assertEquals((long)5L, (long)nonFixedPool.getNumberOfRequiredMemorySegments());
            ArrayList<Buffer> buffers = new ArrayList<Buffer>(globalPool.getTotalNumberOfMemorySegments());
            block8: for (int i = 0; i < 10; ++i) {
                for (BufferPool bp : new BufferPool[]{fixedPool, boundedPool, nonFixedPool}) {
                    Buffer buffer = bp.requestBuffer();
                    if (buffer == null) continue;
                    Assert.assertNotNull((Object)buffer.getMemorySegment());
                    buffers.add(buffer);
                    continue block8;
                }
            }
            Assert.assertEquals((long)globalPool.getTotalNumberOfMemorySegments(), (long)buffers.size());
            Assert.assertNull((Object)fixedPool.requestBuffer());
            Assert.assertNull((Object)boundedPool.requestBuffer());
            Assert.assertNull((Object)nonFixedPool.requestBuffer());
            globalPool.destroyAllBufferPools();
            Assert.assertFalse((boolean)globalPool.isDestroyed());
            Assert.assertTrue((boolean)fixedPool.isDestroyed());
            Assert.assertTrue((boolean)boundedPool.isDestroyed());
            Assert.assertTrue((boolean)nonFixedPool.isDestroyed());
            Assert.assertEquals((long)0L, (long)globalPool.getNumberOfRegisteredBufferPools());
            Assert.assertEquals((long)0L, (long)globalPool.getNumberOfAvailableMemorySegments());
            for (Buffer b : buffers) {
                b.recycle();
            }
            Assert.assertEquals((long)globalPool.getTotalNumberOfMemorySegments(), (long)globalPool.getNumberOfAvailableMemorySegments());
            try {
                fixedPool.requestBuffer();
                Assert.fail((String)"Should fail with an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                boundedPool.requestBuffer();
                Assert.fail((String)"Should fail with an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                nonFixedPool.requestBuffer();
                Assert.fail((String)"Should fail with an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            Assert.assertNotNull((Object)globalPool.createBufferPool(10, Integer.MAX_VALUE));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

