/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import java.net.InetAddress;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.io.network.netty.NettyConfig;
import org.apache.flink.runtime.io.network.netty.NettyProtocol;
import org.apache.flink.runtime.io.network.netty.NettyTestUtil;
import org.apache.flink.util.NetUtils;
import org.junit.Assert;
import org.junit.Test;

public class NettyClientServerSslTest {
    @Test
    public void testValidSslConnection() throws Exception {
        NettyProtocol protocol = new NettyProtocol(){

            public ChannelHandler[] getServerChannelHandlers() {
                return new ChannelHandler[0];
            }

            public ChannelHandler[] getClientChannelHandlers() {
                return new ChannelHandler[0];
            }
        };
        NettyConfig nettyConfig = new NettyConfig(InetAddress.getLoopbackAddress(), NetUtils.getAvailablePort(), NettyTestUtil.DEFAULT_SEGMENT_SIZE, 1, this.createSslConfig());
        NettyTestUtil.NettyServerAndClient serverAndClient = NettyTestUtil.initServerAndClient(protocol, nettyConfig);
        Channel ch = NettyTestUtil.connect(serverAndClient);
        ch.pipeline().addLast(new ChannelHandler[]{new StringDecoder()}).addLast(new ChannelHandler[]{new StringEncoder()});
        Assert.assertTrue((boolean)ch.writeAndFlush((Object)"test").await().isSuccess());
        NettyTestUtil.shutdown(serverAndClient);
    }

    @Test
    public void testInvalidSslConfiguration() throws Exception {
        NettyProtocol protocol = new NettyProtocol(){

            public ChannelHandler[] getServerChannelHandlers() {
                return new ChannelHandler[0];
            }

            public ChannelHandler[] getClientChannelHandlers() {
                return new ChannelHandler[0];
            }
        };
        Configuration config = this.createSslConfig();
        config.setString("security.ssl.keystore-password", "invalidpassword");
        NettyConfig nettyConfig = new NettyConfig(InetAddress.getLoopbackAddress(), NetUtils.getAvailablePort(), NettyTestUtil.DEFAULT_SEGMENT_SIZE, 1, config);
        NettyTestUtil.NettyServerAndClient serverAndClient = null;
        try {
            serverAndClient = NettyTestUtil.initServerAndClient(protocol, nettyConfig);
            Assert.fail((String)"Created server and client from invalid configuration");
        }
        catch (Exception exception) {
            // empty catch block
        }
        NettyTestUtil.shutdown(serverAndClient);
    }

    @Test
    public void testSslHandshakeError() throws Exception {
        NettyProtocol protocol = new NettyProtocol(){

            public ChannelHandler[] getServerChannelHandlers() {
                return new ChannelHandler[0];
            }

            public ChannelHandler[] getClientChannelHandlers() {
                return new ChannelHandler[0];
            }
        };
        Configuration config = this.createSslConfig();
        config.setString("security.ssl.keystore", "src/test/resources/untrusted.keystore");
        NettyConfig nettyConfig = new NettyConfig(InetAddress.getLoopbackAddress(), NetUtils.getAvailablePort(), NettyTestUtil.DEFAULT_SEGMENT_SIZE, 1, config);
        NettyTestUtil.NettyServerAndClient serverAndClient = NettyTestUtil.initServerAndClient(protocol, nettyConfig);
        Channel ch = NettyTestUtil.connect(serverAndClient);
        ch.pipeline().addLast(new ChannelHandler[]{new StringDecoder()}).addLast(new ChannelHandler[]{new StringEncoder()});
        Assert.assertFalse((boolean)ch.writeAndFlush((Object)"test").await().isSuccess());
        NettyTestUtil.shutdown(serverAndClient);
    }

    private Configuration createSslConfig() throws Exception {
        Configuration flinkConfig = new Configuration();
        flinkConfig.setBoolean("security.ssl.enabled", true);
        flinkConfig.setString("security.ssl.keystore", "src/test/resources/local127.keystore");
        flinkConfig.setString("security.ssl.keystore-password", "password");
        flinkConfig.setString("security.ssl.key-password", "password");
        flinkConfig.setString("security.ssl.truststore", "src/test/resources/local127.truststore");
        flinkConfig.setString("security.ssl.truststore-password", "password");
        return flinkConfig;
    }
}

