/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import org.apache.flink.runtime.execution.CancelTaskException;
import org.apache.flink.runtime.io.network.netty.NettyMessage;
import org.apache.flink.runtime.io.network.netty.PartitionRequestQueue;
import org.apache.flink.runtime.io.network.netty.SequenceNumberingViewReader;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionProvider;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class PartitionRequestQueueTest {
    @Test
    public void testProducerFailedException() throws Exception {
        PartitionRequestQueue queue = new PartitionRequestQueue();
        ResultPartitionProvider partitionProvider = (ResultPartitionProvider)Mockito.mock(ResultPartitionProvider.class);
        ResultPartitionID rpid = new ResultPartitionID();
        ResultSubpartitionView view = (ResultSubpartitionView)Mockito.mock(ResultSubpartitionView.class);
        Mockito.when((Object)view.isReleased()).thenReturn((Object)true);
        Mockito.when((Object)view.getFailureCause()).thenReturn((Object)new RuntimeException("Expected test exception"));
        Mockito.when((Object)partitionProvider.createSubpartitionView((ResultPartitionID)Matchers.eq((Object)rpid), Matchers.eq((int)0), (BufferAvailabilityListener)Matchers.any(BufferAvailabilityListener.class))).thenReturn((Object)view);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{queue});
        SequenceNumberingViewReader seqView = new SequenceNumberingViewReader(new InputChannelID(), queue);
        seqView.requestSubpartitionView(partitionProvider, rpid, 0);
        queue.notifyReaderNonEmpty(seqView);
        ch.runPendingTasks();
        Object msg = ch.readOutbound();
        Assert.assertEquals(msg.getClass(), NettyMessage.ErrorResponse.class);
        NettyMessage.ErrorResponse err = (NettyMessage.ErrorResponse)msg;
        Assert.assertTrue((boolean)(err.cause instanceof CancelTaskException));
    }
}

