/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartition;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartitionView;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.SubpartitionTestBase;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.util.TestBufferFactory;
import org.apache.flink.runtime.io.network.util.TestConsumerCallback;
import org.apache.flink.runtime.io.network.util.TestPooledBufferProvider;
import org.apache.flink.runtime.io.network.util.TestProducerSource;
import org.apache.flink.runtime.io.network.util.TestSubpartitionConsumer;
import org.apache.flink.runtime.io.network.util.TestSubpartitionProducer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class PipelinedSubpartitionTest
extends SubpartitionTestBase {
    private static final ExecutorService executorService = Executors.newCachedThreadPool();

    @AfterClass
    public static void shutdownExecutorService() throws Exception {
        executorService.shutdownNow();
    }

    PipelinedSubpartition createSubpartition() {
        ResultPartition parent = (ResultPartition)Mockito.mock(ResultPartition.class);
        return new PipelinedSubpartition(0, parent);
    }

    @Test
    public void testIllegalReadViewRequest() throws Exception {
        PipelinedSubpartition subpartition = this.createSubpartition();
        Assert.assertNotNull((Object)subpartition.createReadView(new BufferAvailabilityListener(){

            public void notifyBuffersAvailable(long numBuffers) {
            }
        }));
        try {
            subpartition.createReadView(new BufferAvailabilityListener(){

                public void notifyBuffersAvailable(long numBuffers) {
                }
            });
            Assert.fail((String)"Did not throw expected exception after duplicate notifyNonEmpty view request.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testBasicPipelinedProduceConsumeLogic() throws Exception {
        PipelinedSubpartition subpartition = this.createSubpartition();
        BufferAvailabilityListener listener = (BufferAvailabilityListener)Mockito.mock(BufferAvailabilityListener.class);
        PipelinedSubpartitionView view = subpartition.createReadView(listener);
        Assert.assertNull((Object)view.getNextBuffer());
        ((BufferAvailabilityListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).notifyBuffersAvailable(Matchers.eq((long)0L));
        subpartition.add(TestBufferFactory.createBuffer());
        ((BufferAvailabilityListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).notifyBuffersAvailable(Matchers.eq((long)1L));
        Assert.assertNotNull((Object)view.getNextBuffer());
        Assert.assertNull((Object)view.getNextBuffer());
        subpartition.add(TestBufferFactory.createBuffer());
        ((BufferAvailabilityListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)2))).notifyBuffersAvailable(Matchers.eq((long)1L));
    }

    @Test
    public void testConcurrentFastProduceAndFastConsume() throws Exception {
        this.testProduceConsume(false, false);
    }

    @Test
    public void testConcurrentFastProduceAndSlowConsume() throws Exception {
        this.testProduceConsume(false, true);
    }

    @Test
    public void testConcurrentSlowProduceAndFastConsume() throws Exception {
        this.testProduceConsume(true, false);
    }

    @Test
    public void testConcurrentSlowProduceAndSlowConsume() throws Exception {
        this.testProduceConsume(true, true);
    }

    @Test
    public void testIsReleasedChecksParent() throws Exception {
        PipelinedSubpartition subpartition = (PipelinedSubpartition)Mockito.mock(PipelinedSubpartition.class);
        PipelinedSubpartitionView reader = new PipelinedSubpartitionView(subpartition, (BufferAvailabilityListener)Mockito.mock(BufferAvailabilityListener.class));
        Assert.assertFalse((boolean)reader.isReleased());
        ((PipelinedSubpartition)Mockito.verify((Object)subpartition, (VerificationMode)Mockito.times((int)1))).isReleased();
        Mockito.when((Object)subpartition.isReleased()).thenReturn((Object)true);
        Assert.assertTrue((boolean)reader.isReleased());
        ((PipelinedSubpartition)Mockito.verify((Object)subpartition, (VerificationMode)Mockito.times((int)2))).isReleased();
    }

    private void testProduceConsume(boolean isSlowProducer, boolean isSlowConsumer) throws Exception {
        int producerBufferPoolSize = 8;
        int producerNumberOfBuffersToProduce = 128;
        TestProducerSource producerSource = new TestProducerSource(){
            private BufferProvider bufferProvider = new TestPooledBufferProvider(8);
            private int numberOfBuffers;

            @Override
            public BufferOrEvent getNextBufferOrEvent() throws Exception {
                if (this.numberOfBuffers == 128) {
                    return null;
                }
                Buffer buffer = this.bufferProvider.requestBufferBlocking();
                MemorySegment segment = buffer.getMemorySegment();
                int next = this.numberOfBuffers * (segment.size() / 4);
                for (int i = 0; i < segment.size(); i += 4) {
                    segment.putInt(i, next);
                    ++next;
                }
                ++this.numberOfBuffers;
                return new BufferOrEvent(buffer, 0);
            }
        };
        TestConsumerCallback consumerCallback = new TestConsumerCallback(){
            private int numberOfBuffers;

            @Override
            public void onBuffer(Buffer buffer) {
                MemorySegment segment = buffer.getMemorySegment();
                int expected = this.numberOfBuffers * (segment.size() / 4);
                for (int i = 0; i < segment.size(); i += 4) {
                    Assert.assertEquals((long)expected, (long)segment.getInt(i));
                    ++expected;
                }
                ++this.numberOfBuffers;
                buffer.recycle();
            }

            @Override
            public void onEvent(AbstractEvent event) {
            }
        };
        PipelinedSubpartition subpartition = this.createSubpartition();
        TestSubpartitionConsumer consumer = new TestSubpartitionConsumer(isSlowConsumer, consumerCallback);
        PipelinedSubpartitionView view = subpartition.createReadView((BufferAvailabilityListener)consumer);
        consumer.setSubpartitionView((ResultSubpartitionView)view);
        Future<Boolean> producerResult = executorService.submit(new TestSubpartitionProducer((ResultSubpartition)subpartition, isSlowProducer, producerSource));
        Future<Boolean> consumerResult = executorService.submit(consumer);
        producerResult.get();
        consumerResult.get();
    }
}

