/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionConsumableNotifier;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.util.TestBufferFactory;
import org.apache.flink.runtime.taskmanager.TaskActions;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ResultPartitionTest {
    @Test
    public void testSendScheduleOrUpdateConsumersMessage() throws Exception {
        ResultPartitionConsumableNotifier notifier = (ResultPartitionConsumableNotifier)Mockito.mock(ResultPartitionConsumableNotifier.class);
        ResultPartition partition = ResultPartitionTest.createPartition(notifier, ResultPartitionType.PIPELINED, true);
        partition.add(TestBufferFactory.createBuffer(), 0);
        ((ResultPartitionConsumableNotifier)Mockito.verify((Object)notifier, (VerificationMode)Mockito.times((int)1))).notifyPartitionConsumable((JobID)Matchers.any(JobID.class), (ResultPartitionID)Matchers.any(ResultPartitionID.class), (TaskActions)Matchers.any(TaskActions.class));
        notifier = (ResultPartitionConsumableNotifier)Mockito.mock(ResultPartitionConsumableNotifier.class);
        partition = ResultPartitionTest.createPartition(notifier, ResultPartitionType.PIPELINED, false);
        partition.add(TestBufferFactory.createBuffer(), 0);
        ((ResultPartitionConsumableNotifier)Mockito.verify((Object)notifier, (VerificationMode)Mockito.never())).notifyPartitionConsumable((JobID)Matchers.any(JobID.class), (ResultPartitionID)Matchers.any(ResultPartitionID.class), (TaskActions)Matchers.any(TaskActions.class));
        notifier = (ResultPartitionConsumableNotifier)Mockito.mock(ResultPartitionConsumableNotifier.class);
        partition = ResultPartitionTest.createPartition(notifier, ResultPartitionType.BLOCKING, true);
        partition.add(TestBufferFactory.createBuffer(), 0);
        ((ResultPartitionConsumableNotifier)Mockito.verify((Object)notifier, (VerificationMode)Mockito.never())).notifyPartitionConsumable((JobID)Matchers.any(JobID.class), (ResultPartitionID)Matchers.any(ResultPartitionID.class), (TaskActions)Matchers.any(TaskActions.class));
        notifier = (ResultPartitionConsumableNotifier)Mockito.mock(ResultPartitionConsumableNotifier.class);
        partition = ResultPartitionTest.createPartition(notifier, ResultPartitionType.BLOCKING, false);
        partition.add(TestBufferFactory.createBuffer(), 0);
        ((ResultPartitionConsumableNotifier)Mockito.verify((Object)notifier, (VerificationMode)Mockito.never())).notifyPartitionConsumable((JobID)Matchers.any(JobID.class), (ResultPartitionID)Matchers.any(ResultPartitionID.class), (TaskActions)Matchers.any(TaskActions.class));
    }

    @Test
    public void testAddOnFinishedPipelinedPartition() throws Exception {
        this.testAddOnFinishedPartition(ResultPartitionType.PIPELINED);
    }

    @Test
    public void testAddOnFinishedBlockingPartition() throws Exception {
        this.testAddOnFinishedPartition(ResultPartitionType.BLOCKING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testAddOnFinishedPartition(ResultPartitionType pipelined) throws Exception {
        Buffer buffer = TestBufferFactory.createBuffer();
        ResultPartitionConsumableNotifier notifier = (ResultPartitionConsumableNotifier)Mockito.mock(ResultPartitionConsumableNotifier.class);
        try {
            ResultPartition partition = ResultPartitionTest.createPartition(notifier, pipelined, true);
            partition.finish();
            Mockito.reset((Object[])new ResultPartitionConsumableNotifier[]{notifier});
            partition.add(buffer, 0);
            Assert.fail((String)"exception expected");
        }
        catch (IllegalStateException illegalStateException) {
        }
        finally {
            if (!buffer.isRecycled()) {
                Assert.fail((String)"buffer not recycled");
                buffer.recycle();
            }
            ((ResultPartitionConsumableNotifier)Mockito.verify((Object)notifier, (VerificationMode)Mockito.never())).notifyPartitionConsumable((JobID)Matchers.any(JobID.class), (ResultPartitionID)Matchers.any(ResultPartitionID.class), (TaskActions)Matchers.any(TaskActions.class));
        }
    }

    @Test
    public void testAddOnReleasedPipelinedPartition() throws Exception {
        this.testAddOnReleasedPartition(ResultPartitionType.PIPELINED);
    }

    @Test
    public void testAddOnReleasedBlockingPartition() throws Exception {
        this.testAddOnReleasedPartition(ResultPartitionType.BLOCKING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testAddOnReleasedPartition(ResultPartitionType pipelined) throws Exception {
        Buffer buffer = TestBufferFactory.createBuffer();
        ResultPartitionConsumableNotifier notifier = (ResultPartitionConsumableNotifier)Mockito.mock(ResultPartitionConsumableNotifier.class);
        try {
            ResultPartition partition = ResultPartitionTest.createPartition(notifier, pipelined, true);
            partition.release();
            partition.add(buffer, 0);
        }
        finally {
            if (!buffer.isRecycled()) {
                Assert.fail((String)"buffer not recycled");
                buffer.recycle();
            }
            ((ResultPartitionConsumableNotifier)Mockito.verify((Object)notifier, (VerificationMode)Mockito.never())).notifyPartitionConsumable((JobID)Matchers.any(JobID.class), (ResultPartitionID)Matchers.any(ResultPartitionID.class), (TaskActions)Matchers.any(TaskActions.class));
        }
    }

    private static ResultPartition createPartition(ResultPartitionConsumableNotifier notifier, ResultPartitionType type, boolean sendScheduleOrUpdateConsumersMessage) {
        return new ResultPartition("TestTask", (TaskActions)Mockito.mock(TaskActions.class), new JobID(), new ResultPartitionID(), type, 1, 1, (ResultPartitionManager)Mockito.mock(ResultPartitionManager.class), notifier, (IOManager)Mockito.mock(IOManager.class), sendScheduleOrUpdateConsumersMessage);
    }
}

