/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.util;

import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.util.TestConsumerCallback;
import org.apache.flink.util.Preconditions;

public class TestSubpartitionConsumer
implements Callable<Boolean>,
BufferAvailabilityListener {
    private static final int MAX_SLEEP_TIME_MS = 20;
    private volatile ResultSubpartitionView subpartitionView;
    private BlockingQueue<ResultSubpartitionView> viewQueue = new ArrayBlockingQueue<ResultSubpartitionView>(1);
    private final boolean isSlowConsumer;
    private final TestConsumerCallback callback;
    private final Random random;
    private final AtomicLong numBuffersAvailable = new AtomicLong();

    public TestSubpartitionConsumer(boolean isSlowConsumer, TestConsumerCallback callback) {
        this.isSlowConsumer = isSlowConsumer;
        this.random = isSlowConsumer ? new Random() : null;
        this.callback = (TestConsumerCallback)Preconditions.checkNotNull((Object)callback);
    }

    public void setSubpartitionView(ResultSubpartitionView subpartitionView) {
        this.subpartitionView = (ResultSubpartitionView)Preconditions.checkNotNull((Object)subpartitionView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() throws Exception {
        try {
            while (true) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                if (this.numBuffersAvailable.get() == 0L) {
                    AtomicLong atomicLong = this.numBuffersAvailable;
                    synchronized (atomicLong) {
                        while (this.numBuffersAvailable.get() == 0L) {
                            this.numBuffersAvailable.wait();
                        }
                    }
                }
                Buffer buffer = this.subpartitionView.getNextBuffer();
                if (this.isSlowConsumer) {
                    Thread.sleep(this.random.nextInt(21));
                }
                if (buffer != null) {
                    this.numBuffersAvailable.decrementAndGet();
                    if (buffer.isBuffer()) {
                        this.callback.onBuffer(buffer);
                        continue;
                    }
                    AbstractEvent event = EventSerializer.fromBuffer((Buffer)buffer, (ClassLoader)this.getClass().getClassLoader());
                    this.callback.onEvent(event);
                    buffer.recycle();
                    if (event.getClass() == EndOfPartitionEvent.class) {
                        this.subpartitionView.notifySubpartitionConsumed();
                        Boolean bl = true;
                        return bl;
                    }
                } else {
                    if (!this.subpartitionView.isReleased()) continue;
                    Boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            this.subpartitionView.releaseAllResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyBuffersAvailable(long numBuffers) {
        if (numBuffers > 0L && this.numBuffersAvailable.getAndAdd(numBuffers) == 0L) {
            AtomicLong atomicLong = this.numBuffersAvailable;
            synchronized (atomicLong) {
                this.numBuffersAvailable.notifyAll();
            }
        }
    }
}

