/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.Serializable;
import java.util.List;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.junit.Assert;
import org.junit.Test;

public class JobGraphTest {
    @Test
    public void testSerialization() {
        try {
            JobGraph jg = new JobGraph("The graph");
            jg.getJobConfiguration().setString("some key", "some value");
            jg.getJobConfiguration().setDouble("Life of ", Math.PI);
            JobVertex source1 = new JobVertex("source1");
            JobVertex source2 = new JobVertex("source2");
            JobVertex target = new JobVertex("target");
            target.connectNewDataSetAsInput(source1, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            target.connectNewDataSetAsInput(source2, DistributionPattern.ALL_TO_ALL, ResultPartitionType.PIPELINED);
            jg.addVertex(source1);
            jg.addVertex(source2);
            jg.addVertex(target);
            JobGraph copy = (JobGraph)CommonTestUtils.createCopySerializable((Serializable)jg);
            Assert.assertEquals((Object)jg.getName(), (Object)copy.getName());
            Assert.assertEquals((Object)jg.getJobID(), (Object)copy.getJobID());
            Assert.assertEquals((Object)jg.getJobConfiguration(), (Object)copy.getJobConfiguration());
            Assert.assertEquals((long)jg.getNumberOfVertices(), (long)copy.getNumberOfVertices());
            for (JobVertex vertex : copy.getVertices()) {
                JobVertex original = jg.findVertexByID(vertex.getID());
                Assert.assertNotNull((Object)original);
                Assert.assertEquals((Object)original.getName(), (Object)vertex.getName());
                Assert.assertEquals((long)original.getNumberOfInputs(), (long)vertex.getNumberOfInputs());
                Assert.assertEquals((long)original.getNumberOfProducedIntermediateDataSets(), (long)vertex.getNumberOfProducedIntermediateDataSets());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testTopologicalSort1() {
        try {
            JobVertex source1 = new JobVertex("source1");
            JobVertex source2 = new JobVertex("source2");
            JobVertex target1 = new JobVertex("target1");
            JobVertex target2 = new JobVertex("target2");
            JobVertex intermediate1 = new JobVertex("intermediate1");
            JobVertex intermediate2 = new JobVertex("intermediate2");
            target1.connectNewDataSetAsInput(source1, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            target2.connectNewDataSetAsInput(source1, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            target2.connectNewDataSetAsInput(intermediate2, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            intermediate2.connectNewDataSetAsInput(intermediate1, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            intermediate1.connectNewDataSetAsInput(source2, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            JobGraph graph = new JobGraph("TestGraph", new JobVertex[]{source1, source2, intermediate1, intermediate2, target1, target2});
            List sorted = graph.getVerticesSortedTopologicallyFromSources();
            Assert.assertEquals((long)6L, (long)sorted.size());
            JobGraphTest.assertBefore(source1, target1, sorted);
            JobGraphTest.assertBefore(source1, target2, sorted);
            JobGraphTest.assertBefore(source2, target2, sorted);
            JobGraphTest.assertBefore(source2, intermediate1, sorted);
            JobGraphTest.assertBefore(source2, intermediate2, sorted);
            JobGraphTest.assertBefore(intermediate1, target2, sorted);
            JobGraphTest.assertBefore(intermediate2, target2, sorted);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testTopologicalSort2() {
        try {
            JobVertex source1 = new JobVertex("source1");
            JobVertex source2 = new JobVertex("source2");
            JobVertex root = new JobVertex("root");
            JobVertex l11 = new JobVertex("layer 1 - 1");
            JobVertex l12 = new JobVertex("layer 1 - 2");
            JobVertex l13 = new JobVertex("layer 1 - 3");
            JobVertex l2 = new JobVertex("layer 2");
            root.connectNewDataSetAsInput(l13, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            root.connectNewDataSetAsInput(source2, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            root.connectNewDataSetAsInput(l2, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            l2.connectNewDataSetAsInput(l11, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            l2.connectNewDataSetAsInput(l12, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            l11.connectNewDataSetAsInput(source1, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            l12.connectNewDataSetAsInput(source1, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            l12.connectNewDataSetAsInput(source2, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            l13.connectNewDataSetAsInput(source2, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            JobGraph graph = new JobGraph("TestGraph", new JobVertex[]{source1, source2, root, l11, l13, l12, l2});
            List sorted = graph.getVerticesSortedTopologicallyFromSources();
            Assert.assertEquals((long)7L, (long)sorted.size());
            JobGraphTest.assertBefore(source1, root, sorted);
            JobGraphTest.assertBefore(source2, root, sorted);
            JobGraphTest.assertBefore(l11, root, sorted);
            JobGraphTest.assertBefore(l12, root, sorted);
            JobGraphTest.assertBefore(l13, root, sorted);
            JobGraphTest.assertBefore(l2, root, sorted);
            JobGraphTest.assertBefore(l11, l2, sorted);
            JobGraphTest.assertBefore(l12, l2, sorted);
            JobGraphTest.assertBefore(l2, root, sorted);
            JobGraphTest.assertBefore(source1, l2, sorted);
            JobGraphTest.assertBefore(source2, l2, sorted);
            JobGraphTest.assertBefore(source2, l13, sorted);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testTopologicalSort3() {
        try {
            JobVertex source = new JobVertex("source");
            JobVertex op1 = new JobVertex("op4");
            JobVertex op2 = new JobVertex("op2");
            JobVertex op3 = new JobVertex("op3");
            op1.connectNewDataSetAsInput(source, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            op2.connectNewDataSetAsInput(op1, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            op2.connectNewDataSetAsInput(source, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            op3.connectNewDataSetAsInput(op2, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            JobGraph graph = new JobGraph("TestGraph", new JobVertex[]{source, op1, op2, op3});
            List sorted = graph.getVerticesSortedTopologicallyFromSources();
            Assert.assertEquals((long)4L, (long)sorted.size());
            JobGraphTest.assertBefore(source, op1, sorted);
            JobGraphTest.assertBefore(source, op2, sorted);
            JobGraphTest.assertBefore(op1, op2, sorted);
            JobGraphTest.assertBefore(op2, op3, sorted);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testTopoSortCyclicGraphNoSources() {
        try {
            JobVertex v1 = new JobVertex("1");
            JobVertex v2 = new JobVertex("2");
            JobVertex v3 = new JobVertex("3");
            JobVertex v4 = new JobVertex("4");
            v1.connectNewDataSetAsInput(v4, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            v2.connectNewDataSetAsInput(v1, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            v3.connectNewDataSetAsInput(v2, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            v4.connectNewDataSetAsInput(v3, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            JobGraph jg = new JobGraph("Cyclic Graph", new JobVertex[]{v1, v2, v3, v4});
            try {
                jg.getVerticesSortedTopologicallyFromSources();
                Assert.fail((String)"Failed to raise error on topologically sorting cyclic graph.");
            }
            catch (InvalidProgramException invalidProgramException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testTopoSortCyclicGraphIntermediateCycle() {
        try {
            JobVertex source = new JobVertex("source");
            JobVertex v1 = new JobVertex("1");
            JobVertex v2 = new JobVertex("2");
            JobVertex v3 = new JobVertex("3");
            JobVertex v4 = new JobVertex("4");
            JobVertex target = new JobVertex("target");
            v1.connectNewDataSetAsInput(source, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            v1.connectNewDataSetAsInput(v4, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            v2.connectNewDataSetAsInput(v1, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            v3.connectNewDataSetAsInput(v2, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            v4.connectNewDataSetAsInput(v3, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            target.connectNewDataSetAsInput(v3, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            JobGraph jg = new JobGraph("Cyclic Graph", new JobVertex[]{v1, v2, v3, v4, source, target});
            try {
                jg.getVerticesSortedTopologicallyFromSources();
                Assert.fail((String)"Failed to raise error on topologically sorting cyclic graph.");
            }
            catch (InvalidProgramException invalidProgramException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static final void assertBefore(JobVertex v1, JobVertex v2, List<JobVertex> list) {
        boolean seenFirst = false;
        for (JobVertex v : list) {
            if (v == v1) {
                seenFirst = true;
                continue;
            }
            if (v != v2) continue;
            if (seenFirst) break;
            Assert.fail((String)("The first vertex (" + v1 + ") is not before the second vertex (" + v2 + ")"));
            break;
        }
    }
}

