/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.tasks;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.ExternalizedCheckpointSettings;
import org.apache.flink.runtime.jobgraph.tasks.JobCheckpointingSettings;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;
import org.junit.Assert;
import org.junit.Test;

public class JobCheckpointingSettingsTest {
    @Test
    public void testIsJavaSerializable() throws Exception {
        JobCheckpointingSettings settings = new JobCheckpointingSettings(Arrays.asList(new JobVertexID(), new JobVertexID()), Arrays.asList(new JobVertexID(), new JobVertexID()), Arrays.asList(new JobVertexID(), new JobVertexID()), 1231231L, 1231L, 112L, 12, ExternalizedCheckpointSettings.externalizeCheckpoints((boolean)true), (StateBackend)new MemoryStateBackend(), false);
        JobCheckpointingSettings copy = (JobCheckpointingSettings)CommonTestUtils.createCopySerializable((Serializable)settings);
        Assert.assertEquals((Object)settings.getVerticesToAcknowledge(), (Object)copy.getVerticesToAcknowledge());
        Assert.assertEquals((Object)settings.getVerticesToConfirm(), (Object)copy.getVerticesToConfirm());
        Assert.assertEquals((Object)settings.getVerticesToTrigger(), (Object)copy.getVerticesToTrigger());
        Assert.assertEquals((long)settings.getCheckpointInterval(), (long)copy.getCheckpointInterval());
        Assert.assertEquals((long)settings.getCheckpointTimeout(), (long)copy.getCheckpointTimeout());
        Assert.assertEquals((long)settings.getMinPauseBetweenCheckpoints(), (long)copy.getMinPauseBetweenCheckpoints());
        Assert.assertEquals((long)settings.getMaxConcurrentCheckpoints(), (long)copy.getMaxConcurrentCheckpoints());
        Assert.assertEquals((Object)settings.getExternalizedCheckpointSettings().externalizeCheckpoints(), (Object)copy.getExternalizedCheckpointSettings().externalizeCheckpoints());
        Assert.assertEquals((Object)settings.getExternalizedCheckpointSettings().deleteOnCancellation(), (Object)copy.getExternalizedCheckpointSettings().deleteOnCancellation());
        Assert.assertEquals((Object)settings.isExactlyOnce(), (Object)copy.isExactlyOnce());
        Assert.assertNotNull((Object)copy.getDefaultStateBackend());
        Assert.assertTrue((copy.getDefaultStateBackend().getClass() == MemoryStateBackend.class ? 1 : 0) != 0);
    }
}

