/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager;

import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.jobmanager.HighAvailabilityMode;
import org.junit.Assert;
import org.junit.Test;

public class HighAvailabilityModeTest {
    private static final HighAvailabilityMode DEFAULT_HA_MODE = HighAvailabilityMode.valueOf((String)ConfigConstants.DEFAULT_HA_MODE.toUpperCase());

    @Test
    public void testFromConfig() throws Exception {
        Configuration config = new Configuration();
        Assert.assertEquals((Object)DEFAULT_HA_MODE, (Object)HighAvailabilityMode.fromConfig((Configuration)config));
        config.setString(HighAvailabilityOptions.HA_MODE, HighAvailabilityMode.ZOOKEEPER.name().toLowerCase());
        Assert.assertEquals((Object)HighAvailabilityMode.ZOOKEEPER, (Object)HighAvailabilityMode.fromConfig((Configuration)config));
    }

    @Test
    public void testDeprecatedFromConfig() throws Exception {
        Configuration config = new Configuration();
        config.setString("recovery.mode", ConfigConstants.DEFAULT_RECOVERY_MODE);
        Assert.assertEquals((Object)DEFAULT_HA_MODE, (Object)HighAvailabilityMode.fromConfig((Configuration)config));
        config.setString("recovery.mode", HighAvailabilityMode.ZOOKEEPER.name().toLowerCase());
        Assert.assertEquals((Object)HighAvailabilityMode.ZOOKEEPER, (Object)HighAvailabilityMode.fromConfig((Configuration)config));
        config.setString("high-availability", HighAvailabilityMode.NONE.name().toLowerCase());
        config.setString("recovery.mode", HighAvailabilityMode.ZOOKEEPER.name().toLowerCase());
        Assert.assertEquals((Object)HighAvailabilityMode.NONE, (Object)HighAvailabilityMode.fromConfig((Configuration)config));
    }
}

