/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager;

import akka.actor.ActorSystem;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils$;
import org.apache.flink.util.NetUtils;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000113A!\u0001\u0002\u0001\u001b\tA\"j\u001c2NC:\fw-\u001a:D_:tWm\u0019;j_:$Vm\u001d;\u000b\u0005\r!\u0011A\u00036pE6\fg.Y4fe*\u0011QAB\u0001\beVtG/[7f\u0015\t9\u0001\"A\u0003gY&t7N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\"B\u000b\u0001\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\u0003\u0011\u001dQ\u0002A1A\u0005\nm\tq\u0001^5nK>,H/F\u0001\u001d!\tyQ$\u0003\u0002\u001f!\t\u0019\u0011J\u001c;\t\r\u0001\u0002\u0001\u0015!\u0003\u001d\u0003!!\u0018.\\3pkR\u0004\u0003\"\u0002\u0012\u0001\t\u0003\u0019\u0013\u0001\n;fgR\u0014Vm]8mm\u0016,fN]3bG\"\f'\r\\3BGR|'\u000fT8dC2Dun\u001d;\u0015\u0003\u0011\u0002\"aD\u0013\n\u0005\u0019\u0002\"\u0001B+oSRD#!\t\u0015\u0011\u0005%bS\"\u0001\u0016\u000b\u0005-R\u0011!\u00026v]&$\u0018BA\u0017+\u0005\u0011!Vm\u001d;\t\u000b=\u0002A\u0011A\u0012\u0002KQ,7\u000f\u001e*fg>dg/Z+oe\u0016\f7\r[1cY\u0016\f5\r^8s%\u0016lw\u000e^3I_N$\bF\u0001\u0018)\u0011\u0015\u0011\u0004\u0001\"\u00034\u0003i\u0019'/Z1uK\u000e{gNZ5h/&$\b\u000eT8x)&lWm\\;u)\u0005!\u0004CA\u001b9\u001b\u00051$BA\u001c\u0007\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&\u0011\u0011H\u000e\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000bm\u0002A\u0011\u0002\u001f\u0002/5,8\u000f\u001e*fiV\u0014hnV5uQ&tG+[7f_V$HCA\u001fD)\t!c\bC\u0003@u\u0001\u0007\u0001)\u0001\u0003uCN\\\u0007cA\bBI%\u0011!\t\u0005\u0002\n\rVt7\r^5p]BBQA\u0007\u001eA\u0002\u0011\u0003\"!\u0012&\u000e\u0003\u0019S!a\u0012%\u0002\u0011\u0011,(/\u0019;j_:T!!\u0013\t\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002L\r\nAA)\u001e:bi&|g\u000e")
public class JobManagerConnectionTest {
    private final int timeout;

    private int timeout() {
        return this.timeout;
    }

    /*
     * Loose catch block
     */
    @Test
    public void testResolveUnreachableActorLocalHost() {
        block8: {
            block9: {
                ActorSystem actorSystem = AkkaUtils$.MODULE$.createActorSystem(new Configuration(), (Option)new Some((Object)new Tuple2((Object)"", (Object)BoxesRunTime.boxToInteger((int)0))));
                int freePort = NetUtils.getAvailablePort();
                String endpoint = NetUtils.unresolvedHostAndPortToNormalizedString((String)"127.0.0.1", (int)freePort);
                Configuration config = this.createConfigWithLowTimeout();
                this.mustReturnWithinTimeout((Duration)Duration$.MODULE$.apply((long)(5 * this.timeout()), TimeUnit.MILLISECONDS), (Function0<BoxedUnit>)new Serializable(this, actorSystem, endpoint, config){
                    public static final long serialVersionUID = 0L;
                    private final ActorSystem actorSystem$1;
                    private final String endpoint$1;
                    private final Configuration config$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        try {
                            AkkaUtils$.MODULE$.getActorRef(this.endpoint$1, this.actorSystem$1, AkkaUtils$.MODULE$.getLookupTimeout(this.config$1));
                            Assert.fail((String)"Should fail since the JobManager is not reachable");
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    {
                        this.actorSystem$1 = actorSystem$1;
                        this.endpoint$1 = endpoint$1;
                        this.config$1 = config$1;
                    }
                });
                actorSystem.shutdown();
                break block9;
                {
                    catch (Throwable throwable) {
                        try {
                            try {
                                break block8;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                Assert.fail((String)exception.getMessage());
                            }
                        }
                        catch (Throwable throwable2) {
                            throw throwable2;
                        }
                        finally {
                            actorSystem.shutdown();
                        }
                    }
                }
            }
            return;
        }
    }

    @Test
    public void testResolveUnreachableActorRemoteHost() {
        ActorSystem actorSystem = AkkaUtils$.MODULE$.createActorSystem(new Configuration(), (Option)new Some((Object)new Tuple2((Object)"", (Object)BoxesRunTime.boxToInteger((int)0))));
        try {
            String endpoint = NetUtils.unresolvedHostAndPortToNormalizedString((String)"10.254.254.254", (int)2);
            Configuration config = this.createConfigWithLowTimeout();
            this.mustReturnWithinTimeout((Duration)Duration$.MODULE$.apply((long)(5 * this.timeout()), TimeUnit.MILLISECONDS), (Function0<BoxedUnit>)new Serializable(this, actorSystem, endpoint, config){
                public static final long serialVersionUID = 0L;
                private final ActorSystem actorSystem$2;
                private final String endpoint$2;
                private final Configuration config$2;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    try {
                        AkkaUtils$.MODULE$.getActorRef(this.endpoint$2, this.actorSystem$2, AkkaUtils$.MODULE$.getLookupTimeout(this.config$2));
                        Assert.fail((String)"Should fail since the JobManager is not reachable");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                {
                    this.actorSystem$2 = actorSystem$2;
                    this.endpoint$2 = endpoint$2;
                    this.config$2 = config$2;
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)exception.getMessage());
        }
        finally {
            actorSystem.shutdown();
        }
    }

    /*
     * WARNING - void declaration
     */
    private Configuration createConfigWithLowTimeout() {
        void var1_1;
        Configuration config = new Configuration();
        config.setString("akka.lookup.timeout", new StringBuilder().append(Duration$.MODULE$.apply((long)this.timeout(), TimeUnit.MILLISECONDS).toSeconds()).append((Object)" s").toString());
        return var1_1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void mustReturnWithinTimeout(Duration timeout, Function0<BoxedUnit> task) {
        Thread runner;
        AtomicBoolean done;
        block5: {
            done = new AtomicBoolean();
            AtomicReference error = new AtomicReference();
            Runnable runnable = new Runnable(this, task, done, error){
                private final Function0 task$1;
                private final AtomicBoolean done$1;
                private final AtomicReference error$1;

                public void run() {
                    try {
                        this.task$1.apply$mcV$sp();
                        this.done$1.set(true);
                    }
                    catch (Throwable throwable) {
                        this.error$1.set(throwable);
                    }
                    AtomicBoolean atomicBoolean = this.done$1;
                    synchronized (atomicBoolean) {
                        this.done$1.notifyAll();
                        return;
                    }
                }
                {
                    this.task$1 = task$1;
                    this.done$1 = done$1;
                    this.error$1 = error$1;
                }
            };
            runner = new Thread(runnable, "Test runner");
            runner.setDaemon(true);
            long now = System.currentTimeMillis();
            long deadline = now + timeout.toMillis();
            runner.start();
            AtomicBoolean atomicBoolean = done;
            synchronized (atomicBoolean) {
                while (error.get() == null && !done.get() && now < deadline) {
                    done.wait(deadline - now);
                    now = System.currentTimeMillis();
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl16 : MonitorExitStatement: MONITOREXIT : atomicBoolean
                if (error.get() == null) break block5;
                ((Throwable)error.get()).printStackTrace();
            }
            Assert.fail((String)new StringBuilder().append((Object)"Exception in the timed call: ").append((Object)((Throwable)error.get()).getMessage()).toString());
        }
        if (!done.get()) {
            runner.interrupt();
            Assert.fail((String)new StringBuilder().append((Object)"Call did not finish within ").append((Object)timeout).toString());
        }
    }

    public JobManagerConnectionTest() {
        this.timeout = 1000;
    }
}

