/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.DummyActorGateway;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.slots.ActorTaskManagerGateway;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.mockito.Mockito;

public class SchedulerTestUtils {
    private static final AtomicInteger port = new AtomicInteger(10000);

    public static Instance getRandomInstance(int numSlots) {
        InetAddress address;
        if (numSlots <= 0) {
            throw new IllegalArgumentException();
        }
        ResourceID resourceID = ResourceID.generate();
        try {
            address = InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Test could not create IP address for localhost loopback.");
        }
        int dataPort = port.getAndIncrement();
        TaskManagerLocation ci = new TaskManagerLocation(resourceID, address, dataPort);
        long GB = 0x40000000L;
        HardwareDescription resources = new HardwareDescription(4, 0x100000000L, 0xC0000000L, 0x80000000L);
        return new Instance((TaskManagerGateway)new ActorTaskManagerGateway((ActorGateway)DummyActorGateway.INSTANCE), ci, new InstanceID(), resources, numSlots);
    }

    public static Execution getDummyTask() {
        ExecutionVertex vertex = (ExecutionVertex)Mockito.mock(ExecutionVertex.class);
        Mockito.when((Object)vertex.getJobId()).thenReturn((Object)new JobID());
        Mockito.when((Object)vertex.toString()).thenReturn((Object)"TEST-VERTEX");
        Execution execution = (Execution)Mockito.mock(Execution.class);
        Mockito.when((Object)execution.getVertex()).thenReturn((Object)vertex);
        return execution;
    }

    public static Execution getTestVertex(Instance ... preferredInstances) {
        ArrayList<TaskManagerLocation> locations = new ArrayList<TaskManagerLocation>(preferredInstances.length);
        for (Instance i : preferredInstances) {
            locations.add(i.getTaskManagerLocation());
        }
        return SchedulerTestUtils.getTestVertex(locations);
    }

    public static Execution getTestVertex(TaskManagerLocation ... preferredLocations) {
        return SchedulerTestUtils.getTestVertex(Arrays.asList(preferredLocations));
    }

    public static Execution getTestVertex(Iterable<TaskManagerLocation> preferredLocations) {
        ExecutionVertex vertex = (ExecutionVertex)Mockito.mock(ExecutionVertex.class);
        Mockito.when((Object)vertex.getPreferredLocationsBasedOnInputs()).thenReturn(preferredLocations);
        Mockito.when((Object)vertex.getJobId()).thenReturn((Object)new JobID());
        Mockito.when((Object)vertex.toString()).thenReturn((Object)"TEST-VERTEX");
        Execution execution = (Execution)Mockito.mock(Execution.class);
        Mockito.when((Object)execution.getVertex()).thenReturn((Object)vertex);
        return execution;
    }

    public static Execution getTestVertex(JobVertexID jid, int taskIndex, int numTasks) {
        ExecutionVertex vertex = (ExecutionVertex)Mockito.mock(ExecutionVertex.class);
        Mockito.when((Object)vertex.getPreferredLocationsBasedOnInputs()).thenReturn(null);
        Mockito.when((Object)vertex.getJobId()).thenReturn((Object)new JobID());
        Mockito.when((Object)vertex.getJobvertexId()).thenReturn((Object)jid);
        Mockito.when((Object)vertex.getParallelSubtaskIndex()).thenReturn((Object)taskIndex);
        Mockito.when((Object)vertex.getTotalNumberOfParallelSubtasks()).thenReturn((Object)numTasks);
        Mockito.when((Object)vertex.getMaxParallelism()).thenReturn((Object)numTasks);
        Mockito.when((Object)vertex.toString()).thenReturn((Object)"TEST-VERTEX");
        Mockito.when((Object)vertex.getTaskNameWithSubtaskIndex()).thenReturn((Object)"TEST-VERTEX");
        Execution execution = (Execution)Mockito.mock(Execution.class);
        Mockito.when((Object)execution.getVertex()).thenReturn((Object)vertex);
        return execution;
    }

    public static Execution getTestVertexWithLocation(JobVertexID jid, int taskIndex, int numTasks, TaskManagerLocation ... locations) {
        ExecutionVertex vertex = (ExecutionVertex)Mockito.mock(ExecutionVertex.class);
        Mockito.when((Object)vertex.getPreferredLocationsBasedOnInputs()).thenReturn(Arrays.asList(locations));
        Mockito.when((Object)vertex.getJobId()).thenReturn((Object)new JobID());
        Mockito.when((Object)vertex.getJobvertexId()).thenReturn((Object)jid);
        Mockito.when((Object)vertex.getParallelSubtaskIndex()).thenReturn((Object)taskIndex);
        Mockito.when((Object)vertex.getTotalNumberOfParallelSubtasks()).thenReturn((Object)numTasks);
        Mockito.when((Object)vertex.getMaxParallelism()).thenReturn((Object)numTasks);
        Mockito.when((Object)vertex.toString()).thenReturn((Object)"TEST-VERTEX");
        Execution execution = (Execution)Mockito.mock(Execution.class);
        Mockito.when((Object)execution.getVertex()).thenReturn((Object)vertex);
        return execution;
    }

    public static boolean areAllDistinct(Object ... obj) {
        if (obj == null) {
            return true;
        }
        HashSet set = new HashSet();
        Collections.addAll(set, obj);
        return set.size() == obj.length;
    }
}

