/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.UUID;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.RunningJobsRegistry;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobmanager.OnCompletionActions;
import org.apache.flink.runtime.jobmanager.SubmittedJobGraphStore;
import org.apache.flink.runtime.jobmaster.JobManagerRunner;
import org.apache.flink.runtime.jobmaster.JobManagerServices;
import org.apache.flink.runtime.jobmaster.JobMaster;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryConfiguration;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={JobManagerRunner.class})
public class JobManagerRunnerMockTest
extends TestLogger {
    private JobManagerRunner runner;
    private JobMaster jobManager;
    private JobMasterGateway jobManagerGateway;
    private LeaderElectionService leaderElectionService;
    private SubmittedJobGraphStore submittedJobGraphStore;
    private TestingOnCompletionActions jobCompletion;
    private BlobStore blobStore;
    private RunningJobsRegistry runningJobsRegistry;

    @Before
    public void setUp() throws Exception {
        RpcService mockRpc = (RpcService)Mockito.mock(RpcService.class);
        Mockito.when((Object)mockRpc.getAddress()).thenReturn((Object)"localhost");
        this.jobManager = (JobMaster)Mockito.mock(JobMaster.class);
        this.jobManagerGateway = (JobMasterGateway)Mockito.mock(JobMasterGateway.class);
        Mockito.when((Object)this.jobManager.getSelf()).thenReturn((Object)this.jobManagerGateway);
        Mockito.when((Object)this.jobManager.getRpcService()).thenReturn((Object)mockRpc);
        PowerMockito.whenNew(JobMaster.class).withAnyArguments().thenReturn((Object)this.jobManager);
        this.jobCompletion = new TestingOnCompletionActions();
        this.leaderElectionService = (LeaderElectionService)Mockito.mock(LeaderElectionService.class);
        Mockito.when((Object)this.leaderElectionService.hasLeadership()).thenReturn((Object)true);
        SubmittedJobGraphStore submittedJobGraphStore = (SubmittedJobGraphStore)Mockito.mock(SubmittedJobGraphStore.class);
        this.blobStore = (BlobStore)Mockito.mock(BlobStore.class);
        HighAvailabilityServices haServices = (HighAvailabilityServices)Mockito.mock(HighAvailabilityServices.class);
        Mockito.when((Object)haServices.getJobManagerLeaderElectionService((JobID)Matchers.any(JobID.class))).thenReturn((Object)this.leaderElectionService);
        Mockito.when((Object)haServices.getSubmittedJobGraphStore()).thenReturn((Object)submittedJobGraphStore);
        Mockito.when((Object)haServices.createBlobStore()).thenReturn((Object)this.blobStore);
        Mockito.when((Object)haServices.getRunningJobsRegistry()).thenReturn((Object)this.runningJobsRegistry);
        HeartbeatServices heartbeatServices = (HeartbeatServices)Mockito.mock(HeartbeatServices.class);
        this.runner = (JobManagerRunner)PowerMockito.spy((Object)new JobManagerRunner(ResourceID.generate(), new JobGraph("test", new JobVertex[]{new JobVertex("vertex")}), (Configuration)Mockito.mock(Configuration.class), mockRpc, haServices, heartbeatServices, JobManagerServices.fromConfiguration((Configuration)new Configuration(), (HighAvailabilityServices)haServices), new MetricRegistry(MetricRegistryConfiguration.defaultMetricRegistryConfiguration()), (OnCompletionActions)this.jobCompletion, (FatalErrorHandler)this.jobCompletion));
    }

    @After
    public void tearDown() throws Exception {
    }

    @Ignore
    @Test
    public void testStartAndShutdown() throws Exception {
        this.runner.start();
        ((LeaderElectionService)Mockito.verify((Object)this.leaderElectionService)).start((LeaderContender)this.runner);
        Assert.assertTrue((!this.jobCompletion.isJobFinished() ? 1 : 0) != 0);
        Assert.assertTrue((!this.jobCompletion.isJobFailed() ? 1 : 0) != 0);
        ((JobMaster)Mockito.verify((Object)this.jobManager)).start((UUID)Matchers.any(UUID.class));
        this.runner.shutdown();
        ((LeaderElectionService)Mockito.verify((Object)this.leaderElectionService)).stop();
        ((JobMaster)Mockito.verify((Object)this.jobManager)).shutDown();
    }

    @Ignore
    @Test
    public void testShutdownBeforeGrantLeadership() throws Exception {
        this.runner.start();
        ((JobMaster)Mockito.verify((Object)this.jobManager)).start();
        ((LeaderElectionService)Mockito.verify((Object)this.leaderElectionService)).start((LeaderContender)this.runner);
        this.runner.shutdown();
        ((LeaderElectionService)Mockito.verify((Object)this.leaderElectionService)).stop();
        ((JobMaster)Mockito.verify((Object)this.jobManager)).shutDown();
        Assert.assertTrue((!this.jobCompletion.isJobFinished() ? 1 : 0) != 0);
        Assert.assertTrue((!this.jobCompletion.isJobFailed() ? 1 : 0) != 0);
        this.runner.grantLeadership(UUID.randomUUID());
        Assert.assertTrue((!this.jobCompletion.isJobFinished() ? 1 : 0) != 0);
        Assert.assertTrue((!this.jobCompletion.isJobFailed() ? 1 : 0) != 0);
    }

    @Ignore
    @Test
    public void testJobFinished() throws Exception {
        this.runner.start();
        UUID leaderSessionID = UUID.randomUUID();
        this.runner.grantLeadership(leaderSessionID);
        ((JobMaster)Mockito.verify((Object)this.jobManager)).start(leaderSessionID);
        Assert.assertTrue((!this.jobCompletion.isJobFinished() ? 1 : 0) != 0);
        this.runner.jobFinished((JobExecutionResult)Mockito.mock(JobExecutionResult.class));
        Assert.assertTrue((boolean)this.jobCompletion.isJobFinished());
        Assert.assertFalse((boolean)this.jobCompletion.isJobFinishedByOther());
        ((LeaderElectionService)Mockito.verify((Object)this.leaderElectionService)).stop();
        ((JobMaster)Mockito.verify((Object)this.jobManager)).shutDown();
        Assert.assertTrue((boolean)this.runner.isShutdown());
    }

    @Ignore
    @Test
    public void testJobFailed() throws Exception {
        this.runner.start();
        UUID leaderSessionID = UUID.randomUUID();
        this.runner.grantLeadership(leaderSessionID);
        ((JobMaster)Mockito.verify((Object)this.jobManager)).start(leaderSessionID);
        Assert.assertTrue((!this.jobCompletion.isJobFinished() ? 1 : 0) != 0);
        this.runner.jobFailed((Throwable)new Exception("failed manually"));
        Assert.assertTrue((boolean)this.jobCompletion.isJobFailed());
        ((LeaderElectionService)Mockito.verify((Object)this.leaderElectionService)).stop();
        ((JobMaster)Mockito.verify((Object)this.jobManager)).shutDown();
        Assert.assertTrue((boolean)this.runner.isShutdown());
    }

    @Ignore
    @Test
    public void testLeadershipRevoked() throws Exception {
        this.runner.start();
        UUID leaderSessionID = UUID.randomUUID();
        this.runner.grantLeadership(leaderSessionID);
        ((JobMaster)Mockito.verify((Object)this.jobManager)).start(leaderSessionID);
        Assert.assertTrue((!this.jobCompletion.isJobFinished() ? 1 : 0) != 0);
        this.runner.revokeLeadership();
        ((JobMaster)Mockito.verify((Object)this.jobManager)).suspendExecution((Throwable)Matchers.any(Throwable.class));
        Assert.assertFalse((boolean)this.runner.isShutdown());
    }

    @Ignore
    @Test
    public void testRegainLeadership() throws Exception {
        this.runner.start();
        UUID leaderSessionID = UUID.randomUUID();
        this.runner.grantLeadership(leaderSessionID);
        ((JobMaster)Mockito.verify((Object)this.jobManager)).start(leaderSessionID);
        Assert.assertTrue((!this.jobCompletion.isJobFinished() ? 1 : 0) != 0);
        this.runner.revokeLeadership();
        ((JobMaster)Mockito.verify((Object)this.jobManager)).suspendExecution((Throwable)Matchers.any(Throwable.class));
        Assert.assertFalse((boolean)this.runner.isShutdown());
        UUID leaderSessionID2 = UUID.randomUUID();
        this.runner.grantLeadership(leaderSessionID2);
        ((JobMaster)Mockito.verify((Object)this.jobManager)).start(leaderSessionID2);
    }

    private static class TestingOnCompletionActions
    implements OnCompletionActions,
    FatalErrorHandler {
        private volatile JobExecutionResult result;
        private volatile Throwable failedCause;
        private volatile boolean finishedByOther;

        private TestingOnCompletionActions() {
        }

        public void jobFinished(JobExecutionResult result) {
            Preconditions.checkArgument((!this.isJobFinished() ? 1 : 0) != 0, (Object)"job finished already");
            Preconditions.checkArgument((!this.isJobFailed() ? 1 : 0) != 0, (Object)"job failed already");
            this.result = result;
        }

        public void jobFailed(Throwable cause) {
            Preconditions.checkArgument((!this.isJobFinished() ? 1 : 0) != 0, (Object)"job finished already");
            Preconditions.checkArgument((!this.isJobFailed() ? 1 : 0) != 0, (Object)"job failed already");
            this.failedCause = cause;
        }

        public void jobFinishedByOther() {
            Preconditions.checkArgument((!this.isJobFinished() ? 1 : 0) != 0, (Object)"job finished already");
            Preconditions.checkArgument((!this.isJobFailed() ? 1 : 0) != 0, (Object)"job failed already");
            this.finishedByOther = true;
        }

        public void onFatalError(Throwable exception) {
            this.jobFailed(exception);
        }

        boolean isJobFinished() {
            return this.result != null || this.finishedByOther;
        }

        boolean isJobFinishedByOther() {
            return this.finishedByOther;
        }

        boolean isJobFailed() {
            return this.failedCause != null;
        }
    }
}

