/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.net.InetAddress;
import java.net.URL;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.concurrent.impl.FlinkCompletableFuture;
import org.apache.flink.runtime.execution.librarycache.BlobLibraryCacheManager;
import org.apache.flink.runtime.execution.librarycache.FlinkUserCodeClassLoader;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategyFactory;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.heartbeat.TestingHeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.TestingHighAvailabilityServices;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobmanager.OnCompletionActions;
import org.apache.flink.runtime.jobmaster.JobMaster;
import org.apache.flink.runtime.jobmaster.JobMasterRegistrationSuccess;
import org.apache.flink.runtime.leaderelection.TestingLeaderRetrievalService;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.TestingSerialRpcService;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.util.TestingFatalErrorHandler;
import org.apache.flink.util.TestLogger;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={BlobLibraryCacheManager.class})
public class JobMasterTest
extends TestLogger {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeartbeatTimeoutWithTaskManager() throws Exception {
        TestingHighAvailabilityServices haServices = new TestingHighAvailabilityServices();
        TestingLeaderRetrievalService rmLeaderRetrievalService = new TestingLeaderRetrievalService(null, null);
        haServices.setResourceManagerLeaderRetriever(rmLeaderRetrievalService);
        haServices.setCheckpointRecoveryFactory((CheckpointRecoveryFactory)Mockito.mock(CheckpointRecoveryFactory.class));
        TestingFatalErrorHandler testingFatalErrorHandler = new TestingFatalErrorHandler();
        String jobManagerAddress = "jm";
        UUID jmLeaderId = UUID.randomUUID();
        ResourceID jmResourceId = new ResourceID("jm");
        String taskManagerAddress = "tm";
        ResourceID tmResourceId = new ResourceID("tm");
        TaskManagerLocation taskManagerLocation = new TaskManagerLocation(tmResourceId, InetAddress.getLoopbackAddress(), 1234);
        TaskExecutorGateway taskExecutorGateway = (TaskExecutorGateway)Mockito.mock(TaskExecutorGateway.class);
        TestingSerialRpcService rpc = new TestingSerialRpcService();
        rpc.registerGateway("tm", (RpcGateway)taskExecutorGateway);
        long heartbeatInterval = 1L;
        long heartbeatTimeout = 5L;
        ScheduledExecutor scheduledExecutor = (ScheduledExecutor)Mockito.mock(ScheduledExecutor.class);
        TestingHeartbeatServices heartbeatServices = new TestingHeartbeatServices(1L, 5L, scheduledExecutor);
        JobGraph jobGraph = new JobGraph(new JobVertex[0]);
        try {
            JobMaster jobMaster = new JobMaster((RpcService)rpc, jmResourceId, jobGraph, new Configuration(), (HighAvailabilityServices)haServices, (HeartbeatServices)heartbeatServices, Executors.newScheduledThreadPool(1), (BlobLibraryCacheManager)Mockito.mock(BlobLibraryCacheManager.class), (RestartStrategyFactory)Mockito.mock(RestartStrategyFactory.class), Time.of((long)10L, (TimeUnit)TimeUnit.SECONDS), null, (OnCompletionActions)Mockito.mock(OnCompletionActions.class), (FatalErrorHandler)testingFatalErrorHandler, (ClassLoader)new FlinkUserCodeClassLoader(new URL[0]));
            jobMaster.start(jmLeaderId);
            jobMaster.registerTaskManager("tm", taskManagerLocation, jmLeaderId);
            ArgumentCaptor heartbeatRunnableCaptor = ArgumentCaptor.forClass(Runnable.class);
            ((ScheduledExecutor)Mockito.verify((Object)scheduledExecutor, (VerificationMode)Mockito.times((int)1))).scheduleAtFixedRate((Runnable)heartbeatRunnableCaptor.capture(), Matchers.eq((long)0L), Matchers.eq((long)1L), (TimeUnit)((Object)Matchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
            Runnable heartbeatRunnable = (Runnable)heartbeatRunnableCaptor.getValue();
            ArgumentCaptor timeoutRunnableCaptor = ArgumentCaptor.forClass(Runnable.class);
            ((ScheduledExecutor)Mockito.verify((Object)scheduledExecutor)).schedule((Runnable)timeoutRunnableCaptor.capture(), Matchers.eq((long)5L), (TimeUnit)((Object)Matchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
            Runnable timeoutRunnable = (Runnable)timeoutRunnableCaptor.getValue();
            heartbeatRunnable.run();
            ((TaskExecutorGateway)Mockito.verify((Object)taskExecutorGateway, (VerificationMode)Mockito.times((int)1))).heartbeatFromJobManager((ResourceID)Matchers.eq((Object)jmResourceId));
            timeoutRunnable.run();
            ((TaskExecutorGateway)Mockito.verify((Object)taskExecutorGateway)).disconnectJobManager((JobID)Matchers.eq((Object)jobGraph.getJobID()), (Exception)Matchers.any(TimeoutException.class));
            testingFatalErrorHandler.rethrowError();
        }
        finally {
            rpc.stopService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeartbeatTimeoutWithResourceManager() throws Exception {
        String resourceManagerAddress = "rm";
        String jobManagerAddress = "jm";
        UUID rmLeaderId = UUID.randomUUID();
        UUID jmLeaderId = UUID.randomUUID();
        ResourceID rmResourceId = new ResourceID("rm");
        ResourceID jmResourceId = new ResourceID("jm");
        JobGraph jobGraph = new JobGraph(new JobVertex[0]);
        TestingHighAvailabilityServices haServices = new TestingHighAvailabilityServices();
        TestingLeaderRetrievalService rmLeaderRetrievalService = new TestingLeaderRetrievalService(null, null);
        haServices.setResourceManagerLeaderRetriever(rmLeaderRetrievalService);
        haServices.setCheckpointRecoveryFactory((CheckpointRecoveryFactory)Mockito.mock(CheckpointRecoveryFactory.class));
        long heartbeatInterval = 1L;
        long heartbeatTimeout = 5L;
        ScheduledExecutor scheduledExecutor = (ScheduledExecutor)Mockito.mock(ScheduledExecutor.class);
        TestingHeartbeatServices heartbeatServices = new TestingHeartbeatServices(1L, 5L, scheduledExecutor);
        ResourceManagerGateway resourceManagerGateway = (ResourceManagerGateway)Mockito.mock(ResourceManagerGateway.class);
        Mockito.when((Object)resourceManagerGateway.registerJobManager((UUID)Matchers.any(UUID.class), (UUID)Matchers.any(UUID.class), (ResourceID)Matchers.any(ResourceID.class), Mockito.anyString(), (JobID)Matchers.any(JobID.class), (Time)Matchers.any(Time.class))).thenReturn((Object)FlinkCompletableFuture.completed((Object)new JobMasterRegistrationSuccess(1L, rmLeaderId, rmResourceId)));
        TestingSerialRpcService rpc = new TestingSerialRpcService();
        rpc.registerGateway("rm", (RpcGateway)resourceManagerGateway);
        TestingFatalErrorHandler testingFatalErrorHandler = new TestingFatalErrorHandler();
        try {
            JobMaster jobMaster = new JobMaster((RpcService)rpc, jmResourceId, jobGraph, new Configuration(), (HighAvailabilityServices)haServices, (HeartbeatServices)heartbeatServices, Executors.newScheduledThreadPool(1), (BlobLibraryCacheManager)Mockito.mock(BlobLibraryCacheManager.class), (RestartStrategyFactory)Mockito.mock(RestartStrategyFactory.class), Time.of((long)10L, (TimeUnit)TimeUnit.SECONDS), null, (OnCompletionActions)Mockito.mock(OnCompletionActions.class), (FatalErrorHandler)testingFatalErrorHandler, (ClassLoader)new FlinkUserCodeClassLoader(new URL[0]));
            jobMaster.start(jmLeaderId);
            rmLeaderRetrievalService.notifyListener("rm", rmLeaderId);
            ((ResourceManagerGateway)Mockito.verify((Object)resourceManagerGateway)).registerJobManager((UUID)Matchers.eq((Object)rmLeaderId), (UUID)Matchers.eq((Object)jmLeaderId), (ResourceID)Matchers.eq((Object)jmResourceId), Mockito.anyString(), (JobID)Matchers.eq((Object)jobGraph.getJobID()), (Time)Matchers.any(Time.class));
            ((ResourceManagerGateway)Mockito.verify((Object)resourceManagerGateway, (VerificationMode)Mockito.timeout((long)250L))).disconnectJobManager((JobID)Matchers.eq((Object)jobGraph.getJobID()), (Exception)Matchers.any(TimeoutException.class));
            testingFatalErrorHandler.rethrowError();
        }
        finally {
            rpc.stopService();
        }
    }
}

