/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import akka.actor.ActorNotFound;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.reporter.Scheduled;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryConfiguration;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.scope.ScopeFormats;
import org.apache.flink.runtime.metrics.util.TestReporter;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class MetricRegistryTest
extends TestLogger {
    private static final char GLOBAL_DEFAULT_DELIMITER = '.';

    @Test
    public void testIsShutdown() {
        MetricRegistry metricRegistry = new MetricRegistry(MetricRegistryConfiguration.defaultMetricRegistryConfiguration());
        Assert.assertFalse((boolean)metricRegistry.isShutdown());
        metricRegistry.shutdown();
        Assert.assertTrue((boolean)metricRegistry.isShutdown());
    }

    @Test
    public void testReporterInstantiation() {
        Configuration config = new Configuration();
        config.setString(MetricOptions.REPORTERS_LIST, "test");
        config.setString("metrics.reporter.test.class", TestReporter1.class.getName());
        MetricRegistry metricRegistry = new MetricRegistry(MetricRegistryConfiguration.fromConfiguration((Configuration)config));
        Assert.assertTrue((metricRegistry.getReporters().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)TestReporter1.wasOpened);
        metricRegistry.shutdown();
    }

    @Test
    public void testMultipleReporterInstantiation() {
        Configuration config = new Configuration();
        config.setString(MetricOptions.REPORTERS_LIST, "test1, test2,test3");
        config.setString("metrics.reporter.test1.class", TestReporter11.class.getName());
        config.setString("metrics.reporter.test2.class", TestReporter12.class.getName());
        config.setString("metrics.reporter.test3.class", TestReporter13.class.getName());
        MetricRegistry metricRegistry = new MetricRegistry(MetricRegistryConfiguration.fromConfiguration((Configuration)config));
        Assert.assertTrue((metricRegistry.getReporters().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)TestReporter11.wasOpened);
        Assert.assertTrue((boolean)TestReporter12.wasOpened);
        Assert.assertTrue((boolean)TestReporter13.wasOpened);
        metricRegistry.shutdown();
    }

    @Test
    public void testReporterArgumentForwarding() {
        Configuration config = new Configuration();
        config.setString(MetricOptions.REPORTERS_LIST, "test");
        config.setString("metrics.reporter.test.class", TestReporter2.class.getName());
        config.setString("metrics.reporter.test.arg1", "hello");
        config.setString("metrics.reporter.test.arg2", "world");
        new MetricRegistry(MetricRegistryConfiguration.fromConfiguration((Configuration)config)).shutdown();
    }

    @Test
    public void testReporterScheduling() throws InterruptedException {
        Configuration config = new Configuration();
        config.setString(MetricOptions.REPORTERS_LIST, "test");
        config.setString("metrics.reporter.test.class", TestReporter3.class.getName());
        config.setString("metrics.reporter.test.arg1", "hello");
        config.setString("metrics.reporter.test.interval", "50 MILLISECONDS");
        MetricRegistry registry = new MetricRegistry(MetricRegistryConfiguration.fromConfiguration((Configuration)config));
        long start = System.currentTimeMillis();
        for (int x = 0; x < 10; ++x) {
            Thread.sleep(100L);
            int reportCount = TestReporter3.reportCount;
            long curT = System.currentTimeMillis();
            long maxAllowedReports = (curT - start) / 50L + 2L;
            Assert.assertTrue((String)"Too many report were triggered.", (maxAllowedReports >= (long)reportCount ? 1 : 0) != 0);
        }
        Assert.assertTrue((String)"No report was triggered.", (TestReporter3.reportCount > 0 ? 1 : 0) != 0);
        registry.shutdown();
    }

    @Test
    public void testReporterNotifications() {
        Configuration config = new Configuration();
        config.setString(MetricOptions.REPORTERS_LIST, "test1,test2");
        config.setString("metrics.reporter.test1.class", TestReporter6.class.getName());
        config.setString("metrics.reporter.test2.class", TestReporter7.class.getName());
        MetricRegistry registry = new MetricRegistry(MetricRegistryConfiguration.fromConfiguration((Configuration)config));
        TaskManagerMetricGroup root = new TaskManagerMetricGroup(registry, "host", "id");
        root.counter("rootCounter");
        root.close();
        Assert.assertTrue((boolean)TestReporter6.addCalled);
        Assert.assertTrue((boolean)TestReporter6.removeCalled);
        Assert.assertTrue((boolean)TestReporter7.addCalled);
        Assert.assertTrue((boolean)TestReporter7.removeCalled);
        registry.shutdown();
    }

    @Test
    public void testScopeConfig() {
        Configuration config = new Configuration();
        config.setString(MetricOptions.SCOPE_NAMING_TM, "A");
        config.setString(MetricOptions.SCOPE_NAMING_TM_JOB, "B");
        config.setString(MetricOptions.SCOPE_NAMING_TASK, "C");
        config.setString(MetricOptions.SCOPE_NAMING_OPERATOR, "D");
        ScopeFormats scopeConfig = MetricRegistryConfiguration.createScopeConfig((Configuration)config);
        Assert.assertEquals((Object)"A", (Object)scopeConfig.getTaskManagerFormat().format());
        Assert.assertEquals((Object)"B", (Object)scopeConfig.getTaskManagerJobFormat().format());
        Assert.assertEquals((Object)"C", (Object)scopeConfig.getTaskFormat().format());
        Assert.assertEquals((Object)"D", (Object)scopeConfig.getOperatorFormat().format());
    }

    @Test
    public void testConfigurableDelimiter() {
        Configuration config = new Configuration();
        config.setString(MetricOptions.SCOPE_DELIMITER, "_");
        config.setString(MetricOptions.SCOPE_NAMING_TM, "A.B.C.D.E");
        MetricRegistry registry = new MetricRegistry(MetricRegistryConfiguration.fromConfiguration((Configuration)config));
        TaskManagerMetricGroup tmGroup = new TaskManagerMetricGroup(registry, "host", "id");
        Assert.assertEquals((Object)"A_B_C_D_E_name", (Object)tmGroup.getMetricIdentifier("name"));
        registry.shutdown();
    }

    @Test
    public void testConfigurableDelimiterForReporters() {
        Configuration config = new Configuration();
        config.setString(MetricOptions.REPORTERS_LIST, "test1,test2,test3");
        config.setString("metrics.reporter.test1.scope.delimiter", "_");
        config.setString("metrics.reporter.test1.class", TestReporter.class.getName());
        config.setString("metrics.reporter.test2.scope.delimiter", "-");
        config.setString("metrics.reporter.test2.class", TestReporter.class.getName());
        config.setString("metrics.reporter.test3.scope.delimiter", "AA");
        config.setString("metrics.reporter.test3.class", TestReporter.class.getName());
        MetricRegistry registry = new MetricRegistry(MetricRegistryConfiguration.fromConfiguration((Configuration)config));
        Assert.assertEquals((long)46L, (long)registry.getDelimiter());
        Assert.assertEquals((long)95L, (long)registry.getDelimiter(0));
        Assert.assertEquals((long)45L, (long)registry.getDelimiter(1));
        Assert.assertEquals((long)46L, (long)registry.getDelimiter(2));
        Assert.assertEquals((long)46L, (long)registry.getDelimiter(3));
        Assert.assertEquals((long)46L, (long)registry.getDelimiter(-1));
        registry.shutdown();
    }

    @Test
    public void testConfigurableDelimiterForReportersInGroup() {
        Configuration config = new Configuration();
        config.setString(MetricOptions.REPORTERS_LIST, "test1,test2,test3,test4");
        config.setString("metrics.reporter.test1.scope.delimiter", "_");
        config.setString("metrics.reporter.test1.class", TestReporter8.class.getName());
        config.setString("metrics.reporter.test2.scope.delimiter", "-");
        config.setString("metrics.reporter.test2.class", TestReporter8.class.getName());
        config.setString("metrics.reporter.test3.scope.delimiter", "AA");
        config.setString("metrics.reporter.test3.class", TestReporter8.class.getName());
        config.setString("metrics.reporter.test4.class", TestReporter8.class.getName());
        config.setString(MetricOptions.SCOPE_NAMING_TM, "A.B");
        MetricRegistry registry = new MetricRegistry(MetricRegistryConfiguration.fromConfiguration((Configuration)config));
        List reporters = registry.getReporters();
        ((TestReporter8)((Object)reporters.get((int)0))).expectedDelimiter = (char)95;
        ((TestReporter8)((Object)reporters.get((int)1))).expectedDelimiter = (char)45;
        ((TestReporter8)((Object)reporters.get((int)2))).expectedDelimiter = (char)46;
        ((TestReporter8)((Object)reporters.get((int)3))).expectedDelimiter = (char)46;
        TaskManagerMetricGroup group = new TaskManagerMetricGroup(registry, "host", "id");
        group.counter("C");
        group.close();
        registry.shutdown();
        Assert.assertEquals((long)4L, (long)TestReporter8.numCorrectDelimitersForRegister);
        Assert.assertEquals((long)4L, (long)TestReporter8.numCorrectDelimitersForUnregister);
    }

    @Test
    public void testQueryActorShutdown() throws Exception {
        FiniteDuration timeout = new FiniteDuration(10L, TimeUnit.SECONDS);
        MetricRegistry registry = new MetricRegistry(MetricRegistryConfiguration.defaultMetricRegistryConfiguration());
        ActorSystem actorSystem = AkkaUtils.createDefaultActorSystem();
        registry.startQueryService(actorSystem, null);
        ActorRef queryServiceActor = registry.getQueryService();
        registry.shutdown();
        try {
            Await.result((Awaitable)actorSystem.actorSelection(queryServiceActor.path()).resolveOne(timeout), (Duration)timeout);
            Assert.fail((String)"The query actor should be terminated resulting in a ActorNotFound exception.");
        }
        catch (ActorNotFound actorNotFound) {
            // empty catch block
        }
    }

    public static class TestReporter8
    extends TestReporter {
        char expectedDelimiter;
        public static int numCorrectDelimitersForRegister = 0;
        public static int numCorrectDelimitersForUnregister = 0;

        @Override
        public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
            String expectedMetric = "A" + this.expectedDelimiter + "B" + this.expectedDelimiter + "C";
            Assert.assertEquals((Object)expectedMetric, (Object)group.getMetricIdentifier(metricName, (CharacterFilter)this));
            Assert.assertEquals((Object)expectedMetric, (Object)group.getMetricIdentifier(metricName));
            ++numCorrectDelimitersForRegister;
        }

        @Override
        public void notifyOfRemovedMetric(Metric metric, String metricName, MetricGroup group) {
            String expectedMetric = "A" + this.expectedDelimiter + "B" + this.expectedDelimiter + "C";
            Assert.assertEquals((Object)expectedMetric, (Object)group.getMetricIdentifier(metricName, (CharacterFilter)this));
            Assert.assertEquals((Object)expectedMetric, (Object)group.getMetricIdentifier(metricName));
            ++numCorrectDelimitersForUnregister;
        }
    }

    protected static class TestReporter7
    extends TestReporter {
        public static boolean addCalled = false;
        public static boolean removeCalled = false;

        protected TestReporter7() {
        }

        @Override
        public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
            addCalled = true;
            Assert.assertTrue((boolean)(metric instanceof Counter));
            Assert.assertEquals((Object)"rootCounter", (Object)metricName);
        }

        @Override
        public void notifyOfRemovedMetric(Metric metric, String metricName, MetricGroup group) {
            removeCalled = true;
            Assert.assertTrue((boolean)(metric instanceof Counter));
            Assert.assertEquals((Object)"rootCounter", (Object)metricName);
        }
    }

    protected static class TestReporter6
    extends TestReporter {
        public static boolean addCalled = false;
        public static boolean removeCalled = false;

        protected TestReporter6() {
        }

        @Override
        public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
            addCalled = true;
            Assert.assertTrue((boolean)(metric instanceof Counter));
            Assert.assertEquals((Object)"rootCounter", (Object)metricName);
        }

        @Override
        public void notifyOfRemovedMetric(Metric metric, String metricName, MetricGroup group) {
            removeCalled = true;
            Assert.assertTrue((boolean)(metric instanceof Counter));
            Assert.assertEquals((Object)"rootCounter", (Object)metricName);
        }
    }

    protected static class TestReporter3
    extends TestReporter
    implements Scheduled {
        public static int reportCount = 0;

        protected TestReporter3() {
        }

        public void report() {
            ++reportCount;
        }
    }

    protected static class TestReporter2
    extends TestReporter {
        protected TestReporter2() {
        }

        @Override
        public void open(MetricConfig config) {
            Assert.assertEquals((Object)"hello", (Object)config.getString("arg1", null));
            Assert.assertEquals((Object)"world", (Object)config.getString("arg2", null));
        }
    }

    protected static class TestReporter13
    extends TestReporter {
        public static boolean wasOpened = false;

        protected TestReporter13() {
        }

        @Override
        public void open(MetricConfig config) {
            wasOpened = true;
        }
    }

    protected static class TestReporter12
    extends TestReporter {
        public static boolean wasOpened = false;

        protected TestReporter12() {
        }

        @Override
        public void open(MetricConfig config) {
            wasOpened = true;
        }
    }

    protected static class TestReporter11
    extends TestReporter {
        public static boolean wasOpened = false;

        protected TestReporter11() {
        }

        @Override
        public void open(MetricConfig config) {
            wasOpened = true;
        }
    }

    protected static class TestReporter1
    extends TestReporter {
        public static boolean wasOpened = false;

        protected TestReporter1() {
        }

        @Override
        public void open(MetricConfig config) {
            wasOpened = true;
        }
    }
}

