/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.dump;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.metrics.dump.MetricDump;
import org.apache.flink.runtime.metrics.dump.MetricDumpSerialization;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.util.TestingHistogram;
import org.junit.Assert;
import org.junit.Test;

public class MetricDumpSerializerTest {
    @Test
    public void testNullGaugeHandling() throws IOException {
        MetricDumpSerialization.MetricDumpSerializer serializer = new MetricDumpSerialization.MetricDumpSerializer();
        MetricDumpSerialization.MetricDumpDeserializer deserializer = new MetricDumpSerialization.MetricDumpDeserializer();
        HashMap<1, Tuple2> gauges = new HashMap<1, Tuple2>();
        gauges.put(new Gauge<Object>(){

            public Object getValue() {
                return null;
            }
        }, new Tuple2((Object)new QueryScopeInfo.JobManagerQueryScopeInfo("A"), (Object)"g"));
        MetricDumpSerialization.MetricSerializationResult output = serializer.serialize(Collections.emptyMap(), gauges, Collections.emptyMap(), Collections.emptyMap());
        Assert.assertEquals((long)0L, (long)output.serializedMetrics.length);
        List deserialized = deserializer.deserialize(output);
        Assert.assertEquals((long)0L, (long)deserialized.size());
    }

    @Test
    public void testJavaSerialization() throws IOException {
        MetricDumpSerialization.MetricDumpSerializer serializer = new MetricDumpSerialization.MetricDumpSerializer();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(serializer.serialize(new HashMap(), new HashMap(), new HashMap(), new HashMap()));
    }

    @Test
    public void testSerialization() throws IOException {
        MetricDumpSerialization.MetricDumpSerializer serializer = new MetricDumpSerialization.MetricDumpSerializer();
        MetricDumpSerialization.MetricDumpDeserializer deserializer = new MetricDumpSerialization.MetricDumpDeserializer();
        HashMap<SimpleCounter, Tuple2> counters = new HashMap<SimpleCounter, Tuple2>();
        HashMap<2, Tuple2> gauges = new HashMap<2, Tuple2>();
        HashMap<TestingHistogram, Tuple2> histograms = new HashMap<TestingHistogram, Tuple2>();
        HashMap<3, Tuple2> meters = new HashMap<3, Tuple2>();
        SimpleCounter c1 = new SimpleCounter();
        SimpleCounter c2 = new SimpleCounter();
        c1.inc(1L);
        c2.inc(2L);
        Gauge<Integer> g1 = new Gauge<Integer>(){

            public Integer getValue() {
                return 4;
            }
        };
        TestingHistogram h1 = new TestingHistogram();
        Meter m1 = new Meter(){

            public void markEvent() {
            }

            public void markEvent(long n) {
            }

            public double getRate() {
                return 5.0;
            }

            public long getCount() {
                return 10L;
            }
        };
        counters.put(c1, new Tuple2((Object)new QueryScopeInfo.JobManagerQueryScopeInfo("A"), (Object)"c1"));
        counters.put(c2, new Tuple2((Object)new QueryScopeInfo.TaskManagerQueryScopeInfo("tmid", "B"), (Object)"c2"));
        meters.put(m1, new Tuple2((Object)new QueryScopeInfo.JobQueryScopeInfo("jid", "C"), (Object)"c3"));
        gauges.put(g1, new Tuple2((Object)new QueryScopeInfo.TaskQueryScopeInfo("jid", "vid", 2, "D"), (Object)"g1"));
        histograms.put(h1, new Tuple2((Object)new QueryScopeInfo.OperatorQueryScopeInfo("jid", "vid", 2, "opname", "E"), (Object)"h1"));
        MetricDumpSerialization.MetricSerializationResult serialized = serializer.serialize(counters, gauges, histograms, meters);
        List deserialized = deserializer.deserialize(serialized);
        Assert.assertEquals((long)5L, (long)deserialized.size());
        block10: for (MetricDump metric : deserialized) {
            switch (metric.getCategory()) {
                case 0: {
                    MetricDump.CounterDump counterDump = (MetricDump.CounterDump)metric;
                    switch ((byte)counterDump.count) {
                        case 1: {
                            Assert.assertTrue((boolean)(counterDump.scopeInfo instanceof QueryScopeInfo.JobManagerQueryScopeInfo));
                            Assert.assertEquals((Object)"A", (Object)counterDump.scopeInfo.scope);
                            Assert.assertEquals((Object)"c1", (Object)counterDump.name);
                            counters.remove(c1);
                            continue block10;
                        }
                        case 2: {
                            Assert.assertTrue((boolean)(counterDump.scopeInfo instanceof QueryScopeInfo.TaskManagerQueryScopeInfo));
                            Assert.assertEquals((Object)"B", (Object)counterDump.scopeInfo.scope);
                            Assert.assertEquals((Object)"c2", (Object)counterDump.name);
                            Assert.assertEquals((Object)"tmid", (Object)((QueryScopeInfo.TaskManagerQueryScopeInfo)counterDump.scopeInfo).taskManagerID);
                            counters.remove(c2);
                            continue block10;
                        }
                    }
                    Assert.fail();
                    continue block10;
                }
                case 1: {
                    MetricDump.GaugeDump gaugeDump = (MetricDump.GaugeDump)metric;
                    Assert.assertEquals((Object)"4", (Object)gaugeDump.value);
                    Assert.assertEquals((Object)"g1", (Object)gaugeDump.name);
                    Assert.assertTrue((boolean)(gaugeDump.scopeInfo instanceof QueryScopeInfo.TaskQueryScopeInfo));
                    QueryScopeInfo.TaskQueryScopeInfo taskInfo = (QueryScopeInfo.TaskQueryScopeInfo)gaugeDump.scopeInfo;
                    Assert.assertEquals((Object)"D", (Object)taskInfo.scope);
                    Assert.assertEquals((Object)"jid", (Object)taskInfo.jobID);
                    Assert.assertEquals((Object)"vid", (Object)taskInfo.vertexID);
                    Assert.assertEquals((long)2L, (long)taskInfo.subtaskIndex);
                    gauges.remove(g1);
                    continue block10;
                }
                case 2: {
                    MetricDump.HistogramDump histogramDump = (MetricDump.HistogramDump)metric;
                    Assert.assertEquals((Object)"h1", (Object)histogramDump.name);
                    Assert.assertEquals((double)0.5, (double)histogramDump.median, (double)0.1);
                    Assert.assertEquals((double)0.75, (double)histogramDump.p75, (double)0.1);
                    Assert.assertEquals((double)0.9, (double)histogramDump.p90, (double)0.1);
                    Assert.assertEquals((double)0.95, (double)histogramDump.p95, (double)0.1);
                    Assert.assertEquals((double)0.98, (double)histogramDump.p98, (double)0.1);
                    Assert.assertEquals((double)0.99, (double)histogramDump.p99, (double)0.1);
                    Assert.assertEquals((double)0.999, (double)histogramDump.p999, (double)0.1);
                    Assert.assertEquals((double)4.0, (double)histogramDump.mean, (double)0.1);
                    Assert.assertEquals((double)5.0, (double)histogramDump.stddev, (double)0.1);
                    Assert.assertEquals((long)6L, (long)histogramDump.max);
                    Assert.assertEquals((long)7L, (long)histogramDump.min);
                    Assert.assertTrue((boolean)(histogramDump.scopeInfo instanceof QueryScopeInfo.OperatorQueryScopeInfo));
                    QueryScopeInfo.OperatorQueryScopeInfo opInfo = (QueryScopeInfo.OperatorQueryScopeInfo)histogramDump.scopeInfo;
                    Assert.assertEquals((Object)"E", (Object)opInfo.scope);
                    Assert.assertEquals((Object)"jid", (Object)opInfo.jobID);
                    Assert.assertEquals((Object)"vid", (Object)opInfo.vertexID);
                    Assert.assertEquals((long)2L, (long)opInfo.subtaskIndex);
                    Assert.assertEquals((Object)"opname", (Object)opInfo.operatorName);
                    histograms.remove(h1);
                    continue block10;
                }
                case 3: {
                    MetricDump.MeterDump meterDump = (MetricDump.MeterDump)metric;
                    Assert.assertEquals((double)5.0, (double)meterDump.rate, (double)0.1);
                    Assert.assertTrue((boolean)(meterDump.scopeInfo instanceof QueryScopeInfo.JobQueryScopeInfo));
                    Assert.assertEquals((Object)"C", (Object)meterDump.scopeInfo.scope);
                    Assert.assertEquals((Object)"c3", (Object)meterDump.name);
                    Assert.assertEquals((Object)"jid", (Object)((QueryScopeInfo.JobQueryScopeInfo)meterDump.scopeInfo).jobID);
                    continue block10;
                }
            }
            Assert.fail();
        }
        Assert.assertTrue((boolean)counters.isEmpty());
        Assert.assertTrue((boolean)gauges.isEmpty());
        Assert.assertTrue((boolean)histograms.isEmpty());
    }
}

