/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.reporter.MetricReporter;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryConfiguration;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.util.TestReporter;
import org.junit.Assert;
import org.junit.Test;

public class AbstractMetricGroupTest {
    private static final CharacterFilter FILTER_C = new CharacterFilter(){

        public String filterCharacters(String input) {
            return input.replace("C", "X");
        }
    };
    private static final CharacterFilter FILTER_B = new CharacterFilter(){

        public String filterCharacters(String input) {
            return input.replace("B", "X");
        }
    };

    @Test
    public void testGetAllVariables() {
        MetricRegistry registry = new MetricRegistry(MetricRegistryConfiguration.defaultMetricRegistryConfiguration());
        AbstractMetricGroup group = new AbstractMetricGroup<AbstractMetricGroup<?>>(registry, new String[0], null){

            protected QueryScopeInfo createQueryServiceMetricInfo(CharacterFilter filter) {
                return null;
            }

            protected String getGroupName(CharacterFilter filter) {
                return "";
            }
        };
        Assert.assertTrue((boolean)group.getAllVariables().isEmpty());
        registry.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScopeCachingForMultipleReporters() throws Exception {
        Configuration config = new Configuration();
        config.setString(MetricOptions.SCOPE_NAMING_TM, "A.B.C.D");
        config.setString(MetricOptions.REPORTERS_LIST, "test1,test2");
        config.setString("metrics.reporter.test1.class", TestReporter1.class.getName());
        config.setString("metrics.reporter.test1.scope.delimiter", "-");
        config.setString("metrics.reporter.test2.class", TestReporter2.class.getName());
        config.setString("metrics.reporter.test2.scope.delimiter", "!");
        MetricRegistry testRegistry = new MetricRegistry(MetricRegistryConfiguration.fromConfiguration((Configuration)config));
        try {
            TaskManagerMetricGroup tmGroup = new TaskManagerMetricGroup(testRegistry, "host", "id");
            tmGroup.counter("1");
            Assert.assertEquals((String)"Reporters were not properly instantiated", (long)2L, (long)testRegistry.getReporters().size());
            for (MetricReporter reporter : testRegistry.getReporters()) {
                ScopeCheckingTestReporter typedReporter = (ScopeCheckingTestReporter)reporter;
                if (typedReporter.failureCause == null) continue;
                throw typedReporter.failureCause;
            }
        }
        finally {
            testRegistry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScopeGenerationWithoutReporters() {
        Configuration config = new Configuration();
        config.setString(MetricOptions.SCOPE_NAMING_TM, "A.B.C.D");
        MetricRegistry testRegistry = new MetricRegistry(MetricRegistryConfiguration.fromConfiguration((Configuration)config));
        try {
            TaskManagerMetricGroup group = new TaskManagerMetricGroup(testRegistry, "host", "id");
            Assert.assertEquals((String)"MetricReporters list should be empty", (long)0L, (long)testRegistry.getReporters().size());
            Assert.assertEquals((Object)"A.B.X.D.1", (Object)group.getMetricIdentifier("1", FILTER_C));
            Assert.assertEquals((Object)"A.X.C.D.1", (Object)group.getMetricIdentifier("1", FILTER_B));
            Assert.assertEquals((Object)"A.X.C.D.1", (Object)group.getMetricIdentifier("1", FILTER_B, -1));
            Assert.assertEquals((Object)"A.X.C.D.1", (Object)group.getMetricIdentifier("1", FILTER_B, 2));
        }
        finally {
            testRegistry.shutdown();
        }
    }

    public static class TestReporter2
    extends ScopeCheckingTestReporter {
        @Override
        public String filterCharacters(String input) {
            return FILTER_C.filterCharacters(input);
        }

        @Override
        public void checkScopes(Metric metric, String metricName, MetricGroup group) {
            Assert.assertEquals((Object)"A!B!X!D!1", (Object)group.getMetricIdentifier(metricName, (CharacterFilter)this));
            Assert.assertEquals((Object)"A!B!X!D!1", (Object)group.getMetricIdentifier(metricName));
            Assert.assertEquals((Object)"A!B!X!D!1", (Object)group.getMetricIdentifier(metricName, FILTER_C));
            Assert.assertEquals((Object)"A!B!X!D!3", (Object)group.getMetricIdentifier(metricName, new CharacterFilter(){

                public String filterCharacters(String input) {
                    return input.replace("A", "X").replace("1", "3");
                }
            }));
        }
    }

    public static class TestReporter1
    extends ScopeCheckingTestReporter {
        @Override
        public String filterCharacters(String input) {
            return FILTER_B.filterCharacters(input);
        }

        @Override
        public void checkScopes(Metric metric, String metricName, MetricGroup group) {
            Assert.assertEquals((Object)"A-B-C-D-1", (Object)group.getMetricIdentifier(metricName));
            Assert.assertEquals((Object)"A-B-C-D-1", (Object)group.getMetricIdentifier(metricName, FILTER_C));
            Assert.assertEquals((Object)"A-B-C-D-1", (Object)group.getMetricIdentifier(metricName, (CharacterFilter)this));
            Assert.assertEquals((Object)"A-B-C-D-4", (Object)group.getMetricIdentifier(metricName, new CharacterFilter(){

                public String filterCharacters(String input) {
                    return input.replace("B", "X").replace("1", "4");
                }
            }));
        }
    }

    private static abstract class ScopeCheckingTestReporter
    extends TestReporter {
        protected Exception failureCause;

        private ScopeCheckingTestReporter() {
        }

        @Override
        public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
            block2: {
                try {
                    this.checkScopes(metric, metricName, group);
                }
                catch (Exception e) {
                    if (this.failureCause != null) break block2;
                    this.failureCause = e;
                }
            }
        }

        public abstract void checkScopes(Metric var1, String var2, MetricGroup var3);
    }
}

