/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryConfiguration;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.JobManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.JobManagerMetricGroup;
import org.apache.flink.runtime.metrics.util.DummyCharacterFilter;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class JobManagerJobGroupTest
extends TestLogger {
    @Test
    public void testGenerateScopeDefault() {
        MetricRegistry registry = new MetricRegistry(MetricRegistryConfiguration.defaultMetricRegistryConfiguration());
        JobManagerMetricGroup tmGroup = new JobManagerMetricGroup(registry, "theHostName");
        JobManagerJobMetricGroup jmGroup = new JobManagerJobMetricGroup(registry, tmGroup, new JobID(), "myJobName");
        Assert.assertArrayEquals((Object[])new String[]{"theHostName", "jobmanager", "myJobName"}, (Object[])jmGroup.getScopeComponents());
        Assert.assertEquals((Object)"theHostName.jobmanager.myJobName.name", (Object)jmGroup.getMetricIdentifier("name"));
        registry.shutdown();
    }

    @Test
    public void testGenerateScopeCustom() {
        Configuration cfg = new Configuration();
        cfg.setString(MetricOptions.SCOPE_NAMING_JM, "abc");
        cfg.setString(MetricOptions.SCOPE_NAMING_JM_JOB, "some-constant.<job_name>");
        MetricRegistry registry = new MetricRegistry(MetricRegistryConfiguration.fromConfiguration((Configuration)cfg));
        JobID jid = new JobID();
        JobManagerMetricGroup tmGroup = new JobManagerMetricGroup(registry, "theHostName");
        JobManagerJobMetricGroup jmGroup = new JobManagerJobMetricGroup(registry, tmGroup, jid, "myJobName");
        Assert.assertArrayEquals((Object[])new String[]{"some-constant", "myJobName"}, (Object[])jmGroup.getScopeComponents());
        Assert.assertEquals((Object)"some-constant.myJobName.name", (Object)jmGroup.getMetricIdentifier("name"));
        registry.shutdown();
    }

    @Test
    public void testGenerateScopeCustomWildcard() {
        Configuration cfg = new Configuration();
        cfg.setString(MetricOptions.SCOPE_NAMING_JM, "peter");
        cfg.setString(MetricOptions.SCOPE_NAMING_JM_JOB, "*.some-constant.<job_id>");
        MetricRegistry registry = new MetricRegistry(MetricRegistryConfiguration.fromConfiguration((Configuration)cfg));
        JobID jid = new JobID();
        JobManagerMetricGroup tmGroup = new JobManagerMetricGroup(registry, "theHostName");
        JobManagerJobMetricGroup jmGroup = new JobManagerJobMetricGroup(registry, tmGroup, jid, "myJobName");
        Assert.assertArrayEquals((Object[])new String[]{"peter", "some-constant", jid.toString()}, (Object[])jmGroup.getScopeComponents());
        Assert.assertEquals((Object)("peter.some-constant." + jid + ".name"), (Object)jmGroup.getMetricIdentifier("name"));
        registry.shutdown();
    }

    @Test
    public void testCreateQueryServiceMetricInfo() {
        JobID jid = new JobID();
        MetricRegistry registry = new MetricRegistry(MetricRegistryConfiguration.defaultMetricRegistryConfiguration());
        JobManagerMetricGroup jm = new JobManagerMetricGroup(registry, "host");
        JobManagerJobMetricGroup jmj = new JobManagerJobMetricGroup(registry, jm, jid, "jobname");
        QueryScopeInfo.JobQueryScopeInfo info = jmj.createQueryServiceMetricInfo((CharacterFilter)new DummyCharacterFilter());
        Assert.assertEquals((Object)"", (Object)info.scope);
        Assert.assertEquals((Object)jid.toString(), (Object)info.jobID);
    }
}

