/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.HistogramStatistics;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryConfiguration;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.util.TestReporter;
import org.junit.Assert;
import org.junit.Test;

public class MetricGroupRegistrationTest {
    @Test
    public void testMetricInstantiation() {
        Configuration config = new Configuration();
        config.setString(MetricOptions.REPORTERS_LIST, "test");
        config.setString("metrics.reporter.test.class", TestReporter1.class.getName());
        MetricRegistry registry = new MetricRegistry(MetricRegistryConfiguration.fromConfiguration((Configuration)config));
        TaskManagerMetricGroup root = new TaskManagerMetricGroup(registry, "host", "id");
        Counter counter = root.counter("counter");
        Assert.assertEquals((Object)counter, (Object)TestReporter1.lastPassedMetric);
        Assert.assertEquals((Object)"counter", (Object)TestReporter1.lastPassedName);
        Gauge gauge = root.gauge("gauge", (Gauge)new Gauge<Object>(){

            public Object getValue() {
                return null;
            }
        });
        Assert.assertEquals((Object)gauge, (Object)TestReporter1.lastPassedMetric);
        Assert.assertEquals((Object)"gauge", (Object)TestReporter1.lastPassedName);
        Histogram histogram = root.histogram("histogram", new Histogram(){

            public void update(long value) {
            }

            public long getCount() {
                return 0L;
            }

            public HistogramStatistics getStatistics() {
                return null;
            }
        });
        Assert.assertEquals((Object)histogram, (Object)TestReporter1.lastPassedMetric);
        Assert.assertEquals((Object)"histogram", (Object)TestReporter1.lastPassedName);
        registry.shutdown();
    }

    @Test
    public void testDuplicateGroupName() {
        Configuration config = new Configuration();
        MetricRegistry registry = new MetricRegistry(MetricRegistryConfiguration.fromConfiguration((Configuration)config));
        TaskManagerMetricGroup root = new TaskManagerMetricGroup(registry, "host", "id");
        MetricGroup group1 = root.addGroup("group");
        MetricGroup group2 = root.addGroup("group");
        MetricGroup group3 = root.addGroup("group");
        Assert.assertTrue((group1 == group2 && group2 == group3 ? 1 : 0) != 0);
        registry.shutdown();
    }

    public static class TestReporter1
    extends TestReporter {
        public static Metric lastPassedMetric;
        public static String lastPassedName;

        @Override
        public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
            lastPassedMetric = metric;
            lastPassedName = metricName;
        }
    }
}

