/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryConfiguration;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.OperatorMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.runtime.metrics.util.DummyCharacterFilter;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class OperatorGroupTest
extends TestLogger {
    @Test
    public void testGenerateScopeDefault() {
        MetricRegistry registry = new MetricRegistry(MetricRegistryConfiguration.defaultMetricRegistryConfiguration());
        TaskManagerMetricGroup tmGroup = new TaskManagerMetricGroup(registry, "theHostName", "test-tm-id");
        TaskManagerJobMetricGroup jmGroup = new TaskManagerJobMetricGroup(registry, tmGroup, new JobID(), "myJobName");
        TaskMetricGroup taskGroup = new TaskMetricGroup(registry, jmGroup, new AbstractID(), new AbstractID(), "aTaskName", 11, 0);
        OperatorMetricGroup opGroup = new OperatorMetricGroup(registry, taskGroup, "myOpName");
        Assert.assertArrayEquals((Object[])new String[]{"theHostName", "taskmanager", "test-tm-id", "myJobName", "myOpName", "11"}, (Object[])opGroup.getScopeComponents());
        Assert.assertEquals((Object)"theHostName.taskmanager.test-tm-id.myJobName.myOpName.11.name", (Object)opGroup.getMetricIdentifier("name"));
        registry.shutdown();
    }

    @Test
    public void testIOMetricGroupInstantiation() {
        MetricRegistry registry = new MetricRegistry(MetricRegistryConfiguration.defaultMetricRegistryConfiguration());
        TaskManagerMetricGroup tmGroup = new TaskManagerMetricGroup(registry, "theHostName", "test-tm-id");
        TaskManagerJobMetricGroup jmGroup = new TaskManagerJobMetricGroup(registry, tmGroup, new JobID(), "myJobName");
        TaskMetricGroup taskGroup = new TaskMetricGroup(registry, jmGroup, new AbstractID(), new AbstractID(), "aTaskName", 11, 0);
        OperatorMetricGroup opGroup = new OperatorMetricGroup(registry, taskGroup, "myOpName");
        Assert.assertNotNull((Object)opGroup.getIOMetricGroup());
        Assert.assertNotNull((Object)opGroup.getIOMetricGroup().getNumRecordsInCounter());
        Assert.assertNotNull((Object)opGroup.getIOMetricGroup().getNumRecordsOutCounter());
        registry.shutdown();
    }

    @Test
    public void testVariables() {
        MetricRegistry registry = new MetricRegistry(MetricRegistryConfiguration.defaultMetricRegistryConfiguration());
        JobID jid = new JobID();
        AbstractID tid = new AbstractID();
        AbstractID eid = new AbstractID();
        TaskManagerMetricGroup tmGroup = new TaskManagerMetricGroup(registry, "theHostName", "test-tm-id");
        TaskManagerJobMetricGroup jmGroup = new TaskManagerJobMetricGroup(registry, tmGroup, jid, "myJobName");
        TaskMetricGroup taskGroup = new TaskMetricGroup(registry, jmGroup, tid, eid, "aTaskName", 11, 0);
        OperatorMetricGroup opGroup = new OperatorMetricGroup(registry, taskGroup, "myOpName");
        Map variables = opGroup.getAllVariables();
        OperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_HOST, "theHostName");
        OperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_TASKMANAGER_ID, "test-tm-id");
        OperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_JOB_ID, jid.toString());
        OperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_JOB_NAME, "myJobName");
        OperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_TASK_VERTEX_ID, tid.toString());
        OperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_TASK_NAME, "aTaskName");
        OperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_TASK_ATTEMPT_ID, eid.toString());
        OperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_TASK_SUBTASK_INDEX, "11");
        OperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_TASK_ATTEMPT_NUM, "0");
        OperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_OPERATOR_NAME, "myOpName");
        registry.shutdown();
    }

    private static void testVariable(Map<String, String> variables, String key, String expectedValue) {
        String actualValue = variables.get(key);
        Assert.assertNotNull((Object)actualValue);
        Assert.assertEquals((Object)expectedValue, (Object)actualValue);
    }

    @Test
    public void testCreateQueryServiceMetricInfo() {
        JobID jid = new JobID();
        AbstractID vid = new AbstractID();
        AbstractID eid = new AbstractID();
        MetricRegistry registry = new MetricRegistry(MetricRegistryConfiguration.defaultMetricRegistryConfiguration());
        TaskManagerMetricGroup tm = new TaskManagerMetricGroup(registry, "host", "id");
        TaskManagerJobMetricGroup job = new TaskManagerJobMetricGroup(registry, tm, jid, "jobname");
        TaskMetricGroup task = new TaskMetricGroup(registry, job, vid, eid, "taskName", 4, 5);
        OperatorMetricGroup operator = new OperatorMetricGroup(registry, task, "operator");
        QueryScopeInfo.OperatorQueryScopeInfo info = operator.createQueryServiceMetricInfo((CharacterFilter)new DummyCharacterFilter());
        Assert.assertEquals((Object)"", (Object)info.scope);
        Assert.assertEquals((Object)jid.toString(), (Object)info.jobID);
        Assert.assertEquals((Object)vid.toString(), (Object)info.vertexID);
        Assert.assertEquals((long)4L, (long)info.subtaskIndex);
        Assert.assertEquals((Object)"operator", (Object)info.operatorName);
    }
}

