/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.junit.Assert;
import org.junit.Test;

public class QueryScopeInfoTest {
    @Test
    public void testJobManagerQueryScopeInfo() {
        QueryScopeInfo.JobManagerQueryScopeInfo info = new QueryScopeInfo.JobManagerQueryScopeInfo();
        Assert.assertEquals((long)0L, (long)info.getCategory());
        Assert.assertEquals((Object)"", (Object)info.scope);
        info = info.copy("world");
        Assert.assertEquals((long)0L, (long)info.getCategory());
        Assert.assertEquals((Object)"world", (Object)info.scope);
        info = new QueryScopeInfo.JobManagerQueryScopeInfo("hello");
        Assert.assertEquals((long)0L, (long)info.getCategory());
        Assert.assertEquals((Object)"hello", (Object)info.scope);
        info = info.copy("world");
        Assert.assertEquals((long)0L, (long)info.getCategory());
        Assert.assertEquals((Object)"hello.world", (Object)info.scope);
    }

    @Test
    public void testTaskManagerQueryScopeInfo() {
        QueryScopeInfo.TaskManagerQueryScopeInfo info = new QueryScopeInfo.TaskManagerQueryScopeInfo("tmid");
        Assert.assertEquals((long)1L, (long)info.getCategory());
        Assert.assertEquals((Object)"", (Object)info.scope);
        Assert.assertEquals((Object)"tmid", (Object)info.taskManagerID);
        info = info.copy("world");
        Assert.assertEquals((long)1L, (long)info.getCategory());
        Assert.assertEquals((Object)"world", (Object)info.scope);
        Assert.assertEquals((Object)"tmid", (Object)info.taskManagerID);
        info = new QueryScopeInfo.TaskManagerQueryScopeInfo("tmid", "hello");
        Assert.assertEquals((long)1L, (long)info.getCategory());
        Assert.assertEquals((Object)"hello", (Object)info.scope);
        Assert.assertEquals((Object)"tmid", (Object)info.taskManagerID);
        info = info.copy("world");
        Assert.assertEquals((long)1L, (long)info.getCategory());
        Assert.assertEquals((Object)"hello.world", (Object)info.scope);
        Assert.assertEquals((Object)"tmid", (Object)info.taskManagerID);
    }

    @Test
    public void testJobQueryScopeInfo() {
        QueryScopeInfo.JobQueryScopeInfo info = new QueryScopeInfo.JobQueryScopeInfo("jobid");
        Assert.assertEquals((long)2L, (long)info.getCategory());
        Assert.assertEquals((Object)"", (Object)info.scope);
        Assert.assertEquals((Object)"jobid", (Object)info.jobID);
        info = info.copy("world");
        Assert.assertEquals((long)2L, (long)info.getCategory());
        Assert.assertEquals((Object)"world", (Object)info.scope);
        Assert.assertEquals((Object)"jobid", (Object)info.jobID);
        info = new QueryScopeInfo.JobQueryScopeInfo("jobid", "hello");
        Assert.assertEquals((long)2L, (long)info.getCategory());
        Assert.assertEquals((Object)"hello", (Object)info.scope);
        Assert.assertEquals((Object)"jobid", (Object)info.jobID);
        info = info.copy("world");
        Assert.assertEquals((long)2L, (long)info.getCategory());
        Assert.assertEquals((Object)"hello.world", (Object)info.scope);
        Assert.assertEquals((Object)"jobid", (Object)info.jobID);
    }

    @Test
    public void testTaskQueryScopeInfo() {
        QueryScopeInfo.TaskQueryScopeInfo info = new QueryScopeInfo.TaskQueryScopeInfo("jobid", "taskid", 2);
        Assert.assertEquals((long)3L, (long)info.getCategory());
        Assert.assertEquals((Object)"", (Object)info.scope);
        Assert.assertEquals((Object)"jobid", (Object)info.jobID);
        Assert.assertEquals((Object)"taskid", (Object)info.vertexID);
        Assert.assertEquals((long)2L, (long)info.subtaskIndex);
        info = info.copy("world");
        Assert.assertEquals((long)3L, (long)info.getCategory());
        Assert.assertEquals((Object)"world", (Object)info.scope);
        Assert.assertEquals((Object)"jobid", (Object)info.jobID);
        Assert.assertEquals((Object)"taskid", (Object)info.vertexID);
        Assert.assertEquals((long)2L, (long)info.subtaskIndex);
        info = new QueryScopeInfo.TaskQueryScopeInfo("jobid", "taskid", 2, "hello");
        Assert.assertEquals((long)3L, (long)info.getCategory());
        Assert.assertEquals((Object)"hello", (Object)info.scope);
        Assert.assertEquals((Object)"jobid", (Object)info.jobID);
        Assert.assertEquals((Object)"taskid", (Object)info.vertexID);
        Assert.assertEquals((long)2L, (long)info.subtaskIndex);
        info = info.copy("world");
        Assert.assertEquals((long)3L, (long)info.getCategory());
        Assert.assertEquals((Object)"hello.world", (Object)info.scope);
        Assert.assertEquals((Object)"jobid", (Object)info.jobID);
        Assert.assertEquals((Object)"taskid", (Object)info.vertexID);
        Assert.assertEquals((long)2L, (long)info.subtaskIndex);
    }

    @Test
    public void testOperatorQueryScopeInfo() {
        QueryScopeInfo.OperatorQueryScopeInfo info = new QueryScopeInfo.OperatorQueryScopeInfo("jobid", "taskid", 2, "opname");
        Assert.assertEquals((long)4L, (long)info.getCategory());
        Assert.assertEquals((Object)"", (Object)info.scope);
        Assert.assertEquals((Object)"jobid", (Object)info.jobID);
        Assert.assertEquals((Object)"taskid", (Object)info.vertexID);
        Assert.assertEquals((Object)"opname", (Object)info.operatorName);
        Assert.assertEquals((long)2L, (long)info.subtaskIndex);
        info = info.copy("world");
        Assert.assertEquals((long)4L, (long)info.getCategory());
        Assert.assertEquals((Object)"world", (Object)info.scope);
        Assert.assertEquals((Object)"jobid", (Object)info.jobID);
        Assert.assertEquals((Object)"taskid", (Object)info.vertexID);
        Assert.assertEquals((Object)"opname", (Object)info.operatorName);
        Assert.assertEquals((long)2L, (long)info.subtaskIndex);
        info = new QueryScopeInfo.OperatorQueryScopeInfo("jobid", "taskid", 2, "opname", "hello");
        Assert.assertEquals((long)4L, (long)info.getCategory());
        Assert.assertEquals((Object)"hello", (Object)info.scope);
        Assert.assertEquals((Object)"jobid", (Object)info.jobID);
        Assert.assertEquals((Object)"taskid", (Object)info.vertexID);
        Assert.assertEquals((Object)"opname", (Object)info.operatorName);
        Assert.assertEquals((long)2L, (long)info.subtaskIndex);
        info = info.copy("world");
        Assert.assertEquals((long)4L, (long)info.getCategory());
        Assert.assertEquals((Object)"hello.world", (Object)info.scope);
        Assert.assertEquals((Object)"jobid", (Object)info.jobID);
        Assert.assertEquals((Object)"taskid", (Object)info.vertexID);
        Assert.assertEquals((Object)"opname", (Object)info.operatorName);
        Assert.assertEquals((long)2L, (long)info.subtaskIndex);
    }
}

