/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.runtime.operators.testutils.UnregisteredTaskMetricsGroup;
import org.junit.Assert;
import org.junit.Test;

public class TaskIOMetricGroupTest {
    @Test
    public void testTaskIOMetricGroup() {
        UnregisteredTaskMetricsGroup task = new UnregisteredTaskMetricsGroup();
        TaskIOMetricGroup taskIO = task.getIOMetricGroup();
        Assert.assertNotNull((Object)taskIO.getNumRecordsInCounter());
        Assert.assertNotNull((Object)taskIO.getNumRecordsOutCounter());
        SimpleCounter c1 = new SimpleCounter();
        c1.inc(32L);
        SimpleCounter c2 = new SimpleCounter();
        c2.inc(64L);
        taskIO.reuseRecordsInputCounter((Counter)c1);
        taskIO.reuseRecordsOutputCounter((Counter)c2);
        Assert.assertEquals((long)32L, (long)taskIO.getNumRecordsInCounter().getCount());
        Assert.assertEquals((long)64L, (long)taskIO.getNumRecordsOutCounter().getCount());
        taskIO.getNumBytesInLocalCounter().inc(100L);
        taskIO.getNumBytesInRemoteCounter().inc(150L);
        taskIO.getNumBytesOutCounter().inc(250L);
        IOMetrics io = taskIO.createSnapshot();
        Assert.assertEquals((long)32L, (long)io.getNumRecordsIn());
        Assert.assertEquals((long)64L, (long)io.getNumRecordsOut());
        Assert.assertEquals((long)100L, (long)io.getNumBytesInLocal());
        Assert.assertEquals((long)150L, (long)io.getNumBytesInRemote());
        Assert.assertEquals((long)250L, (long)io.getNumBytesOut());
    }
}

