/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.minicluster;

import java.io.IOException;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.ScheduleMode;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;
import org.apache.flink.runtime.testtasks.NoOpInvokable;
import org.apache.flink.util.TestLogger;
import org.junit.Test;

public class MiniClusterITCase
extends TestLogger {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void runJobWithSingleRpcService() throws Exception {
        MiniClusterConfiguration cfg = new MiniClusterConfiguration();
        cfg.setUseSingleRpcService();
        MiniCluster miniCluster = new MiniCluster(cfg);
        try {
            miniCluster.start();
            MiniClusterITCase.executeJob(miniCluster);
        }
        finally {
            miniCluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void runJobWithMultipleRpcServices() throws Exception {
        MiniClusterConfiguration cfg = new MiniClusterConfiguration();
        cfg.setUseRpcServicePerComponent();
        MiniCluster miniCluster = new MiniCluster(cfg);
        try {
            miniCluster.start();
            MiniClusterITCase.executeJob(miniCluster);
        }
        finally {
            miniCluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void runJobWithMultipleJobManagers() throws Exception {
        MiniClusterConfiguration cfg = new MiniClusterConfiguration();
        cfg.setNumJobManagers(3);
        MiniCluster miniCluster = new MiniCluster(cfg);
        try {
            miniCluster.start();
            MiniClusterITCase.executeJob(miniCluster);
        }
        finally {
            miniCluster.shutdown();
        }
    }

    private static void executeJob(MiniCluster miniCluster) throws Exception {
        JobGraph job = MiniClusterITCase.getSimpleJob();
        miniCluster.runJobBlocking(job);
    }

    private static JobGraph getSimpleJob() throws IOException {
        JobVertex task = new JobVertex("Test task");
        task.setParallelism(1);
        task.setMaxParallelism(1);
        task.setInvokableClass(NoOpInvokable.class);
        JobGraph jg = new JobGraph(new JobID(), "Test Job", new JobVertex[]{task});
        jg.setAllowQueuedScheduling(true);
        jg.setScheduleMode(ScheduleMode.EAGER);
        ExecutionConfig executionConfig = new ExecutionConfig();
        executionConfig.setRestartStrategy(RestartStrategies.fixedDelayRestart((int)Integer.MAX_VALUE, (long)1000L));
        jg.setExecutionConfig(executionConfig);
        return jg;
    }
}

