/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.util;

import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.operators.util.BloomFilter;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class BloomFilterTest {
    private static BloomFilter bloomFilter;
    private static final int INPUT_SIZE = 1024;
    private static final double FALSE_POSITIVE_PROBABILITY = 0.05;

    @BeforeClass
    public static void init() {
        int bitsSize = BloomFilter.optimalNumOfBits((long)1024L, (double)0.05);
        bitsSize += 64 - bitsSize % 64;
        int byteSize = bitsSize >>> 3;
        MemorySegment memorySegment = MemorySegmentFactory.allocateUnpooledSegment((int)byteSize);
        bloomFilter = new BloomFilter(1024, byteSize);
        bloomFilter.setBitsLocation(memorySegment, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBloomFilterArguments1() {
        new BloomFilter(-1, 128);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBloomFilterArguments2() {
        new BloomFilter(0, 128);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBloomFilterArguments3() {
        new BloomFilter(1024, -1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBloomFilterArguments4() {
        new BloomFilter(1024, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBloomFilterArguments5() {
        new BloomFilter(1024, 21);
    }

    @Test
    public void testBloomNumBits() {
        Assert.assertEquals((long)0L, (long)BloomFilter.optimalNumOfBits((long)0L, (double)0.0));
        Assert.assertEquals((long)0L, (long)BloomFilter.optimalNumOfBits((long)0L, (double)1.0));
        Assert.assertEquals((long)0L, (long)BloomFilter.optimalNumOfBits((long)1L, (double)1.0));
        Assert.assertEquals((long)7L, (long)BloomFilter.optimalNumOfBits((long)1L, (double)0.03));
        Assert.assertEquals((long)72L, (long)BloomFilter.optimalNumOfBits((long)10L, (double)0.03));
        Assert.assertEquals((long)729L, (long)BloomFilter.optimalNumOfBits((long)100L, (double)0.03));
        Assert.assertEquals((long)7298L, (long)BloomFilter.optimalNumOfBits((long)1000L, (double)0.03));
        Assert.assertEquals((long)72984L, (long)BloomFilter.optimalNumOfBits((long)10000L, (double)0.03));
        Assert.assertEquals((long)729844L, (long)BloomFilter.optimalNumOfBits((long)100000L, (double)0.03));
        Assert.assertEquals((long)7298440L, (long)BloomFilter.optimalNumOfBits((long)1000000L, (double)0.03));
        Assert.assertEquals((long)6235224L, (long)BloomFilter.optimalNumOfBits((long)1000000L, (double)0.05));
    }

    @Test
    public void testBloomFilterNumHashFunctions() {
        Assert.assertEquals((long)1L, (long)BloomFilter.optimalNumOfHashFunctions((long)-1L, (long)-1L));
        Assert.assertEquals((long)1L, (long)BloomFilter.optimalNumOfHashFunctions((long)0L, (long)0L));
        Assert.assertEquals((long)1L, (long)BloomFilter.optimalNumOfHashFunctions((long)10L, (long)0L));
        Assert.assertEquals((long)1L, (long)BloomFilter.optimalNumOfHashFunctions((long)10L, (long)10L));
        Assert.assertEquals((long)7L, (long)BloomFilter.optimalNumOfHashFunctions((long)10L, (long)100L));
        Assert.assertEquals((long)1L, (long)BloomFilter.optimalNumOfHashFunctions((long)100L, (long)100L));
        Assert.assertEquals((long)1L, (long)BloomFilter.optimalNumOfHashFunctions((long)1000L, (long)100L));
        Assert.assertEquals((long)1L, (long)BloomFilter.optimalNumOfHashFunctions((long)10000L, (long)100L));
        Assert.assertEquals((long)1L, (long)BloomFilter.optimalNumOfHashFunctions((long)100000L, (long)100L));
        Assert.assertEquals((long)1L, (long)BloomFilter.optimalNumOfHashFunctions((long)1000000L, (long)100L));
    }

    @Test
    public void testBloomFilterFalsePositiveProbability() {
        Assert.assertEquals((long)7298440L, (long)BloomFilter.optimalNumOfBits((long)1000000L, (double)0.03));
        Assert.assertEquals((long)6235224L, (long)BloomFilter.optimalNumOfBits((long)1000000L, (double)0.05));
        Assert.assertEquals((long)4792529L, (long)BloomFilter.optimalNumOfBits((long)1000000L, (double)0.1));
        Assert.assertEquals((long)3349834L, (long)BloomFilter.optimalNumOfBits((long)1000000L, (double)0.2));
        Assert.assertEquals((long)2505911L, (long)BloomFilter.optimalNumOfBits((long)1000000L, (double)0.3));
        Assert.assertEquals((long)1907139L, (long)BloomFilter.optimalNumOfBits((long)1000000L, (double)0.4));
        Assert.assertTrue((Math.abs(BloomFilter.estimateFalsePositiveProbability((long)1000000L, (int)7298440) - 0.03) < 0.01 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(BloomFilter.estimateFalsePositiveProbability((long)1000000L, (int)6235224) - 0.05) < 0.01 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(BloomFilter.estimateFalsePositiveProbability((long)1000000L, (int)4792529) - 0.1) < 0.01 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(BloomFilter.estimateFalsePositiveProbability((long)1000000L, (int)3349834) - 0.2) < 0.01 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(BloomFilter.estimateFalsePositiveProbability((long)1000000L, (int)2505911) - 0.3) < 0.01 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(BloomFilter.estimateFalsePositiveProbability((long)1000000L, (int)1907139) - 0.4) < 0.01 ? 1 : 0) != 0);
    }

    @Test
    public void testHashcodeInput() {
        bloomFilter.reset();
        int val1 = "val1".hashCode();
        int val2 = "val2".hashCode();
        int val3 = "val3".hashCode();
        int val4 = "val4".hashCode();
        int val5 = "val5".hashCode();
        Assert.assertFalse((boolean)bloomFilter.testHash(val1));
        Assert.assertFalse((boolean)bloomFilter.testHash(val2));
        Assert.assertFalse((boolean)bloomFilter.testHash(val3));
        Assert.assertFalse((boolean)bloomFilter.testHash(val4));
        Assert.assertFalse((boolean)bloomFilter.testHash(val5));
        bloomFilter.addHash(val1);
        Assert.assertTrue((boolean)bloomFilter.testHash(val1));
        Assert.assertFalse((boolean)bloomFilter.testHash(val2));
        Assert.assertFalse((boolean)bloomFilter.testHash(val3));
        Assert.assertFalse((boolean)bloomFilter.testHash(val4));
        Assert.assertFalse((boolean)bloomFilter.testHash(val5));
        bloomFilter.addHash(val2);
        Assert.assertTrue((boolean)bloomFilter.testHash(val1));
        Assert.assertTrue((boolean)bloomFilter.testHash(val2));
        Assert.assertFalse((boolean)bloomFilter.testHash(val3));
        Assert.assertFalse((boolean)bloomFilter.testHash(val4));
        Assert.assertFalse((boolean)bloomFilter.testHash(val5));
        bloomFilter.addHash(val3);
        Assert.assertTrue((boolean)bloomFilter.testHash(val1));
        Assert.assertTrue((boolean)bloomFilter.testHash(val2));
        Assert.assertTrue((boolean)bloomFilter.testHash(val3));
        Assert.assertFalse((boolean)bloomFilter.testHash(val4));
        Assert.assertFalse((boolean)bloomFilter.testHash(val5));
        bloomFilter.addHash(val4);
        Assert.assertTrue((boolean)bloomFilter.testHash(val1));
        Assert.assertTrue((boolean)bloomFilter.testHash(val2));
        Assert.assertTrue((boolean)bloomFilter.testHash(val3));
        Assert.assertTrue((boolean)bloomFilter.testHash(val4));
        Assert.assertFalse((boolean)bloomFilter.testHash(val5));
        bloomFilter.addHash(val5);
        Assert.assertTrue((boolean)bloomFilter.testHash(val1));
        Assert.assertTrue((boolean)bloomFilter.testHash(val2));
        Assert.assertTrue((boolean)bloomFilter.testHash(val3));
        Assert.assertTrue((boolean)bloomFilter.testHash(val4));
        Assert.assertTrue((boolean)bloomFilter.testHash(val5));
    }
}

