/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.query.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.nio.channels.ClosedChannelException;
import org.apache.flink.runtime.query.netty.KvStateClientHandler;
import org.apache.flink.runtime.query.netty.KvStateClientHandlerCallback;
import org.apache.flink.runtime.query.netty.message.KvStateRequestSerializer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class KvStateClientHandlerTest {
    @Test
    public void testReadCallbacksAndBufferRecycling() throws Exception {
        KvStateClientHandlerCallback callback = (KvStateClientHandlerCallback)Mockito.mock(KvStateClientHandlerCallback.class);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new KvStateClientHandler(callback)});
        ByteBuf buf = KvStateRequestSerializer.serializeKvStateRequestResult((ByteBufAllocator)channel.alloc(), (long)1222112277L, (byte[])new byte[0]);
        buf.skipBytes(4);
        channel.writeInbound(new Object[]{buf});
        ((KvStateClientHandlerCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onRequestResult(Matchers.eq((long)1222112277L), (byte[])Matchers.any(byte[].class));
        Assert.assertEquals((String)"Buffer not recycled", (long)0L, (long)buf.refCnt());
        buf = KvStateRequestSerializer.serializeKvStateRequestFailure((ByteBufAllocator)channel.alloc(), (long)1222112278L, (Throwable)new RuntimeException("Expected test Exception"));
        buf.skipBytes(4);
        channel.writeInbound(new Object[]{buf});
        ((KvStateClientHandlerCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onRequestFailure(Matchers.eq((long)1222112278L), (Throwable)Matchers.any(RuntimeException.class));
        Assert.assertEquals((String)"Buffer not recycled", (long)0L, (long)buf.refCnt());
        buf = KvStateRequestSerializer.serializeServerFailure((ByteBufAllocator)channel.alloc(), (Throwable)new RuntimeException("Expected test Exception"));
        buf.skipBytes(4);
        channel.writeInbound(new Object[]{buf});
        ((KvStateClientHandlerCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onFailure((Throwable)Matchers.any(RuntimeException.class));
        buf = channel.alloc().buffer(4).writeInt(1223823);
        channel.writeInbound(new Object[]{buf});
        ((KvStateClientHandlerCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)2))).onFailure((Throwable)Matchers.any(IllegalStateException.class));
        Assert.assertEquals((String)"Buffer not recycled", (long)0L, (long)buf.refCnt());
        channel.pipeline().fireExceptionCaught((Throwable)new RuntimeException("Expected test Exception"));
        ((KvStateClientHandlerCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)3))).onFailure((Throwable)Matchers.any(RuntimeException.class));
        channel.pipeline().fireChannelInactive();
        ((KvStateClientHandlerCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)4))).onFailure((Throwable)Matchers.any(ClosedChannelException.class));
    }
}

