/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.registration;

import java.util.UUID;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.registration.RegisteredRpcConnection;
import org.apache.flink.runtime.registration.RegistrationResponse;
import org.apache.flink.runtime.registration.RetryingRegistration;
import org.apache.flink.runtime.registration.RetryingRegistrationTest;
import org.apache.flink.runtime.registration.TestRegistrationGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.TestingRpcService;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.slf4j.LoggerFactory;

public class RegisteredRpcConnectionTest
extends TestLogger {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuccessfulRpcConnection() throws Exception {
        String testRpcConnectionEndpointAddress = "<TestRpcConnectionEndpointAddress>";
        UUID leaderId = UUID.randomUUID();
        String connectionID = "Test RPC Connection ID";
        TestRegistrationGateway testGateway = new TestRegistrationGateway(new RegistrationResponse[]{new RetryingRegistrationTest.TestRegistrationSuccess("Test RPC Connection ID")});
        TestingRpcService rpcService = new TestingRpcService();
        try {
            rpcService.registerGateway("<TestRpcConnectionEndpointAddress>", testGateway);
            TestRpcConnection connection = new TestRpcConnection("<TestRpcConnectionEndpointAddress>", leaderId, rpcService.getExecutor(), (RpcService)rpcService);
            connection.start();
            Thread.sleep(200L);
            Assert.assertTrue((boolean)connection.isConnected());
            Assert.assertEquals((Object)"<TestRpcConnectionEndpointAddress>", (Object)connection.getTargetAddress());
            Assert.assertEquals((Object)leaderId, (Object)connection.getTargetLeaderId());
            Assert.assertEquals((Object)testGateway, (Object)connection.getTargetGateway());
            Assert.assertEquals((Object)"Test RPC Connection ID", (Object)connection.getConnectionId());
        }
        finally {
            testGateway.stop();
            rpcService.stopService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRpcConnectionFailures() throws Exception {
        String connectionFailureMessage = "Test RPC Connection failure";
        String testRpcConnectionEndpointAddress = "<TestRpcConnectionEndpointAddress>";
        UUID leaderId = UUID.randomUUID();
        TestingRpcService rpcService = new TestingRpcService();
        try {
            TestRegistrationGateway testGateway = (TestRegistrationGateway)Mockito.mock(TestRegistrationGateway.class);
            Mockito.when(testGateway.registrationCall((UUID)Matchers.any(UUID.class), Matchers.anyLong())).thenThrow(new Throwable[]{new RuntimeException("Test RPC Connection failure")});
            rpcService.registerGateway("<TestRpcConnectionEndpointAddress>", testGateway);
            TestRpcConnection connection = new TestRpcConnection("<TestRpcConnectionEndpointAddress>", leaderId, rpcService.getExecutor(), (RpcService)rpcService);
            connection.start();
            Thread.sleep(200L);
            Assert.assertFalse((boolean)connection.isConnected());
            Assert.assertEquals((Object)"<TestRpcConnectionEndpointAddress>", (Object)connection.getTargetAddress());
            Assert.assertEquals((Object)leaderId, (Object)connection.getTargetLeaderId());
            Assert.assertNull((Object)connection.getTargetGateway());
            Assert.assertEquals((Object)"Test RPC Connection failure", (Object)connection.getFailareMessage());
        }
        finally {
            rpcService.stopService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRpcConnectionClose() throws Exception {
        String testRpcConnectionEndpointAddress = "<TestRpcConnectionEndpointAddress>";
        UUID leaderId = UUID.randomUUID();
        String connectionID = "Test RPC Connection ID";
        TestRegistrationGateway testGateway = new TestRegistrationGateway(new RegistrationResponse[]{new RetryingRegistrationTest.TestRegistrationSuccess("Test RPC Connection ID")});
        TestingRpcService rpcService = new TestingRpcService();
        try {
            rpcService.registerGateway("<TestRpcConnectionEndpointAddress>", testGateway);
            TestRpcConnection connection = new TestRpcConnection("<TestRpcConnectionEndpointAddress>", leaderId, rpcService.getExecutor(), (RpcService)rpcService);
            connection.start();
            connection.close();
            Assert.assertEquals((Object)"<TestRpcConnectionEndpointAddress>", (Object)connection.getTargetAddress());
            Assert.assertEquals((Object)leaderId, (Object)connection.getTargetLeaderId());
            Assert.assertTrue((boolean)connection.isClosed());
        }
        finally {
            testGateway.stop();
            rpcService.stopService();
        }
    }

    private static class TestRpcConnection
    extends RegisteredRpcConnection<TestRegistrationGateway, RetryingRegistrationTest.TestRegistrationSuccess> {
        private final RpcService rpcService;
        private String connectionId;
        private String failureMessage;

        public TestRpcConnection(String targetAddress, UUID targetLeaderId, Executor executor, RpcService rpcService) {
            super(LoggerFactory.getLogger(RegisteredRpcConnectionTest.class), targetAddress, targetLeaderId, executor);
            this.rpcService = rpcService;
        }

        protected RetryingRegistration<TestRegistrationGateway, RetryingRegistrationTest.TestRegistrationSuccess> generateRegistration() {
            return new RetryingRegistrationTest.TestRetryingRegistration(this.rpcService, this.getTargetAddress(), this.getTargetLeaderId());
        }

        protected void onRegistrationSuccess(RetryingRegistrationTest.TestRegistrationSuccess success) {
            this.connectionId = success.getCorrelationId();
        }

        protected void onRegistrationFailure(Throwable failure) {
            this.failureMessage = failure.getMessage();
        }

        public String getConnectionId() {
            return this.connectionId;
        }

        public String getFailareMessage() {
            return this.failureMessage;
        }
    }
}

