/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.registration;

import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.flink.runtime.concurrent.Future;
import org.apache.flink.runtime.concurrent.impl.FlinkCompletableFuture;
import org.apache.flink.runtime.registration.RegistrationResponse;
import org.apache.flink.runtime.rpc.TestingGatewayBase;
import org.apache.flink.util.Preconditions;

public class TestRegistrationGateway
extends TestingGatewayBase {
    private final BlockingQueue<RegistrationCall> invocations;
    private final RegistrationResponse[] responses;
    private int pos;

    public TestRegistrationGateway(RegistrationResponse ... responses) {
        Preconditions.checkArgument((responses != null && responses.length > 0 ? 1 : 0) != 0);
        this.invocations = new LinkedBlockingQueue<RegistrationCall>();
        this.responses = responses;
    }

    public Future<RegistrationResponse> registrationCall(UUID leaderId, long timeout) {
        this.invocations.add(new RegistrationCall(leaderId, timeout));
        RegistrationResponse response = this.responses[this.pos];
        if (this.pos < this.responses.length - 1) {
            ++this.pos;
        }
        return response != null ? FlinkCompletableFuture.completed((Object)response) : this.futureWithTimeout(timeout);
    }

    public BlockingQueue<RegistrationCall> getInvocations() {
        return this.invocations;
    }

    public static class RegistrationCall {
        private final UUID leaderId;
        private final long timeout;

        public RegistrationCall(UUID leaderId, long timeout) {
            this.leaderId = leaderId;
            this.timeout = timeout;
        }

        public UUID leaderId() {
            return this.leaderId;
        }

        public long timeout() {
            return this.timeout;
        }
    }
}

