/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.Future;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.TestingHighAvailabilityServices;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.jobmaster.JobMasterRegistrationSuccess;
import org.apache.flink.runtime.leaderelection.TestingLeaderElectionService;
import org.apache.flink.runtime.leaderelection.TestingLeaderRetrievalService;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.registration.RegistrationResponse;
import org.apache.flink.runtime.resourcemanager.JobLeaderIdService;
import org.apache.flink.runtime.resourcemanager.ResourceManager;
import org.apache.flink.runtime.resourcemanager.ResourceManagerConfiguration;
import org.apache.flink.runtime.resourcemanager.StandaloneResourceManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManager;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.TestingSerialRpcService;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.util.TestingFatalErrorHandler;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ResourceManagerJobMasterTest
extends TestLogger {
    private TestingSerialRpcService rpcService;

    @Before
    public void setup() throws Exception {
        this.rpcService = new TestingSerialRpcService();
    }

    @After
    public void teardown() throws Exception {
        this.rpcService.stopService();
    }

    @Test
    public void testRegisterJobMaster() throws Exception {
        String jobMasterAddress = "/jobMasterAddress1";
        JobID jobID = this.mockJobMaster(jobMasterAddress);
        TestingLeaderElectionService resourceManagerLeaderElectionService = new TestingLeaderElectionService();
        UUID jmLeaderID = UUID.randomUUID();
        ResourceID jmResourceId = new ResourceID(jobMasterAddress);
        TestingLeaderRetrievalService jobMasterLeaderRetrievalService = new TestingLeaderRetrievalService(jobMasterAddress, jmLeaderID);
        TestingFatalErrorHandler testingFatalErrorHandler = new TestingFatalErrorHandler();
        ResourceManager resourceManager = this.createAndStartResourceManager(resourceManagerLeaderElectionService, jobID, jobMasterLeaderRetrievalService, testingFatalErrorHandler);
        UUID rmLeaderSessionId = this.grantResourceManagerLeadership(resourceManagerLeaderElectionService);
        Future successfulFuture = resourceManager.registerJobManager(rmLeaderSessionId, jmLeaderID, jmResourceId, jobMasterAddress, jobID);
        RegistrationResponse response = (RegistrationResponse)successfulFuture.get(5L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)(response instanceof JobMasterRegistrationSuccess));
        if (testingFatalErrorHandler.hasExceptionOccurred()) {
            testingFatalErrorHandler.rethrowError();
        }
    }

    @Test
    public void testRegisterJobMasterWithUnmatchedLeaderSessionId1() throws Exception {
        String jobMasterAddress = "/jobMasterAddress1";
        JobID jobID = this.mockJobMaster(jobMasterAddress);
        TestingLeaderElectionService resourceManagerLeaderElectionService = new TestingLeaderElectionService();
        UUID jmLeaderID = UUID.randomUUID();
        ResourceID jmResourceId = new ResourceID(jobMasterAddress);
        TestingLeaderRetrievalService jobMasterLeaderRetrievalService = new TestingLeaderRetrievalService(jobMasterAddress, jmLeaderID);
        TestingFatalErrorHandler testingFatalErrorHandler = new TestingFatalErrorHandler();
        ResourceManager resourceManager = this.createAndStartResourceManager(resourceManagerLeaderElectionService, jobID, jobMasterLeaderRetrievalService, testingFatalErrorHandler);
        UUID rmLeaderSessionId = this.grantResourceManagerLeadership(resourceManagerLeaderElectionService);
        UUID differentLeaderSessionID = UUID.randomUUID();
        Future unMatchedLeaderFuture = resourceManager.registerJobManager(differentLeaderSessionID, jmLeaderID, jmResourceId, jobMasterAddress, jobID);
        Assert.assertTrue((boolean)(unMatchedLeaderFuture.get(5L, TimeUnit.SECONDS) instanceof RegistrationResponse.Decline));
        if (testingFatalErrorHandler.hasExceptionOccurred()) {
            testingFatalErrorHandler.rethrowError();
        }
    }

    @Test
    public void testRegisterJobMasterWithUnmatchedLeaderSessionId2() throws Exception {
        String jobMasterAddress = "/jobMasterAddress1";
        JobID jobID = this.mockJobMaster(jobMasterAddress);
        TestingLeaderElectionService resourceManagerLeaderElectionService = new TestingLeaderElectionService();
        TestingLeaderRetrievalService jobMasterLeaderRetrievalService = new TestingLeaderRetrievalService("localhost", HighAvailabilityServices.DEFAULT_LEADER_ID);
        TestingFatalErrorHandler testingFatalErrorHandler = new TestingFatalErrorHandler();
        ResourceManager resourceManager = this.createAndStartResourceManager(resourceManagerLeaderElectionService, jobID, jobMasterLeaderRetrievalService, testingFatalErrorHandler);
        UUID rmLeaderSessionId = this.grantResourceManagerLeadership(resourceManagerLeaderElectionService);
        UUID jmLeaderSessionId = this.grantResourceManagerLeadership(resourceManagerLeaderElectionService);
        ResourceID jmResourceId = new ResourceID(jobMasterAddress);
        UUID differentLeaderSessionID = UUID.randomUUID();
        Future unMatchedLeaderFuture = resourceManager.registerJobManager(rmLeaderSessionId, differentLeaderSessionID, jmResourceId, jobMasterAddress, jobID);
        Assert.assertTrue((boolean)(unMatchedLeaderFuture.get(5L, TimeUnit.SECONDS) instanceof RegistrationResponse.Decline));
        if (testingFatalErrorHandler.hasExceptionOccurred()) {
            testingFatalErrorHandler.rethrowError();
        }
    }

    @Test
    public void testRegisterJobMasterFromInvalidAddress() throws Exception {
        String jobMasterAddress = "/jobMasterAddress1";
        JobID jobID = this.mockJobMaster(jobMasterAddress);
        TestingLeaderElectionService resourceManagerLeaderElectionService = new TestingLeaderElectionService();
        TestingLeaderRetrievalService jobMasterLeaderRetrievalService = new TestingLeaderRetrievalService("localhost", HighAvailabilityServices.DEFAULT_LEADER_ID);
        TestingFatalErrorHandler testingFatalErrorHandler = new TestingFatalErrorHandler();
        ResourceManager resourceManager = this.createAndStartResourceManager(resourceManagerLeaderElectionService, jobID, jobMasterLeaderRetrievalService, testingFatalErrorHandler);
        UUID rmLeaderSessionId = this.grantResourceManagerLeadership(resourceManagerLeaderElectionService);
        UUID jmLeaderSessionId = this.grantResourceManagerLeadership(resourceManagerLeaderElectionService);
        ResourceID jmResourceId = new ResourceID(jobMasterAddress);
        String invalidAddress = "/jobMasterAddress2";
        Future invalidAddressFuture = resourceManager.registerJobManager(rmLeaderSessionId, jmLeaderSessionId, jmResourceId, invalidAddress, jobID);
        Assert.assertTrue((boolean)(invalidAddressFuture.get(5L, TimeUnit.SECONDS) instanceof RegistrationResponse.Decline));
        if (testingFatalErrorHandler.hasExceptionOccurred()) {
            testingFatalErrorHandler.rethrowError();
        }
    }

    @Test
    public void testRegisterJobMasterWithFailureLeaderListener() throws Exception {
        String jobMasterAddress = "/jobMasterAddress1";
        JobID jobID = this.mockJobMaster(jobMasterAddress);
        TestingLeaderElectionService resourceManagerLeaderElectionService = new TestingLeaderElectionService();
        TestingLeaderRetrievalService jobMasterLeaderRetrievalService = new TestingLeaderRetrievalService("localhost", HighAvailabilityServices.DEFAULT_LEADER_ID);
        TestingFatalErrorHandler testingFatalErrorHandler = new TestingFatalErrorHandler();
        ResourceManager resourceManager = this.createAndStartResourceManager(resourceManagerLeaderElectionService, jobID, jobMasterLeaderRetrievalService, testingFatalErrorHandler);
        UUID rmLeaderSessionId = this.grantResourceManagerLeadership(resourceManagerLeaderElectionService);
        UUID jmLeaderSessionId = this.grantResourceManagerLeadership(resourceManagerLeaderElectionService);
        ResourceID jmResourceId = new ResourceID(jobMasterAddress);
        JobID unknownJobIDToHAServices = new JobID();
        Future declineFuture = resourceManager.registerJobManager(rmLeaderSessionId, jmLeaderSessionId, jmResourceId, jobMasterAddress, unknownJobIDToHAServices);
        RegistrationResponse response = (RegistrationResponse)declineFuture.get(5L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)(response instanceof RegistrationResponse.Decline));
        if (testingFatalErrorHandler.hasExceptionOccurred()) {
            testingFatalErrorHandler.rethrowError();
        }
    }

    private JobID mockJobMaster(String jobMasterAddress) {
        JobID jobID = new JobID();
        JobMasterGateway jobMasterGateway = (JobMasterGateway)Mockito.mock(JobMasterGateway.class);
        this.rpcService.registerGateway(jobMasterAddress, (RpcGateway)jobMasterGateway);
        return jobID;
    }

    private ResourceManager createAndStartResourceManager(TestingLeaderElectionService resourceManagerLeaderElectionService, JobID jobID, TestingLeaderRetrievalService jobMasterLeaderRetrievalService, FatalErrorHandler fatalErrorHandler) throws Exception {
        ResourceID rmResourceId = ResourceID.generate();
        TestingHighAvailabilityServices highAvailabilityServices = new TestingHighAvailabilityServices();
        highAvailabilityServices.setResourceManagerLeaderElectionService(resourceManagerLeaderElectionService);
        highAvailabilityServices.setJobMasterLeaderRetriever(jobID, jobMasterLeaderRetrievalService);
        HeartbeatServices heartbeatServices = new HeartbeatServices(5L, 5L);
        ResourceManagerConfiguration resourceManagerConfiguration = new ResourceManagerConfiguration(Time.seconds((long)5L), Time.seconds((long)5L));
        MetricRegistry metricRegistry = (MetricRegistry)Mockito.mock(MetricRegistry.class);
        JobLeaderIdService jobLeaderIdService = new JobLeaderIdService((HighAvailabilityServices)highAvailabilityServices, this.rpcService.getScheduledExecutor(), Time.minutes((long)5L));
        SlotManager slotManager = new SlotManager(this.rpcService.getScheduledExecutor(), TestingUtils.infiniteTime(), TestingUtils.infiniteTime(), TestingUtils.infiniteTime());
        StandaloneResourceManager resourceManager = new StandaloneResourceManager((RpcService)this.rpcService, "resourcemanager", rmResourceId, resourceManagerConfiguration, (HighAvailabilityServices)highAvailabilityServices, heartbeatServices, slotManager, metricRegistry, jobLeaderIdService, fatalErrorHandler);
        resourceManager.start();
        return resourceManager;
    }

    private UUID grantResourceManagerLeadership(TestingLeaderElectionService resourceManagerLeaderElectionService) {
        UUID leaderSessionId = UUID.randomUUID();
        resourceManagerLeaderElectionService.isLeader(leaderSessionId);
        return leaderSessionId;
    }
}

