/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.Future;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.TestingHighAvailabilityServices;
import org.apache.flink.runtime.leaderelection.TestingLeaderElectionService;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.registration.RegistrationResponse;
import org.apache.flink.runtime.resourcemanager.JobLeaderIdService;
import org.apache.flink.runtime.resourcemanager.ResourceManagerConfiguration;
import org.apache.flink.runtime.resourcemanager.StandaloneResourceManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManager;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.TestingSerialRpcService;
import org.apache.flink.runtime.taskexecutor.SlotReport;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TaskExecutorRegistrationSuccess;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.util.TestingFatalErrorHandler;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ResourceManagerTaskExecutorTest
extends TestLogger {
    private TestingSerialRpcService rpcService;
    private SlotReport slotReport = new SlotReport();
    private static String taskExecutorAddress = "/taskExecutor1";
    private ResourceID taskExecutorResourceID;
    private ResourceID resourceManagerResourceID;
    private StandaloneResourceManager resourceManager;
    private UUID leaderSessionId;
    private TestingFatalErrorHandler testingFatalErrorHandler;

    @Before
    public void setup() throws Exception {
        this.rpcService = new TestingSerialRpcService();
        this.taskExecutorResourceID = this.mockTaskExecutor(taskExecutorAddress);
        this.resourceManagerResourceID = ResourceID.generate();
        TestingLeaderElectionService rmLeaderElectionService = new TestingLeaderElectionService();
        this.testingFatalErrorHandler = new TestingFatalErrorHandler();
        this.resourceManager = this.createAndStartResourceManager(rmLeaderElectionService, this.testingFatalErrorHandler);
        this.leaderSessionId = this.grantLeadership(rmLeaderElectionService);
    }

    @After
    public void teardown() throws Exception {
        this.rpcService.stopService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegisterTaskExecutor() throws Exception {
        try {
            Future successfulFuture = this.resourceManager.registerTaskExecutor(this.leaderSessionId, taskExecutorAddress, this.taskExecutorResourceID, this.slotReport);
            RegistrationResponse response = (RegistrationResponse)successfulFuture.get(5L, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)(response instanceof TaskExecutorRegistrationSuccess));
            Future duplicateFuture = this.resourceManager.registerTaskExecutor(this.leaderSessionId, taskExecutorAddress, this.taskExecutorResourceID, this.slotReport);
            RegistrationResponse duplicateResponse = (RegistrationResponse)duplicateFuture.get();
            Assert.assertTrue((boolean)(duplicateResponse instanceof TaskExecutorRegistrationSuccess));
            Assert.assertNotEquals((Object)((TaskExecutorRegistrationSuccess)response).getRegistrationId(), (Object)((TaskExecutorRegistrationSuccess)duplicateResponse).getRegistrationId());
        }
        finally {
            if (this.testingFatalErrorHandler.hasExceptionOccurred()) {
                this.testingFatalErrorHandler.rethrowError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegisterTaskExecutorWithUnmatchedLeaderSessionId() throws Exception {
        try {
            UUID differentLeaderSessionID = UUID.randomUUID();
            Future unMatchedLeaderFuture = this.resourceManager.registerTaskExecutor(differentLeaderSessionID, taskExecutorAddress, this.taskExecutorResourceID, this.slotReport);
            Assert.assertTrue((boolean)(unMatchedLeaderFuture.get(5L, TimeUnit.SECONDS) instanceof RegistrationResponse.Decline));
        }
        finally {
            if (this.testingFatalErrorHandler.hasExceptionOccurred()) {
                this.testingFatalErrorHandler.rethrowError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegisterTaskExecutorFromInvalidAddress() throws Exception {
        try {
            String invalidAddress = "/taskExecutor2";
            Future invalidAddressFuture = this.resourceManager.registerTaskExecutor(this.leaderSessionId, invalidAddress, this.taskExecutorResourceID, this.slotReport);
            Assert.assertTrue((boolean)(invalidAddressFuture.get(5L, TimeUnit.SECONDS) instanceof RegistrationResponse.Decline));
        }
        finally {
            if (this.testingFatalErrorHandler.hasExceptionOccurred()) {
                this.testingFatalErrorHandler.rethrowError();
            }
        }
    }

    private ResourceID mockTaskExecutor(String taskExecutorAddress) {
        TaskExecutorGateway taskExecutorGateway = (TaskExecutorGateway)Mockito.mock(TaskExecutorGateway.class);
        ResourceID taskExecutorResourceID = ResourceID.generate();
        this.rpcService.registerGateway(taskExecutorAddress, (RpcGateway)taskExecutorGateway);
        return taskExecutorResourceID;
    }

    private StandaloneResourceManager createAndStartResourceManager(TestingLeaderElectionService rmLeaderElectionService, FatalErrorHandler fatalErrorHandler) throws Exception {
        TestingHighAvailabilityServices highAvailabilityServices = new TestingHighAvailabilityServices();
        HeartbeatServices heartbeatServices = new HeartbeatServices(5L, 5L);
        highAvailabilityServices.setResourceManagerLeaderElectionService(rmLeaderElectionService);
        ResourceManagerConfiguration resourceManagerConfiguration = new ResourceManagerConfiguration(Time.seconds((long)5L), Time.seconds((long)5L));
        SlotManager slotManager = new SlotManager(this.rpcService.getScheduledExecutor(), TestingUtils.infiniteTime(), TestingUtils.infiniteTime(), TestingUtils.infiniteTime());
        MetricRegistry metricRegistry = (MetricRegistry)Mockito.mock(MetricRegistry.class);
        JobLeaderIdService jobLeaderIdService = new JobLeaderIdService((HighAvailabilityServices)highAvailabilityServices, this.rpcService.getScheduledExecutor(), Time.minutes((long)5L));
        StandaloneResourceManager resourceManager = new StandaloneResourceManager((RpcService)this.rpcService, "resourcemanager", this.resourceManagerResourceID, resourceManagerConfiguration, (HighAvailabilityServices)highAvailabilityServices, heartbeatServices, slotManager, metricRegistry, jobLeaderIdService, fatalErrorHandler);
        resourceManager.start();
        return resourceManager;
    }

    private UUID grantLeadership(TestingLeaderElectionService leaderElectionService) {
        UUID leaderSessionId = UUID.randomUUID();
        leaderElectionService.isLeader(leaderSessionId);
        return leaderSessionId;
    }
}

