/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.concurrent.ScheduledExecutorServiceAdapter;
import org.apache.flink.runtime.concurrent.impl.FlinkFuture;
import org.apache.flink.runtime.resourcemanager.SlotRequest;
import org.apache.flink.runtime.resourcemanager.registration.TaskExecutorConnection;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceManagerActions;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManager;
import org.apache.flink.runtime.taskexecutor.SlotReport;
import org.apache.flink.runtime.taskexecutor.SlotStatus;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.util.TestLogger;
import org.junit.AfterClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SlotProtocolTest
extends TestLogger {
    private static final long timeout = 10000L;
    private static final ScheduledExecutorService scheduledExecutorService = new ScheduledThreadPoolExecutor(1);
    private static final ScheduledExecutor scheduledExecutor = new ScheduledExecutorServiceAdapter(scheduledExecutorService);

    @AfterClass
    public static void afterClass() {
        Executors.gracefulShutdown((long)10000L, (TimeUnit)TimeUnit.MILLISECONDS, (ExecutorService[])new ExecutorService[]{scheduledExecutorService});
    }

    @Test
    public void testSlotsUnavailableRequest() throws Exception {
        JobID jobID = new JobID();
        UUID rmLeaderID = UUID.randomUUID();
        try (SlotManager slotManager = new SlotManager(scheduledExecutor, TestingUtils.infiniteTime(), TestingUtils.infiniteTime(), TestingUtils.infiniteTime());){
            ResourceManagerActions resourceManagerActions = (ResourceManagerActions)Mockito.mock(ResourceManagerActions.class);
            slotManager.start(rmLeaderID, Executors.directExecutor(), resourceManagerActions);
            AllocationID allocationID = new AllocationID();
            ResourceProfile resourceProfile = new ResourceProfile(1.0, 100);
            String targetAddress = "foobar";
            SlotRequest slotRequest = new SlotRequest(jobID, allocationID, resourceProfile, "foobar");
            slotManager.registerSlotRequest(slotRequest);
            ((ResourceManagerActions)Mockito.verify((Object)resourceManagerActions)).allocateResource((ResourceProfile)Matchers.eq((Object)slotRequest.getResourceProfile()));
            TaskExecutorGateway taskExecutorGateway = (TaskExecutorGateway)Mockito.mock(TaskExecutorGateway.class);
            Mockito.when((Object)taskExecutorGateway.requestSlot((SlotID)Matchers.any(SlotID.class), (JobID)Matchers.any(JobID.class), (AllocationID)Matchers.any(AllocationID.class), (String)Matchers.any(String.class), (UUID)Matchers.any(UUID.class), (Time)Matchers.any(Time.class))).thenReturn(Mockito.mock(FlinkFuture.class));
            ResourceID resourceID = ResourceID.generate();
            SlotID slotID = new SlotID(resourceID, 0);
            SlotStatus slotStatus = new SlotStatus(slotID, resourceProfile);
            SlotReport slotReport = new SlotReport(Collections.singletonList(slotStatus));
            slotManager.registerTaskManager(new TaskExecutorConnection(taskExecutorGateway), slotReport);
            ((TaskExecutorGateway)Mockito.verify((Object)taskExecutorGateway, (VerificationMode)Mockito.timeout((long)5000L))).requestSlot((SlotID)Matchers.eq((Object)slotID), (JobID)Matchers.eq((Object)jobID), (AllocationID)Matchers.eq((Object)allocationID), (String)Matchers.any(String.class), (UUID)Matchers.any(UUID.class), (Time)Matchers.any(Time.class));
        }
    }

    @Test
    public void testSlotAvailableRequest() throws Exception {
        JobID jobID = new JobID();
        UUID rmLeaderID = UUID.randomUUID();
        TaskExecutorGateway taskExecutorGateway = (TaskExecutorGateway)Mockito.mock(TaskExecutorGateway.class);
        Mockito.when((Object)taskExecutorGateway.requestSlot((SlotID)Matchers.any(SlotID.class), (JobID)Matchers.any(JobID.class), (AllocationID)Matchers.any(AllocationID.class), (String)Matchers.any(String.class), (UUID)Matchers.any(UUID.class), (Time)Matchers.any(Time.class))).thenReturn(Mockito.mock(FlinkFuture.class));
        try (SlotManager slotManager = new SlotManager(scheduledExecutor, TestingUtils.infiniteTime(), TestingUtils.infiniteTime(), TestingUtils.infiniteTime());){
            ResourceManagerActions resourceManagerActions = (ResourceManagerActions)Mockito.mock(ResourceManagerActions.class);
            slotManager.start(rmLeaderID, Executors.directExecutor(), resourceManagerActions);
            ResourceID resourceID = ResourceID.generate();
            AllocationID allocationID = new AllocationID();
            ResourceProfile resourceProfile = new ResourceProfile(1.0, 100);
            SlotID slotID = new SlotID(resourceID, 0);
            SlotStatus slotStatus = new SlotStatus(slotID, resourceProfile);
            SlotReport slotReport = new SlotReport(Collections.singletonList(slotStatus));
            slotManager.registerTaskManager(new TaskExecutorConnection(taskExecutorGateway), slotReport);
            String targetAddress = "foobar";
            SlotRequest slotRequest = new SlotRequest(jobID, allocationID, resourceProfile, "foobar");
            slotManager.registerSlotRequest(slotRequest);
            ((TaskExecutorGateway)Mockito.verify((Object)taskExecutorGateway, (VerificationMode)Mockito.timeout((long)5000L))).requestSlot((SlotID)Matchers.eq((Object)slotID), (JobID)Matchers.eq((Object)jobID), (AllocationID)Matchers.eq((Object)allocationID), (String)Matchers.any(String.class), (UUID)Matchers.any(UUID.class), (Time)Matchers.any(Time.class));
        }
    }
}

