/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.runtime.concurrent.Future;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcMethod;
import org.apache.flink.runtime.rpc.RpcTimeout;
import org.apache.flink.util.ReflectionUtil;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcCompletenessTest
extends TestLogger {
    private static Logger LOG = LoggerFactory.getLogger(RpcCompletenessTest.class);
    private static final Class<?> futureClass = Future.class;
    private static final Class<?> timeoutClass = Time.class;

    @Test
    public void testRpcCompleteness() {
        Reflections reflections = new Reflections("org.apache.flink", new Scanner[0]);
        Set classes = reflections.getSubTypesOf(RpcEndpoint.class);
        Iterator i$ = classes.iterator();
        block0: while (i$.hasNext()) {
            Class rpcGatewayType;
            Class rpcEndpoint;
            Class c = rpcEndpoint = (Class)i$.next();
            LOG.debug("-------------");
            LOG.debug("c: {}", (Object)c);
            if (Modifier.isAbstract(c.getModifiers())) {
                LOG.debug("Skipping abstract class");
                continue;
            }
            TypeVariable<Class<T>>[] typeParameters = c.getTypeParameters();
            LOG.debug("Checking {} parameters.", (Object)typeParameters.length);
            for (int i = 0; i < typeParameters.length; ++i) {
                for (Type bound : typeParameters[i].getBounds()) {
                    LOG.debug("checking bound {} of type parameter {}", (Object)bound, typeParameters[i]);
                    if (!bound.toString().equals("interface " + RpcGateway.class.getName())) continue;
                    if (i > 0) {
                        Assert.fail((String)("Type parameter for RpcGateway should come first in " + c));
                    }
                    LOG.debug("Skipping class with type parameter bound to RpcGateway.");
                    continue block0;
                }
            }
            do {
                LOG.debug("checking type argument of class: {}", (Object)c);
                rpcGatewayType = ReflectionUtil.getTemplateType1((Class)c);
                LOG.debug("type argument is: {}", (Object)rpcGatewayType);
                c = c.getSuperclass();
            } while (!RpcGateway.class.isAssignableFrom(rpcGatewayType));
            LOG.debug("Checking RRC completeness of endpoint '{}' with gateway '{}'", (Object)rpcEndpoint.getSimpleName(), (Object)rpcGatewayType.getSimpleName());
            this.checkCompleteness(rpcEndpoint, rpcGatewayType);
        }
    }

    private void checkCompleteness(Class<? extends RpcEndpoint> rpcEndpoint, Class<? extends RpcGateway> rpcGateway) {
        List<Method> rpcMethodsFromGateway = this.getRpcMethodsFromGateway(rpcGateway);
        Method[] gatewayMethods = rpcMethodsFromGateway.toArray(new Method[rpcMethodsFromGateway.size()]);
        Method[] serverMethods = rpcEndpoint.getMethods();
        HashMap rpcMethods = new HashMap();
        HashSet<Method> unmatchedRpcMethods = new HashSet<Method>();
        for (Method serverMethod : serverMethods) {
            Set<Method> methods;
            if (!serverMethod.isAnnotationPresent(RpcMethod.class)) continue;
            if (rpcMethods.containsKey(serverMethod.getName())) {
                methods = (Set)rpcMethods.get(serverMethod.getName());
                methods.add(serverMethod);
                rpcMethods.put(serverMethod.getName(), methods);
            } else {
                methods = new HashSet<Method>();
                methods.add(serverMethod);
                rpcMethods.put(serverMethod.getName(), methods);
            }
            unmatchedRpcMethods.add(serverMethod);
        }
        for (Method gatewayMethod : gatewayMethods) {
            Assert.assertTrue((String)("The rpc endpoint " + rpcEndpoint.getName() + " does not contain a RpcMethod " + "annotated method with the same name and signature " + this.generateEndpointMethodSignature(gatewayMethod) + "."), (boolean)rpcMethods.containsKey(gatewayMethod.getName()));
            this.checkGatewayMethod(gatewayMethod);
            if (this.matchGatewayMethodWithEndpoint(gatewayMethod, (Set)rpcMethods.get(gatewayMethod.getName()), unmatchedRpcMethods)) continue;
            Assert.fail((String)("Could not find a RpcMethod annotated method in rpc endpoint " + rpcEndpoint.getName() + " matching the rpc gateway method " + this.generateEndpointMethodSignature(gatewayMethod) + " defined in the rpc gateway " + rpcGateway.getName() + "."));
        }
        if (!unmatchedRpcMethods.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (Method unmatchedRpcMethod : unmatchedRpcMethods) {
                builder.append(unmatchedRpcMethod).append("\n");
            }
            Assert.fail((String)("The rpc endpoint " + rpcEndpoint.getName() + " contains rpc methods which " + "are not matched to gateway methods of " + rpcGateway.getName() + ":\n" + builder.toString()));
        }
    }

    private void checkGatewayMethod(Method gatewayMethod) {
        if (!gatewayMethod.getReturnType().equals(Void.TYPE)) {
            Assert.assertTrue((String)("The return type of method " + gatewayMethod.getName() + " in the rpc gateway " + gatewayMethod.getDeclaringClass().getName() + " is non void and not a " + "future. Non-void return types have to be returned as a future."), (boolean)gatewayMethod.getReturnType().equals(futureClass));
        }
        Annotation[][] parameterAnnotations = gatewayMethod.getParameterAnnotations();
        Class<?>[] parameterTypes = gatewayMethod.getParameterTypes();
        int rpcTimeoutParameters = 0;
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            if (!RpcCompletenessTest.isRpcTimeout(parameterAnnotations[i])) continue;
            Assert.assertTrue((String)("The rpc timeout has to be of type " + timeoutClass.getName() + "."), (boolean)parameterTypes[i].equals(timeoutClass));
            ++rpcTimeoutParameters;
        }
        Assert.assertTrue((String)("The gateway method " + gatewayMethod + " must have at most one RpcTimeout " + "annotated parameter."), (rpcTimeoutParameters <= 1 ? 1 : 0) != 0);
    }

    private boolean matchGatewayMethodWithEndpoint(Method gatewayMethod, Set<Method> endpointMethods, Set<Method> unmatchedRpcMethods) {
        for (Method endpointMethod : endpointMethods) {
            if (!this.checkMethod(gatewayMethod, endpointMethod)) continue;
            unmatchedRpcMethods.remove(endpointMethod);
            return true;
        }
        return false;
    }

    private boolean checkMethod(Method gatewayMethod, Method endpointMethod) {
        int i;
        Class<?>[] gatewayParameterTypes = gatewayMethod.getParameterTypes();
        Annotation[][] gatewayParameterAnnotations = gatewayMethod.getParameterAnnotations();
        Class<?>[] endpointParameterTypes = endpointMethod.getParameterTypes();
        ArrayList filteredGatewayParameterTypes = new ArrayList();
        Assert.assertEquals((long)gatewayParameterTypes.length, (long)gatewayParameterAnnotations.length);
        for (i = 0; i < gatewayParameterTypes.length; ++i) {
            if (RpcCompletenessTest.isRpcTimeout(gatewayParameterAnnotations[i])) continue;
            filteredGatewayParameterTypes.add(gatewayParameterTypes[i]);
        }
        if (filteredGatewayParameterTypes.size() != endpointParameterTypes.length) {
            return false;
        }
        for (i = 0; i < filteredGatewayParameterTypes.size(); ++i) {
            if (this.checkType((Class)filteredGatewayParameterTypes.get(i), endpointParameterTypes[i])) continue;
            return false;
        }
        if (endpointMethod.getReturnType() == Void.TYPE) {
            if (gatewayMethod.getReturnType() != Void.TYPE) {
                return false;
            }
        } else {
            Class<?> futureClass = gatewayMethod.getReturnType();
            if (!futureClass.equals(RpcCompletenessTest.futureClass)) {
                return false;
            }
            ReflectionUtil.FullTypeInfo fullValueTypeInfo = ReflectionUtil.getFullTemplateType((Type)gatewayMethod.getGenericReturnType(), (int)0);
            if (endpointMethod.getReturnType().equals(futureClass)) {
                ReflectionUtil.FullTypeInfo fullRpcEndpointValueTypeInfo = ReflectionUtil.getFullTemplateType((Type)endpointMethod.getGenericReturnType(), (int)0);
                if (fullValueTypeInfo != null && fullRpcEndpointValueTypeInfo != null) {
                    Iterator valueClasses = fullValueTypeInfo.getClazzIterator();
                    Iterator rpcClasses = fullRpcEndpointValueTypeInfo.getClazzIterator();
                    while (valueClasses.hasNext() && rpcClasses.hasNext()) {
                        if (this.checkType((Class)valueClasses.next(), (Class)rpcClasses.next())) continue;
                        return false;
                    }
                    return !valueClasses.hasNext() && !rpcClasses.hasNext();
                }
            } else if (fullValueTypeInfo != null && !this.checkType(fullValueTypeInfo.getClazz(), endpointMethod.getReturnType())) {
                return false;
            }
        }
        return gatewayMethod.getName().equals(endpointMethod.getName());
    }

    private boolean checkType(Class<?> firstType, Class<?> secondType) {
        Class<?> firstResolvedType = firstType.isPrimitive() ? RpcCompletenessTest.resolvePrimitiveType(firstType) : firstType;
        Class<?> secondResolvedType = secondType.isPrimitive() ? RpcCompletenessTest.resolvePrimitiveType(secondType) : secondType;
        return firstResolvedType.equals(secondResolvedType);
    }

    private String generateEndpointMethodSignature(Method method) {
        StringBuilder builder = new StringBuilder();
        if (method.getReturnType().equals(Void.TYPE)) {
            builder.append("void").append(" ");
        } else if (method.getReturnType().equals(futureClass)) {
            ReflectionUtil.FullTypeInfo fullTypeInfo = ReflectionUtil.getFullTemplateType((Type)method.getGenericReturnType(), (int)0);
            builder.append(futureClass.getSimpleName()).append("<").append(fullTypeInfo != null ? fullTypeInfo.toString() : "").append(">");
            if (fullTypeInfo != null) {
                builder.append("/").append(fullTypeInfo);
            }
            builder.append(" ");
        } else {
            return "Invalid rpc method signature.";
        }
        builder.append(method.getName()).append("(");
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Assert.assertEquals((long)parameterTypes.length, (long)parameterAnnotations.length);
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (RpcCompletenessTest.isRpcTimeout(parameterAnnotations[i])) continue;
            builder.append(parameterTypes[i].getName());
            if (i >= parameterTypes.length - 1) continue;
            builder.append(", ");
        }
        builder.append(")");
        return builder.toString();
    }

    private static boolean isRpcTimeout(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(RpcTimeout.class)) continue;
            return true;
        }
        return false;
    }

    private static Class<?> resolvePrimitiveType(Class<?> primitveType) {
        assert (primitveType.isPrimitive());
        BasicTypeInfo typeInformation = BasicTypeInfo.getInfoFor(primitveType);
        if (typeInformation != null) {
            return typeInformation.getTypeClass();
        }
        throw new RuntimeException("Could not retrive basic type information for primitive type " + primitveType + '.');
    }

    private List<Method> getRpcMethodsFromGateway(Class<? extends RpcGateway> interfaceClass) {
        if (!interfaceClass.isInterface()) {
            Assert.fail((String)(interfaceClass.getName() + " is not a interface"));
        }
        ArrayList<Method> allMethods = new ArrayList<Method>();
        if (interfaceClass.equals(RpcGateway.class)) {
            return allMethods;
        }
        Collections.addAll(allMethods, interfaceClass.getDeclaredMethods());
        Class<?>[] arr$ = interfaceClass.getInterfaces();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Class<?> superClass;
            Class<?> gatewayClass = superClass = arr$[i$];
            allMethods.addAll(this.getRpcMethodsFromGateway(gatewayClass));
        }
        return allMethods;
    }
}

