/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc;

import akka.actor.ActorSystem;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.concurrent.Future;
import org.apache.flink.runtime.rpc.akka.AkkaRpcService;
import org.apache.flink.runtime.rpc.exceptions.RpcConnectionException;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.junit.Assert;
import org.junit.Test;
import scala.Option;
import scala.Tuple2;

public class RpcConnectionTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectFailure() {
        ActorSystem actorSystem = null;
        AkkaRpcService rpcService = null;
        try {
            actorSystem = AkkaUtils.createActorSystem((Configuration)new Configuration(), (Option)Option.apply((Object)new Tuple2((Object)"localhost", (Object)0)));
            rpcService = new AkkaRpcService(actorSystem, Time.of((long)10000000L, (TimeUnit)TimeUnit.SECONDS));
            Future future = rpcService.connect("foo.bar.com.test.invalid", TaskExecutorGateway.class);
            future.get(10000000L, TimeUnit.SECONDS);
            Assert.fail((String)"should never complete normally");
        }
        catch (TimeoutException e) {
            Assert.fail((String)"should not fail with a generic timeout exception");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof RpcConnectionException));
            Assert.assertTrue((String)"wrong error message", (boolean)e.getCause().getMessage().contains("foo.bar.com.test.invalid"));
        }
        catch (Throwable t) {
            Assert.fail((String)("wrong exception: " + t));
        }
        finally {
            if (rpcService != null) {
                rpcService.stopService();
            }
            if (actorSystem != null) {
                actorSystem.shutdown();
            }
        }
    }
}

