/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.runtime.concurrent.CompletableFuture;
import org.apache.flink.runtime.concurrent.Future;
import org.apache.flink.runtime.concurrent.impl.FlinkCompletableFuture;
import org.apache.flink.runtime.rpc.RpcGateway;

public abstract class TestingGatewayBase
implements RpcGateway {
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private final String address;

    protected TestingGatewayBase(String address) {
        this.address = address;
    }

    protected TestingGatewayBase() {
        this("localhost");
    }

    public void stop() {
        this.executor.shutdownNow();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.executor.shutdownNow();
    }

    public String getAddress() {
        return this.address;
    }

    public String getHostname() {
        return this.address;
    }

    public <T> Future<T> futureWithTimeout(long timeoutMillis) {
        FlinkCompletableFuture future = new FlinkCompletableFuture();
        this.executor.schedule(new FutureTimeout((CompletableFuture)future), timeoutMillis, TimeUnit.MILLISECONDS);
        return future;
    }

    private static final class FutureTimeout
    implements Runnable {
        private final CompletableFuture<?> promise;

        private FutureTimeout(CompletableFuture<?> promise) {
            this.promise = promise;
        }

        @Override
        public void run() {
            try {
                this.promise.completeExceptionally((Throwable)new TimeoutException());
            }
            catch (Throwable t) {
                System.err.println("CAUGHT AN ERROR IN THE TEST: " + t.getMessage());
                t.printStackTrace();
            }
        }
    }
}

