/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc;

import java.net.UnknownHostException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.concurrent.Future;
import org.apache.flink.runtime.concurrent.impl.FlinkCompletableFuture;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.akka.AkkaRpcService;
import org.apache.flink.util.Preconditions;

public class TestingRpcService
extends AkkaRpcService {
    private final ConcurrentHashMap<String, RpcGateway> registeredConnections = new ConcurrentHashMap();

    public TestingRpcService() throws UnknownHostException {
        this(new Configuration());
    }

    public TestingRpcService(Configuration configuration) throws UnknownHostException {
        super(AkkaUtils.createLocalActorSystem((Configuration)configuration), Time.seconds((long)10L));
    }

    public void stopService() {
        super.stopService();
        this.registeredConnections.clear();
    }

    public void registerGateway(String address, RpcGateway gateway) {
        Preconditions.checkNotNull((Object)address);
        Preconditions.checkNotNull((Object)gateway);
        if (this.registeredConnections.putIfAbsent(address, gateway) != null) {
            throw new IllegalStateException("a gateway is already registered under " + address);
        }
    }

    public <C extends RpcGateway> Future<C> connect(String address, Class<C> clazz) {
        RpcGateway gateway = this.registeredConnections.get(address);
        if (gateway != null) {
            if (clazz.isAssignableFrom(gateway.getClass())) {
                RpcGateway typedGateway = gateway;
                return FlinkCompletableFuture.completed((Object)typedGateway);
            }
            return FlinkCompletableFuture.completedExceptionally((Throwable)new Exception("Gateway registered under " + address + " is not of type " + clazz));
        }
        return FlinkCompletableFuture.completedExceptionally((Throwable)new Exception("No gateway registered under that name"));
    }

    public void clearGateways() {
        this.registeredConnections.clear();
    }
}

