/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.security.HadoopSecurityContext;
import org.apache.flink.runtime.security.NoOpSecurityContext;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.security.modules.SecurityModule;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class SecurityUtilsTest {
    @AfterClass
    public static void afterClass() {
        SecurityUtils.uninstall();
    }

    @Test
    public void testModuleInstall() throws Exception {
        SecurityUtils.SecurityConfiguration sc = new SecurityUtils.SecurityConfiguration(new Configuration(), new org.apache.hadoop.conf.Configuration(), Collections.singletonList(TestSecurityModule.class));
        SecurityUtils.install((SecurityUtils.SecurityConfiguration)sc);
        Assert.assertEquals((long)1L, (long)SecurityUtils.getInstalledModules().size());
        TestSecurityModule testModule = (TestSecurityModule)SecurityUtils.getInstalledModules().get(0);
        Assert.assertTrue((boolean)testModule.installed);
        SecurityUtils.uninstall();
        Assert.assertNull((Object)SecurityUtils.getInstalledModules());
        Assert.assertFalse((boolean)testModule.installed);
    }

    @Test
    public void testSecurityContext() throws Exception {
        SecurityUtils.SecurityConfiguration sc = new SecurityUtils.SecurityConfiguration(new Configuration(), new org.apache.hadoop.conf.Configuration(), Collections.singletonList(TestSecurityModule.class));
        SecurityUtils.install((SecurityUtils.SecurityConfiguration)sc);
        Assert.assertEquals(HadoopSecurityContext.class, SecurityUtils.getInstalledContext().getClass());
        SecurityUtils.uninstall();
        Assert.assertEquals(NoOpSecurityContext.class, SecurityUtils.getInstalledContext().getClass());
    }

    @Test
    public void testKerberosLoginContextParsing() {
        List<String> expectedLoginContexts = Arrays.asList("Foo bar", "Client");
        Configuration testFlinkConf = new Configuration();
        testFlinkConf.setString(SecurityOptions.KERBEROS_LOGIN_CONTEXTS, "Foo bar,Client");
        SecurityUtils.SecurityConfiguration testSecurityConf = new SecurityUtils.SecurityConfiguration(testFlinkConf, new org.apache.hadoop.conf.Configuration(), Collections.singletonList(TestSecurityModule.class));
        Assert.assertEquals(expectedLoginContexts, (Object)testSecurityConf.getLoginContextNames());
        testFlinkConf = new Configuration();
        testFlinkConf.setString(SecurityOptions.KERBEROS_LOGIN_CONTEXTS, "Foo bar , Client");
        testSecurityConf = new SecurityUtils.SecurityConfiguration(testFlinkConf, new org.apache.hadoop.conf.Configuration(), Collections.singletonList(TestSecurityModule.class));
        Assert.assertEquals(expectedLoginContexts, (Object)testSecurityConf.getLoginContextNames());
        testFlinkConf = new Configuration();
        testFlinkConf.setString(SecurityOptions.KERBEROS_LOGIN_CONTEXTS, " Foo bar , Client ");
        testSecurityConf = new SecurityUtils.SecurityConfiguration(testFlinkConf, new org.apache.hadoop.conf.Configuration(), Collections.singletonList(TestSecurityModule.class));
        Assert.assertEquals(expectedLoginContexts, (Object)testSecurityConf.getLoginContextNames());
        testFlinkConf = new Configuration();
        testFlinkConf.setString(SecurityOptions.KERBEROS_LOGIN_CONTEXTS, "Foo bar,,Client");
        testSecurityConf = new SecurityUtils.SecurityConfiguration(testFlinkConf, new org.apache.hadoop.conf.Configuration(), Collections.singletonList(TestSecurityModule.class));
        Assert.assertEquals(expectedLoginContexts, (Object)testSecurityConf.getLoginContextNames());
        testFlinkConf = new Configuration();
        testFlinkConf.setString(SecurityOptions.KERBEROS_LOGIN_CONTEXTS, "Foo bar, ,, Client,");
        testSecurityConf = new SecurityUtils.SecurityConfiguration(testFlinkConf, new org.apache.hadoop.conf.Configuration(), Collections.singletonList(TestSecurityModule.class));
        Assert.assertEquals(expectedLoginContexts, (Object)testSecurityConf.getLoginContextNames());
    }

    static class TestSecurityModule
    implements SecurityModule {
        boolean installed;

        TestSecurityModule() {
        }

        public void install(SecurityUtils.SecurityConfiguration configuration) throws SecurityModule.SecurityInstallException {
            this.installed = true;
        }

        public void uninstall() throws SecurityModule.SecurityInstallException {
            this.installed = false;
        }
    }
}

