/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.StateBackendTestBase;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.filesystem.FileStateHandle;
import org.apache.flink.runtime.state.filesystem.FsStateBackend;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileStateBackendTest
extends StateBackendTestBase<FsStateBackend> {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Override
    protected FsStateBackend getStateBackend() throws Exception {
        File checkpointPath = this.tempFolder.newFolder();
        return new FsStateBackend(FileStateBackendTest.localFileUri(checkpointPath), this.useAsyncMode());
    }

    protected boolean useAsyncMode() {
        return false;
    }

    @Override
    @Test
    public void testValueStateRestoreWithWrongSerializers() {
    }

    @Override
    @Test
    public void testListStateRestoreWithWrongSerializers() {
    }

    @Override
    @Test
    public void testReducingStateRestoreWithWrongSerializers() {
    }

    @Override
    @Test
    public void testMapStateRestoreWithWrongSerializers() {
    }

    @Test
    public void testStateOutputStream() throws IOException {
        File basePath = this.tempFolder.newFolder().getAbsoluteFile();
        try {
            StreamStateHandle handle4;
            FsStateBackend backend = (FsStateBackend)CommonTestUtils.createCopySerializable((Serializable)new FsStateBackend(basePath.toURI(), 15));
            JobID jobId = new JobID();
            File checkpointPath = new File(basePath.getAbsolutePath(), jobId.toString());
            CheckpointStreamFactory streamFactory = backend.createStreamFactory(jobId, "test_op");
            byte[] state1 = new byte[0x137331];
            byte[] state2 = new byte[1];
            byte[] state3 = new byte[]{};
            byte[] state4 = new byte[177];
            Random rnd = new Random();
            rnd.nextBytes(state1);
            rnd.nextBytes(state2);
            rnd.nextBytes(state3);
            rnd.nextBytes(state4);
            long checkpointId = 97231523452L;
            CheckpointStreamFactory.CheckpointStateOutputStream stream1 = streamFactory.createCheckpointStateOutputStream(checkpointId, System.currentTimeMillis());
            CheckpointStreamFactory.CheckpointStateOutputStream stream2 = streamFactory.createCheckpointStateOutputStream(checkpointId, System.currentTimeMillis());
            CheckpointStreamFactory.CheckpointStateOutputStream stream3 = streamFactory.createCheckpointStateOutputStream(checkpointId, System.currentTimeMillis());
            stream1.write(state1);
            stream2.write(state2);
            stream3.write(state3);
            FileStateHandle handle1 = (FileStateHandle)stream1.closeAndGetHandle();
            ByteStreamStateHandle handle2 = (ByteStreamStateHandle)stream2.closeAndGetHandle();
            ByteStreamStateHandle handle3 = (ByteStreamStateHandle)stream3.closeAndGetHandle();
            try (CheckpointStreamFactory.CheckpointStateOutputStream stream4 = streamFactory.createCheckpointStateOutputStream(checkpointId, System.currentTimeMillis());){
                stream4.write(state4);
                handle4 = stream4.closeAndGetHandle();
            }
            CheckpointStreamFactory.CheckpointStateOutputStream stream5 = streamFactory.createCheckpointStateOutputStream(checkpointId, System.currentTimeMillis());
            stream5.write(state4);
            stream5.close();
            try {
                stream5.closeAndGetHandle();
                Assert.fail();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            FileStateBackendTest.validateBytesInStream((InputStream)handle1.openInputStream(), state1);
            handle1.discardState();
            Assert.assertFalse((boolean)FileStateBackendTest.isDirectoryEmpty(basePath));
            FileStateBackendTest.ensureLocalFileDeleted(handle1.getFilePath());
            FileStateBackendTest.validateBytesInStream((InputStream)handle2.openInputStream(), state2);
            handle2.discardState();
            Assert.assertNull((Object)handle3);
            FileStateBackendTest.validateBytesInStream((InputStream)handle4.openInputStream(), state4);
            handle4.discardState();
            Assert.assertTrue((boolean)FileStateBackendTest.isDirectoryEmpty(checkpointPath));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static void ensureLocalFileDeleted(Path path) {
        URI uri = path.toUri();
        if (!"file".equals(uri.getScheme())) {
            throw new IllegalArgumentException("not a local path");
        }
        File file = new File(uri.getPath());
        Assert.assertFalse((String)"file not properly deleted", (boolean)file.exists());
    }

    private static void deleteDirectorySilently(File dir) {
        try {
            FileUtils.deleteDirectory((File)dir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean isDirectoryEmpty(File directory) {
        if (!directory.exists()) {
            return true;
        }
        String[] nested = directory.list();
        return nested == null || nested.length == 0;
    }

    private static String localFileUri(File path) {
        return path.toURI().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateBytesInStream(InputStream is, byte[] data) throws IOException {
        try {
            int pos;
            int read;
            byte[] holder = new byte[data.length];
            for (pos = 0; pos < holder.length && (read = is.read(holder, pos, holder.length - pos)) != -1; pos += read) {
            }
            Assert.assertEquals((String)"not enough data", (long)holder.length, (long)pos);
            Assert.assertEquals((String)"too much data", (long)-1L, (long)is.read());
            Assert.assertArrayEquals((String)"wrong data", (byte[])data, (byte[])holder);
        }
        finally {
            is.close();
        }
    }

    @Override
    @Ignore
    @Test
    public void testConcurrentMapIfQueryable() throws Exception {
        super.testConcurrentMapIfQueryable();
    }
}

