/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Map;
import java.util.Random;
import org.apache.flink.runtime.checkpoint.savepoint.CheckpointTestUtils;
import org.apache.flink.runtime.state.IncrementalKeyedStateHandle;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.SharedStateRegistryKey;
import org.apache.flink.runtime.state.StateHandleID;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;

public class IncrementalKeyedStateHandleTest {
    @Test
    public void testUnregisteredDiscarding() throws Exception {
        IncrementalKeyedStateHandle stateHandle = IncrementalKeyedStateHandleTest.create(new Random(42L));
        stateHandle.discardState();
        for (StreamStateHandle handle : stateHandle.getPrivateState().values()) {
            ((StreamStateHandle)Mockito.verify((Object)handle)).discardState();
        }
        for (StreamStateHandle handle : stateHandle.getSharedState().values()) {
            ((StreamStateHandle)Mockito.verify((Object)handle)).discardState();
        }
        ((StreamStateHandle)Mockito.verify((Object)stateHandle.getMetaStateHandle())).discardState();
    }

    @Test
    public void testSharedStateDeRegistration() throws Exception {
        SharedStateRegistryKey registryKey;
        Random rnd = new Random(42L);
        SharedStateRegistry registry = (SharedStateRegistry)PowerMockito.spy((Object)new SharedStateRegistry());
        IncrementalKeyedStateHandle stateHandle1 = IncrementalKeyedStateHandleTest.create(new Random(42L));
        IncrementalKeyedStateHandle stateHandle2 = IncrementalKeyedStateHandleTest.create(new Random(42L));
        for (Map.Entry entry : stateHandle1.getSharedState().entrySet()) {
            registryKey = stateHandle1.createSharedStateRegistryKeyFromFileName((StateHandleID)entry.getKey());
            ((SharedStateRegistry)Mockito.verify((Object)registry, (VerificationMode)Mockito.times((int)0))).unregisterReference(registryKey);
            ((StreamStateHandle)Mockito.verify(entry.getValue(), (VerificationMode)Mockito.times((int)0))).discardState();
        }
        for (Map.Entry entry : stateHandle2.getSharedState().entrySet()) {
            registryKey = stateHandle1.createSharedStateRegistryKeyFromFileName((StateHandleID)entry.getKey());
            ((SharedStateRegistry)Mockito.verify((Object)registry, (VerificationMode)Mockito.times((int)0))).unregisterReference(registryKey);
            ((StreamStateHandle)Mockito.verify(entry.getValue(), (VerificationMode)Mockito.times((int)0))).discardState();
        }
        stateHandle1.registerSharedStates(registry);
        stateHandle2.registerSharedStates(registry);
        for (Map.Entry stateHandleEntry : stateHandle1.getSharedState().entrySet()) {
            registryKey = stateHandle1.createSharedStateRegistryKeyFromFileName((StateHandleID)stateHandleEntry.getKey());
            ((SharedStateRegistry)Mockito.verify((Object)registry)).registerReference(registryKey, (StreamStateHandle)stateHandleEntry.getValue());
        }
        for (Map.Entry stateHandleEntry : stateHandle2.getSharedState().entrySet()) {
            registryKey = stateHandle1.createSharedStateRegistryKeyFromFileName((StateHandleID)stateHandleEntry.getKey());
            ((SharedStateRegistry)Mockito.verify((Object)registry)).registerReference(registryKey, (StreamStateHandle)stateHandleEntry.getValue());
        }
        stateHandle1.discardState();
        for (Map.Entry entry : stateHandle1.getSharedState().entrySet()) {
            registryKey = stateHandle1.createSharedStateRegistryKeyFromFileName((StateHandleID)entry.getKey());
            ((SharedStateRegistry)Mockito.verify((Object)registry, (VerificationMode)Mockito.times((int)1))).unregisterReference(registryKey);
            ((StreamStateHandle)Mockito.verify(entry.getValue(), (VerificationMode)Mockito.times((int)0))).discardState();
        }
        for (StreamStateHandle handle : stateHandle2.getSharedState().values()) {
            ((StreamStateHandle)Mockito.verify((Object)handle, (VerificationMode)Mockito.times((int)0))).discardState();
        }
        for (Map.Entry handleEntry : stateHandle1.getPrivateState().entrySet()) {
            registryKey = stateHandle1.createSharedStateRegistryKeyFromFileName((StateHandleID)handleEntry.getKey());
            ((SharedStateRegistry)Mockito.verify((Object)registry, (VerificationMode)Mockito.times((int)0))).unregisterReference(registryKey);
            ((StreamStateHandle)Mockito.verify(handleEntry.getValue(), (VerificationMode)Mockito.times((int)1))).discardState();
        }
        for (Map.Entry handleEntry : stateHandle2.getPrivateState().entrySet()) {
            registryKey = stateHandle1.createSharedStateRegistryKeyFromFileName((StateHandleID)handleEntry.getKey());
            ((SharedStateRegistry)Mockito.verify((Object)registry, (VerificationMode)Mockito.times((int)0))).unregisterReference(registryKey);
            ((StreamStateHandle)Mockito.verify(handleEntry.getValue(), (VerificationMode)Mockito.times((int)0))).discardState();
        }
        ((StreamStateHandle)Mockito.verify((Object)stateHandle1.getMetaStateHandle(), (VerificationMode)Mockito.times((int)1))).discardState();
        ((StreamStateHandle)Mockito.verify((Object)stateHandle2.getMetaStateHandle(), (VerificationMode)Mockito.times((int)0))).discardState();
        stateHandle2.discardState();
        for (Map.Entry entry : stateHandle1.getSharedState().entrySet()) {
            registryKey = stateHandle1.createSharedStateRegistryKeyFromFileName((StateHandleID)entry.getKey());
            ((SharedStateRegistry)Mockito.verify((Object)registry, (VerificationMode)Mockito.times((int)2))).unregisterReference(registryKey);
            ((StreamStateHandle)Mockito.verify(entry.getValue())).discardState();
        }
        for (Map.Entry entry : stateHandle2.getSharedState().entrySet()) {
            registryKey = stateHandle1.createSharedStateRegistryKeyFromFileName((StateHandleID)entry.getKey());
            ((SharedStateRegistry)Mockito.verify((Object)registry, (VerificationMode)Mockito.times((int)2))).unregisterReference(registryKey);
            ((StreamStateHandle)Mockito.verify(entry.getValue())).discardState();
        }
        ((StreamStateHandle)Mockito.verify((Object)stateHandle1.getMetaStateHandle(), (VerificationMode)Mockito.times((int)1))).discardState();
        ((StreamStateHandle)Mockito.verify((Object)stateHandle2.getMetaStateHandle(), (VerificationMode)Mockito.times((int)1))).discardState();
    }

    private static IncrementalKeyedStateHandle create(Random rnd) {
        return new IncrementalKeyedStateHandle("test", KeyGroupRange.of((int)0, (int)0), 1L, IncrementalKeyedStateHandleTest.placeSpies(CheckpointTestUtils.createRandomStateHandleMap(rnd)), IncrementalKeyedStateHandleTest.placeSpies(CheckpointTestUtils.createRandomStateHandleMap(rnd)), (StreamStateHandle)PowerMockito.spy((Object)CheckpointTestUtils.createDummyStreamStateHandle(rnd)));
    }

    private static Map<StateHandleID, StreamStateHandle> placeSpies(Map<StateHandleID, StreamStateHandle> map) {
        for (Map.Entry<StateHandleID, StreamStateHandle> entry : map.entrySet()) {
            entry.setValue((StreamStateHandle)PowerMockito.spy((Object)entry.getValue()));
        }
        return map;
    }
}

